<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quick_setup_kepala_cabang extends MY_Controller{

  public function __construct()
  {
    parent::__construct();
    $this->load->model('quick_setup_kepala_cabang_m', 'q_kepala_cabang_m');
    $this->load->model('quick_setup_staff_m', 'q_setup_staff_m');
    $this->load->model(['wizard_m', 'Data_diri_m']);
  }

  function index()
  {
    $data['aktif']            = 'kelola_mudah';
    $data['judul']            = 'Quick Setup Kepala Cabang';
    $data['jenis']            = 'kepala_cabang';
    $data['menu']             = $this->load->view('main_menu', $data, true);
    $data['menu_quick_setup'] = $this->load->view('quick_setup/menu', $data, true);
    $data['main']             = $this->load->view('quick_setup/kepala/cabang/main', $data, true);
    $data['table']            = $this->load->view('quick_setup/kepala/cabang/table', $data, true);
    $data['content']          = $this->load->view('quick_setup/main', $data, true);
    $this->load->view('main_template', $data, false);
  }

  public function list_data(){
		$list = $this->q_kepala_cabang_m->get_datatables();
		$data = array();
    $no = $_POST['start'];
		foreach ($list as $field) {
      $no++;
			$row = array();
      $row[] = $no;
			$row[] = $field->nik;
			$row[] = $field->nama_lengkap;
			$row[] = $field->kode.' - '.$field->cabang;
      $row[] = '<a href="#" data-target="tooltip" title="Edit" style="color:#434343;" class="text-warning"
                  onclick="edit(\''.$field->id_karyawan.'\')">
                  <i id="" class="btn_edit fa fa-edit"></i>
                </a>&nbsp;
                <a href="#" data-target="tooltip" title="Delete" style="color:#434343;" class="text-danger"
                  onclick="hapus(\''.$field->id_karyawan.'\')">
                    <i id="" class="btn_delete fa fa-trash"></i>
                </a>';

			$data[] = $row;
		}

		$output = array("draw"            => $_POST['draw'],
						"recordsTotal"    => $this->q_kepala_cabang_m->count_all(),
						"recordsFiltered" => $this->q_kepala_cabang_m->count_filtered(),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

  function cek_jabatan_kepala_cabang() {
    $cek = $this->q_kepala_cabang_m->cek_jabatan_kepala_cabang();
    if($cek->num_rows() == 0) {
      //create jabatan kepala cabang
      return $this->q_kepala_cabang_m->create_jabatan_kepala_cabang();
    } else {
      return $cek->row()->id_jabatan;
    }
  }

  function save() {
    $cek_limit_max_karyawan = $this->q_setup_staff_m->cek_limit_max_karyawan();
    if($cek_limit_max_karyawan) {
      return __response_save(false, ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL, data karyawan sudah mencapai batas maksimal</font>']);
    } else {
      $cek_jabatan_kepala_cabang = $this->cek_jabatan_kepala_cabang();
  
      $nik          = trim($this->input->post('nik'));
      $nama         = $this->input->post('nama');
      $cabang       = $this->input->post('cabang');
      $username     = trim($this->input->post('username'));
      $id_company   = $this->session->userdata('id_company');
      $id_karyawan  = $this->wizard_m->generate_id('data_karyawan','id_karyawan', 4, $id_company);
      $id_user	    = $this->wizard_m->generate_id('users','id_user', 4, $id_company, 3);
  
      $data = array(
        'id_cabang'     => $cabang,
        'id_jabatan'    => $cek_jabatan_kepala_cabang,
        'id_departemen' => '',
        'nik'           => $nik,
        'nama'          => $nama,
        'username'      => $username,
        'password'      => $username,
        'id_company'    => $id_company,
        'id_karyawan'   => $id_karyawan,
        'id_user'       => $id_user
      );
  
      $buat_karyawan	= $this->wizard_m->buat_karyawan($data);
      $data_karyawan	= $buat_karyawan['data_karyawan'];
      $data_users		  = $buat_karyawan['data_users'];
  
      # INSERT KACAB BARU
      $id_kacab = $this->fungsi->getNextId('p_kacab', 'id', $this->id_company, 3);
      $data_kacab = array(
          "id"          => $id_kacab,
          "id_karyawan" => $id_karyawan,
          "id_cabang"   => $cabang,
          "flag"        => "1",
          "id_company"  => $this->id_company
      );
  
      $this->db->trans_start();
      $this->db->insert('data_karyawan', $data_karyawan);
      $this->db->insert('users', $data_users);
      $this->db->insert('p_kacab', $data_kacab);
      $this->db->trans_complete();
  
      if ($this->db->trans_status() === FALSE)
      {
        return __response_save(false);
      } else {
        $this->Data_diri_m->insert_payroll($id_karyawan);
        return __response_save(true);
      }
    }
  }

  function update() {
    $nik         = trim($this->input->post('nik'));
    $nama        = $this->input->post('nama');
    $cabang      = $this->input->post('cabang');
    $username    = trim($this->input->post('username'));
    $id_karyawan = $this->input->post('id_karyawan');

    $data = array(
      'nik'           => $nik,
      'nama_lengkap'  => $nama,
      'id_cabang'     => $cabang
    );

    $data_user = array(
      'username'    => $username,
      'password'    => sha1(sha1(md5($username))),
      'password_2'  => $username
    );

    $this->q_kepala_cabang_m->update($data, $data_user, $id_karyawan);
  }

  function delete() {
    $id_karyawan  = $this->input->post('id_karyawan');
    $this->q_kepala_cabang_m->delete($id_karyawan);
  }

  function detail($id_karyawan) {
    $detail = $this->q_kepala_cabang_m->detail($id_karyawan);
    $data['nama']         = $detail->nama_lengkap;
    $data['nik']          = $detail->nik;
    $data['id_cabang']    = $detail->id_cabang;
    $data['text_cabang']  = $detail->kode.' - '.$detail->cabang;
    $data['username']     = $detail->username;
    $data['id_karyawan']  = $id_karyawan;
    echo json_encode($data);
  }

  function cek_nik($nik) {
    $cek = $this->q_kepala_cabang_m->cek_nik($nik);
    echo json_encode($cek->num_rows());
  }
}
