/*
SQLyog Community v13.1.4  (64 bit)
MySQL - 10.4.17-MariaDB-1:10.4.17+maria~buster-log : Database - absenku_master_custom
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`absenku_master_custom` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `absenku_master_custom`;

/*Table structure for table `absensi_masuk` */

DROP TABLE IF EXISTS `absensi_masuk`;

CREATE TABLE `absensi_masuk` (
  `id_absensi_masuk` varchar(50) NOT NULL COMMENT 'id_company + YYYYMM + 5 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jenis_absen` enum('reguler','shift','libur','cuti','izin','sakit') NOT NULL DEFAULT 'reguler',
  `jam_kerja` time NOT NULL,
  `jam_absen` datetime DEFAULT NULL,
  `terlambat` int(4) NOT NULL DEFAULT 0,
  `kode_absen` varchar(255) NOT NULL,
  `ket_kode` varchar(255) NOT NULL,
  `lokasi_absen` varchar(255) NOT NULL,
  `timezone` varchar(255) NOT NULL,
  `gmt` varchar(6) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `keterangan` text NOT NULL,
  `foto` text NOT NULL,
  `cron_status` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_absensi_masuk`),
  KEY `KEY` (`id_company`,`tgl_absen`,`id_karyawan`,`kode_absen`,`jenis_absen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `absensi_masuk` */

/*Table structure for table `absensi_pulang` */

DROP TABLE IF EXISTS `absensi_pulang`;

CREATE TABLE `absensi_pulang` (
  `id_absensi_pulang` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `id_masuk` varchar(50) NOT NULL DEFAULT '0' COMMENT 'absensi_masuk',
  `tgl_absen` date NOT NULL,
  `jam_kerja` time NOT NULL,
  `jam_absen` datetime NOT NULL,
  `pulang_cepat` int(4) NOT NULL COMMENT 'menit',
  `keterangan` text NOT NULL,
  `lokasi_absen` varchar(255) NOT NULL,
  `timezone` varchar(255) NOT NULL,
  `gmt` varchar(6) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_absensi_pulang`,`id_karyawan`,`id_masuk`,`tgl_absen`,`id_company`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`id_masuk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `absensi_pulang` */

/*Table structure for table `captcha` */

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `captcha_id` bigint(13) unsigned NOT NULL AUTO_INCREMENT,
  `captcha_time` int(10) unsigned NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `word` varchar(20) NOT NULL,
  PRIMARY KEY (`captcha_id`),
  KEY `word` (`word`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;

/*Data for the table `captcha` */

/*Table structure for table `ci_sessions` */

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `ci_sessions` */

/*Table structure for table `data_aktivitas` */

DROP TABLE IF EXISTS `data_aktivitas`;

CREATE TABLE `data_aktivitas` (
  `id_aktivitas` varchar(50) NOT NULL COMMENT 'id_company + yyyymmdd + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `waktu` datetime NOT NULL,
  `keterangan` varchar(250) NOT NULL,
  `lokasi` varchar(225) NOT NULL,
  `timezone` varchar(150) NOT NULL,
  `gmt` varchar(10) NOT NULL,
  `latitude` varchar(50) NOT NULL,
  `longitude` varchar(50) NOT NULL,
  `image` varchar(225) NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_aktivitas`),
  KEY `data_aktifitas` (`id_aktivitas`,`id_karyawan`,`lokasi`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_aktivitas` */

/*Table structure for table `data_berita` */

DROP TABLE IF EXISTS `data_berita`;

CREATE TABLE `data_berita` (
  `id_berita` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit urutan angka',
  `judul` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `creator` varchar(100) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `gambar` varchar(255) NOT NULL,
  `posting` enum('0','1') NOT NULL DEFAULT '0',
  `tgl_posting` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_berita`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_berita` */

/*Table structure for table `data_comment_berita` */

DROP TABLE IF EXISTS `data_comment_berita`;

CREATE TABLE `data_comment_berita` (
  `id_comment` int(11) NOT NULL AUTO_INCREMENT,
  `id_berita` int(11) NOT NULL,
  `sender` varchar(50) NOT NULL,
  `waktu` datetime NOT NULL,
  `content` text NOT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id_comment`),
  KEY `data_comment_berita` (`id_comment`,`id_berita`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_comment_berita` */

/*Table structure for table `data_comment_pengumuman` */

DROP TABLE IF EXISTS `data_comment_pengumuman`;

CREATE TABLE `data_comment_pengumuman` (
  `id_comment` int(11) NOT NULL AUTO_INCREMENT,
  `id_pengumuman` int(11) NOT NULL,
  `sender` varchar(50) NOT NULL,
  `waktu` datetime NOT NULL,
  `content` text NOT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id_comment`),
  KEY `data_comment_pengumuman` (`id_comment`,`id_pengumuman`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_comment_pengumuman` */

/*Table structure for table `data_fingerprint` */

DROP TABLE IF EXISTS `data_fingerprint`;

CREATE TABLE `data_fingerprint` (
  `uid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `role` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `divisi` varchar(100) NOT NULL,
  `device_id` int(11) NOT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`uid`),
  KEY `device_id` (`device_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_fingerprint` */

/*Table structure for table `data_fingerscanner` */

DROP TABLE IF EXISTS `data_fingerscanner`;

CREATE TABLE `data_fingerscanner` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `port` varchar(10) NOT NULL,
  `last_row` datetime NOT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_fingerscanner` */

/*Table structure for table `data_izin` */

DROP TABLE IF EXISTS `data_izin`;

CREATE TABLE `data_izin` (
  `id_izin` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(255) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `tgl_pengajuan` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_mulai_izin` date NOT NULL,
  `tgl_selesai_izin` date NOT NULL,
  `jml_izin` int(11) NOT NULL DEFAULT 0,
  `kode_izin` varchar(10) NOT NULL,
  `nama_izin` varchar(255) NOT NULL,
  `jenis_izin` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=tidak mengurangi cuti tahunan, 1=mengurangi cuti tahunan',
  `ket_izin` text NOT NULL,
  `approval_spv` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kedep` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kacab` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_direksi` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_hrd` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `file` text NOT NULL COMMENT 'full url',
  `status` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui',
  `user_spv` varchar(255) NOT NULL,
  `user_kedep` varchar(255) NOT NULL,
  `user_kacab` varchar(255) NOT NULL,
  `user_direksi` varchar(255) NOT NULL,
  `user_hrd` varchar(255) NOT NULL,
  `tgl_apv_spv` datetime DEFAULT NULL,
  `tgl_apv_kedep` datetime DEFAULT NULL,
  `tgl_apv_kacab` datetime DEFAULT NULL,
  `tgl_apv_direksi` datetime DEFAULT NULL,
  `tgl_apv_hrd` datetime DEFAULT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_izin`) USING BTREE,
  KEY `KEY` (`id_karyawan`,`id_company`,`tgl_pengajuan`,`tgl_mulai_izin`,`tgl_selesai_izin`,`jenis_izin`,`approval_spv`,`approval_kedep`,`approval_kacab`,`approval_hrd`,`approval_direksi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_izin` */

/*Table structure for table `data_karyawan` */

DROP TABLE IF EXISTS `data_karyawan`;

CREATE TABLE `data_karyawan` (
  `id_karyawan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `nik` varchar(100) NOT NULL,
  `nama_lengkap` varchar(100) NOT NULL,
  `gelar_depan` varchar(50) NOT NULL,
  `gelar_belakang` varchar(50) NOT NULL,
  `no_ktp` varchar(20) NOT NULL,
  `jenis_kelamin` enum('L','P') NOT NULL COMMENT 'L:laki-laki; perempuan',
  `golongan_darah` varchar(20) NOT NULL,
  `agama` varchar(50) NOT NULL,
  `tempat_lahir` varchar(50) NOT NULL,
  `tgl_lahir` date NOT NULL,
  `alamat_domisili` varchar(255) NOT NULL,
  `rt` varchar(10) NOT NULL,
  `rw` varchar(10) NOT NULL,
  `id_kel` varchar(11) NOT NULL,
  `id_kec` varchar(11) NOT NULL,
  `id_kab` varchar(11) NOT NULL,
  `id_prov` varchar(11) NOT NULL,
  `kode_pos` varchar(20) NOT NULL,
  `telepon` varchar(15) NOT NULL,
  `email` varchar(50) NOT NULL,
  `tgl_aktif_bekerja` date DEFAULT NULL,
  `tgl_berhenti_bekerja` date DEFAULT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_jabatan` varchar(50) NOT NULL,
  `supervisi` varchar(50) DEFAULT NULL,
  `jatah_cuti` int(11) NOT NULL DEFAULT 12,
  `pendidikan_terakhir` varchar(50) DEFAULT NULL,
  `grade` int(11) NOT NULL,
  `status` enum('1','2','3','4','5','6','7') NOT NULL COMMENT '1=Kontrak(Aktif); 2=Tetap(Aktif) 3=Izin Belajar(Aktif), 4=Tugas Belajar(Aktif Tidak Wajib Absen), 5=Resign, 6=Dikeluarkan (PHK), 7=Pensiun',
  `lock_lokasi` enum('0','1') NOT NULL DEFAULT '1',
  `id_lokasi` varchar(225) NOT NULL,
  `foto` varchar(255) NOT NULL,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_karyawan`),
  KEY `KEY` (`jenis_kelamin`,`id_departemen`,`id_cabang`,`id_jabatan`,`id_company`,`lock_lokasi`,`id_lokasi`,`id_karyawan`,`nik`,`nama_lengkap`,`id_kel`,`id_kec`,`id_kab`,`id_prov`,`tgl_berhenti_bekerja`,`supervisi`,`jatah_cuti`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_karyawan` */

insert  into `data_karyawan`(`id_karyawan`,`nik`,`nama_lengkap`,`gelar_depan`,`gelar_belakang`,`no_ktp`,`jenis_kelamin`,`golongan_darah`,`agama`,`tempat_lahir`,`tgl_lahir`,`alamat_domisili`,`rt`,`rw`,`id_kel`,`id_kec`,`id_kab`,`id_prov`,`kode_pos`,`telepon`,`email`,`tgl_aktif_bekerja`,`tgl_berhenti_bekerja`,`id_departemen`,`id_cabang`,`id_jabatan`,`supervisi`,`jatah_cuti`,`pendidikan_terakhir`,`grade`,`status`,`lock_lokasi`,`id_lokasi`,`foto`,`id_company`,`tgl_input`) values 
('C221004001','1','ADMIN HRGA','','','','L','','Kristen','','2020-10-08','','','','','','','','','','karyawan@gmail.com','2021-08-23',NULL,'','C221004001','C221004001','',8,NULL,0,'2','1','37180','','C221004','2022-10-04 15:09:01'),
('C2210042','2','Example HOD','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-01','1970-01-01','C221004202210001','C221004001','C221004202210002',NULL,0,NULL,0,'2','1','','','C221004','2022-10-04 16:26:21'),
('C2210043','3','Example Staff','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-02','2022-12-31','C221004202210001','C221004001','C221004202210001',NULL,0,NULL,0,'1','1','','','C221004','2022-10-04 16:26:21'),
('C2210044','4','Example Direksi','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-03','1970-01-01','','C221004001','C221004202210005',NULL,0,NULL,0,'2','1','','','C221004','2022-10-04 16:26:21'),
('C2210045','5','Example Kacab','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-04','1970-01-01','','C221004001','C221004202210003',NULL,0,NULL,0,'2','1','','','C221004','2022-10-04 16:26:21'),
('C2210046','6','Admin Finance','','','','P','','','','1970-01-01','','','','','','','','','','','2022-01-05','1970-01-01','','C221004001','C221004202210004',NULL,0,NULL,0,'2','1','','','C221004','2022-10-04 16:26:21'),
('C2210047','7','Example Supervisi','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-06','1970-01-01','C221004202210001','C221004001','C221004202210006',NULL,0,NULL,0,'2','1','','','C221004','2022-10-04 16:26:21'),
('D221004001','1','ADMIN HRGA','','','','L','','Kristen','','2020-10-08','','','','','','','','','','karyawan@gmail.com','2021-08-23',NULL,'','D221004001','D221004001','',8,NULL,0,'2','1','37180','','D221004','2022-10-04 15:08:00'),
('D2210042','2','Example HOD','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-01','1970-01-01','D221004202210001','D221004001','D221004002',NULL,0,NULL,0,'2','1','','','D221004','2022-10-04 16:22:31'),
('D2210043','3','Example Staff','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-02','2022-12-31','D221004202210001','D221004001','D221004003',NULL,0,NULL,0,'1','1','','','D221004','2022-10-04 16:22:31'),
('D2210044','4','Example Direksi','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-03','1970-01-01','','D221004001','D221004004',NULL,0,NULL,0,'2','1','','','D221004','2022-10-04 16:22:31'),
('D2210045','5','Example Kacab','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-04','1970-01-01','','D221004001','D221004005',NULL,0,NULL,0,'2','1','','','D221004','2022-10-04 16:22:31'),
('D2210046','6','Admin Finance','','','','P','','','','1970-01-01','','','','','','','','','','','2022-01-05','1970-01-01','','D221004001','D221004006',NULL,0,NULL,0,'2','1','','','D221004','2022-10-04 16:13:41'),
('D2210047','7','Example Supervisi','','','','L','','','','1970-01-01','','','','','','','','','','','2022-01-06','1970-01-01','D221004202210001','D221004001','D221004007',NULL,0,NULL,0,'2','1','','','D221004','2022-10-04 16:22:31');

/*Table structure for table `data_karyawan_temp` */

DROP TABLE IF EXISTS `data_karyawan_temp`;

CREATE TABLE `data_karyawan_temp` (
  `id_temp` varchar(50) NOT NULL,
  `id_user` int(11) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `id_karyawan` varchar(100) NOT NULL,
  `nik` varchar(50) DEFAULT NULL,
  `nama_lengkap` varchar(50) NOT NULL,
  `gelar_belakang` varchar(50) DEFAULT NULL,
  `gelar_depan` varchar(50) DEFAULT NULL,
  `no_ktp` varchar(50) DEFAULT NULL,
  `jenis_kelamin` varchar(1) DEFAULT NULL,
  `golongan_darah` varchar(20) DEFAULT NULL,
  `agama` varchar(50) DEFAULT NULL,
  `tempat_lahir` varchar(50) DEFAULT NULL,
  `tgl_lahir` date DEFAULT NULL,
  `alamat_domisili` varchar(255) DEFAULT NULL,
  `telepon` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `tgl_aktif_bekerja` date DEFAULT NULL,
  `tgl_berhenti_bekerja` date DEFAULT NULL,
  `id_departemen` varchar(50) DEFAULT NULL,
  `id_cabang` varchar(50) DEFAULT NULL,
  `id_jabatan` varchar(50) DEFAULT NULL,
  `supervisi` varchar(50) DEFAULT NULL,
  `jatah_cuti` int(11) DEFAULT NULL,
  `pendidikan_terakhir` varchar(50) DEFAULT NULL,
  `status` smallint(6) DEFAULT NULL,
  `lock_lokasi` int(11) NOT NULL DEFAULT 0,
  `id_lokasi` varchar(255) DEFAULT NULL,
  `username` varchar(200) DEFAULT NULL,
  `password` varchar(200) DEFAULT NULL,
  `id_company` varchar(50) DEFAULT NULL,
  `flag` enum('1','2') NOT NULL DEFAULT '2' COMMENT '1:data valid, 2:data tidak valid',
  `user_input` varchar(100) NOT NULL,
  PRIMARY KEY (`id_temp`),
  KEY `id` (`id_karyawan`),
  KEY `id_2` (`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_karyawan_temp` */

/*Table structure for table `data_kelengkapan_file` */

DROP TABLE IF EXISTS `data_kelengkapan_file`;

CREATE TABLE `data_kelengkapan_file` (
  `id_kelengkapan_file` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nama_dokumen` text NOT NULL,
  `file` text NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tanggal_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tanggal_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_kelengkapan_file`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_kelengkapan_file` */

/*Table structure for table `data_keluarga` */

DROP TABLE IF EXISTS `data_keluarga`;

CREATE TABLE `data_keluarga` (
  `id_keluarga` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `nama` varchar(250) NOT NULL,
  `tempat_lahir` varchar(250) NOT NULL,
  `tanggal_lahir` date NOT NULL,
  `jenis_kelamin` enum('L','P') DEFAULT NULL,
  `agama` varchar(50) DEFAULT NULL,
  `telepon` varchar(15) NOT NULL,
  `pekerjaan` varchar(100) NOT NULL,
  `hub_keluarga` varchar(100) DEFAULT NULL,
  `status_perkawinan` varchar(100) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `no_bpjs` int(11) NOT NULL,
  `pendidikan_terakhir` varchar(20) NOT NULL,
  `tanggal_perkawinan` date NOT NULL,
  `status` varchar(100) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_keluarga`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_keluarga` */

/*Table structure for table `data_lokasi_kantor` */

DROP TABLE IF EXISTS `data_lokasi_kantor`;

CREATE TABLE `data_lokasi_kantor` (
  `id_lokasi_kantor` varchar(25) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `nama_kantor` varchar(250) NOT NULL,
  `lat_asli` varchar(250) NOT NULL,
  `lat_min` varchar(250) NOT NULL,
  `lat_max` varchar(250) NOT NULL,
  `long_asli` varchar(250) NOT NULL,
  `long_min` varchar(250) NOT NULL,
  `long_max` varchar(250) NOT NULL,
  `jarak` int(11) NOT NULL,
  `id_cabang` varchar(25) NOT NULL,
  `id_company` varchar(25) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 = pusat; 1 = cabang',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_lokasi_kantor`),
  KEY `data_lok_kantor` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_lokasi_kantor` */

insert  into `data_lokasi_kantor`(`id_lokasi_kantor`,`nama_kantor`,`lat_asli`,`lat_min`,`lat_max`,`long_asli`,`long_min`,`long_max`,`jarak`,`id_cabang`,`id_company`,`flag`,`tgl_input`) values 
('C221004202210001','Absenku','-7.076522668502462','-7.0774219901084','-7.0756233468965','110.4165194866117','110.41742571138','110.41561326184',100,'C221004001','C221004','1','2022-10-04 15:31:41'),
('D221004202210001','Absenku','-7.076511864418034','-7.077411186024','-7.0756125428121','110.41648492006428','110.41739114482','110.41557869531',100,'D221004001','D221004','1','2022-10-04 15:45:56');

/*Table structure for table `data_pengumuman` */

DROP TABLE IF EXISTS `data_pengumuman`;

CREATE TABLE `data_pengumuman` (
  `id_pengumuman` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `target` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '1: Semua Karyawan, 2:Per Cabang: 3: Per Departemen, 4: Per Karyawan',
  `target_id` text NOT NULL,
  `id_cabang` varchar(255) NOT NULL,
  `judul` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `creator` varchar(100) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `posting` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:Belum Posting, 1:Sudah diposting',
  `tgl_posting` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_pengumuman`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_pengumuman` */

/*Table structure for table `data_sertifikat` */

DROP TABLE IF EXISTS `data_sertifikat`;

CREATE TABLE `data_sertifikat` (
  `id_sertifikat` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nama_sertifikat` varchar(255) NOT NULL,
  `penyelenggara` varchar(255) NOT NULL,
  `tgl_berlaku` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `deskripsi` text NOT NULL,
  `file` varchar(250) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_sertifikat`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_sertifikat` */

/*Table structure for table `data_shift_karyawan` */

DROP TABLE IF EXISTS `data_shift_karyawan`;

CREATE TABLE `data_shift_karyawan` (
  `id_shift_karyawan` varchar(100) NOT NULL,
  `tanggal` date NOT NULL,
  `id_karyawan` varchar(255) NOT NULL,
  `id_master_shift` varchar(50) NOT NULL,
  `id_cabang` varchar(50) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `id_departemen` varchar(50) DEFAULT NULL,
  `user_input` varchar(255) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_shift_karyawan`),
  KEY `data_shift_karyawan` (`id_master_shift`,`id_karyawan`,`tanggal`,`id_company`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_shift_karyawan` */

/*Table structure for table `data_shift_karyawan_temp` */

DROP TABLE IF EXISTS `data_shift_karyawan_temp`;

CREATE TABLE `data_shift_karyawan_temp` (
  `id` varchar(255) NOT NULL,
  `tanggal` date NOT NULL,
  `id_karyawan` varchar(255) NOT NULL,
  `id_master_shift` varchar(50) NOT NULL,
  `flag` enum('1','2','3','4') NOT NULL DEFAULT '2' COMMENT '1:data valid, 2:data tidak valid, 3=tgl shift kadaluarsa, 4=data berhasil di simpan',
  `user_input` varchar(255) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `data_shift_karyawan` (`id_master_shift`,`id_karyawan`,`tanggal`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `data_shift_karyawan_temp` */

/*Table structure for table `file_izin` */

DROP TABLE IF EXISTS `file_izin`;

CREATE TABLE `file_izin` (
  `id_izin` varchar(50) DEFAULT NULL,
  `file` text DEFAULT NULL COMMENT 'full url',
  `id_company` varchar(20) DEFAULT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `file_izin` */

/*Table structure for table `h_cuti` */

DROP TABLE IF EXISTS `h_cuti`;

CREATE TABLE `h_cuti` (
  `tahun` varchar(4) NOT NULL,
  `id_karyawan` varchar(255) NOT NULL,
  `nama_karyawan` varchar(100) NOT NULL,
  `jml_cuti` int(3) NOT NULL,
  `kode_reset` varchar(255) NOT NULL DEFAULT '1',
  `user_reset` varchar(255) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `h_cuti` */

/*Table structure for table `hari` */

DROP TABLE IF EXISTS `hari`;

CREATE TABLE `hari` (
  `id` int(11) NOT NULL,
  `nama` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `hari` */

insert  into `hari`(`id`,`nama`) values 
(7,'Minggu'),
(1,'Senin'),
(2,'Selasa'),
(3,'Rabu'),
(4,'Kamis'),
(5,'Jumat'),
(6,'Sabtu');

/*Table structure for table `history_jabatan` */

DROP TABLE IF EXISTS `history_jabatan`;

CREATE TABLE `history_jabatan` (
  `id_history_jabatan` int(11) NOT NULL AUTO_INCREMENT,
  `id_karyawan` varchar(11) NOT NULL,
  `id_jabatan` int(11) NOT NULL,
  `id_divisi` int(11) NOT NULL,
  `tanggal` date NOT NULL,
  `id_company` int(11) NOT NULL,
  PRIMARY KEY (`id_history_jabatan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `history_jabatan` */

/*Table structure for table `holidays` */

DROP TABLE IF EXISTS `holidays`;

CREATE TABLE `holidays` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `keterangan` varchar(255) NOT NULL,
  `id_company` int(11) NOT NULL,
  `color` varchar(11) DEFAULT '#8A2BE2',
  PRIMARY KEY (`id`),
  KEY `holidays` (`tanggal`,`id_company`)
) ENGINE=InnoDB AUTO_INCREMENT=13782 DEFAULT CHARSET=latin1;

/*Data for the table `holidays` */

/*Table structure for table `informasi_gaji` */

DROP TABLE IF EXISTS `informasi_gaji`;

CREATE TABLE `informasi_gaji` (
  `id` varchar(50) NOT NULL,
  `periode` varchar(8) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `nama_karyawan` varchar(150) NOT NULL,
  `kode_cabang` varchar(10) NOT NULL,
  `nama_cabang` varchar(150) NOT NULL,
  `kode_departemen` varchar(10) NOT NULL,
  `nama_departemen` varchar(150) NOT NULL,
  `kode_jabatan` varchar(10) NOT NULL,
  `nama_jabatan` varchar(150) NOT NULL,
  `gaji_pokok` int(11) NOT NULL DEFAULT 0,
  `t_jabatan` int(11) NOT NULL DEFAULT 0,
  `t_transport` int(11) NOT NULL DEFAULT 0,
  `t_makan` int(11) NOT NULL DEFAULT 0,
  `t_istri` int(11) NOT NULL DEFAULT 0,
  `t_anak` int(11) NOT NULL DEFAULT 0,
  `lembur` int(11) NOT NULL DEFAULT 0,
  `komisi` int(11) NOT NULL DEFAULT 0,
  `t_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tunjangan` int(11) NOT NULL DEFAULT 0,
  `ttl_penerimaan` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `tbp_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tbp` int(11) NOT NULL DEFAULT 0,
  `p_absensi` int(11) NOT NULL DEFAULT 0,
  `p_keterlambatan` int(11) NOT NULL DEFAULT 0,
  `p_koperasi` int(11) NOT NULL DEFAULT 0,
  `p_asuransi_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_potongan` int(11) NOT NULL DEFAULT 0,
  `gaji_diterima` int(11) NOT NULL DEFAULT 0,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_input` varchar(50) NOT NULL,
  `publish` enum('0','1') NOT NULL DEFAULT '0',
  `tgl_publish` datetime DEFAULT NULL,
  `user_publish` varchar(50) DEFAULT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `informasi_gaji` */

/*Table structure for table `informasi_gaji_temp` */

DROP TABLE IF EXISTS `informasi_gaji_temp`;

CREATE TABLE `informasi_gaji_temp` (
  `id` varchar(50) NOT NULL,
  `periode` varchar(8) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `nama_karyawan` varchar(150) NOT NULL,
  `kode_cabang` varchar(10) NOT NULL,
  `nama_cabang` varchar(150) NOT NULL,
  `kode_departemen` varchar(10) NOT NULL,
  `nama_departemen` varchar(150) NOT NULL,
  `kode_jabatan` varchar(10) NOT NULL,
  `nama_jabatan` varchar(150) NOT NULL,
  `gaji_pokok` int(11) NOT NULL DEFAULT 0,
  `t_jabatan` int(11) NOT NULL DEFAULT 0,
  `t_transport` int(11) NOT NULL DEFAULT 0,
  `t_makan` int(11) NOT NULL DEFAULT 0,
  `t_istri` int(11) NOT NULL DEFAULT 0,
  `t_anak` int(11) NOT NULL DEFAULT 0,
  `lembur` int(11) NOT NULL DEFAULT 0,
  `komisi` int(11) NOT NULL DEFAULT 0,
  `t_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tunjangan` int(11) NOT NULL DEFAULT 0,
  `ttl_penerimaan` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `tbp_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tbp` int(11) NOT NULL DEFAULT 0,
  `p_absensi` int(11) NOT NULL DEFAULT 0,
  `p_keterlambatan` int(11) NOT NULL DEFAULT 0,
  `p_koperasi` int(11) NOT NULL DEFAULT 0,
  `p_asuransi_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_potongan` int(11) NOT NULL DEFAULT 0,
  `gaji_diterima` int(11) NOT NULL DEFAULT 0,
  `flag` enum('1','2','3') NOT NULL DEFAULT '2' COMMENT '1: Data Valid, 2: Data tidak lengkap, 3:Data sudah ada',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_input` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `informasi_gaji_temp` */

/*Table structure for table `istirahat_mulai` */

DROP TABLE IF EXISTS `istirahat_mulai`;

CREATE TABLE `istirahat_mulai` (
  `id_istmulai` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_absensi_masuk` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jam_absen` datetime NOT NULL,
  `lokasi_absen` varchar(255) NOT NULL,
  `timezone` varchar(255) NOT NULL,
  `gmt` varchar(6) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `keterangan` text NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_istmulai`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`id_absensi_masuk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `istirahat_mulai` */

/*Table structure for table `istirahat_selesai` */

DROP TABLE IF EXISTS `istirahat_selesai`;

CREATE TABLE `istirahat_selesai` (
  `id_istselesai` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_absensi_masuk` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jam_absen` datetime NOT NULL,
  `lokasi_absen` varchar(255) NOT NULL,
  `timezone` varchar(255) NOT NULL,
  `gmt` varchar(6) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `keterangan` text NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_istselesai`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`id_absensi_masuk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `istirahat_selesai` */

/*Table structure for table `jam_kerja` */

DROP TABLE IF EXISTS `jam_kerja`;

CREATE TABLE `jam_kerja` (
  `id_jam_kerja` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `libur` int(11) NOT NULL DEFAULT 0 COMMENT '0=masuk; 1=libur',
  `hari` int(11) NOT NULL COMMENT '1=senin; 7=minggu',
  `masuk` time NOT NULL,
  `pulang` time NOT NULL,
  `start_absen_masuk` time NOT NULL,
  `batas_absen_pulang` time NOT NULL,
  `fleksitime` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:true; 1:false',
  `min_masuk` time NOT NULL DEFAULT '00:00:00',
  `max_masuk` time NOT NULL DEFAULT '00:00:00',
  `jml_jamkerja` smallint(2) NOT NULL DEFAULT 8,
  `id_cabang` varchar(20) NOT NULL,
  `id_company` varchar(20) NOT NULL,
  PRIMARY KEY (`id_jam_kerja`),
  KEY `jadwal_kerja` (`hari`,`id_company`,`id_cabang`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `jam_kerja` */

insert  into `jam_kerja`(`id_jam_kerja`,`libur`,`hari`,`masuk`,`pulang`,`start_absen_masuk`,`batas_absen_pulang`,`fleksitime`,`min_masuk`,`max_masuk`,`jml_jamkerja`,`id_cabang`,`id_company`) values 
('C221004001',0,1,'08:00:00','17:00:00','00:00:00','23:59:00','0','00:00:00','00:00:00',8,'C221004001','C221004'),
('C221004002',0,2,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'C221004001','C221004'),
('C221004003',0,3,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'C221004001','C221004'),
('C221004004',0,4,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'C221004001','C221004'),
('C221004005',0,5,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'C221004001','C221004'),
('C221004006',0,6,'00:08:00','00:14:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'C221004001','C221004'),
('C221004007',1,7,'08:00:00','17:00:00','00:00:00','00:00:00','0','00:00:00','00:00:00',8,'C221004001','C221004'),
('D221004001',0,1,'08:00:00','17:00:00','00:00:00','23:59:00','0','00:00:00','00:00:00',8,'D221004001','D221004'),
('D221004002',0,2,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'D221004001','D221004'),
('D221004003',0,3,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'D221004001','D221004'),
('D221004004',0,4,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'D221004001','D221004'),
('D221004005',0,5,'08:00:00','17:00:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'D221004001','D221004'),
('D221004006',0,6,'00:08:00','00:14:00','00:00:00','23:59:59','0','00:00:00','00:00:00',8,'D221004001','D221004'),
('D221004007',1,7,'08:00:00','17:00:00','00:00:00','00:00:00','0','00:00:00','00:00:00',8,'D221004001','D221004');

/*Table structure for table `jenis_pelanggan` */

DROP TABLE IF EXISTS `jenis_pelanggan`;

CREATE TABLE `jenis_pelanggan` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `nama` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

/*Data for the table `jenis_pelanggan` */

/*Table structure for table `karir_pekerjaan` */

DROP TABLE IF EXISTS `karir_pekerjaan`;

CREATE TABLE `karir_pekerjaan` (
  `id_karir_pekerjaan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `nomor_surat_keputusan` varchar(250) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `kode_jabatan` varchar(50) NOT NULL,
  `nama_jabatan` varchar(255) NOT NULL,
  `kode_cabang` varchar(50) NOT NULL,
  `nama_cabang` varchar(255) NOT NULL,
  `kode_departemen` varchar(50) NOT NULL,
  `nama_departemen` varchar(255) NOT NULL,
  `tgl_mulai` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `status` enum('1','2','3','') NOT NULL COMMENT '1: Kontrak; 2: Tetap; 3: Promosi',
  `keterangan_status` text NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `karir_pekerjaan` */

/*Table structure for table `kep_departemen` */

DROP TABLE IF EXISTS `kep_departemen`;

CREATE TABLE `kep_departemen` (
  `id_kep_departemen` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_kep_departemen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `kep_departemen` */

/*Table structure for table `lembur_mulai` */

DROP TABLE IF EXISTS `lembur_mulai`;

CREATE TABLE `lembur_mulai` (
  `id_lemmulai` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_karyawan` varchar(255) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jam_absen` datetime NOT NULL,
  `lokasi_absen` varchar(255) NOT NULL,
  `timezone` varchar(150) NOT NULL,
  `gmt` varchar(100) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `keterangan` text NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(255) NOT NULL,
  `approve` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=Pengajuan Lembur, 2=Ditolak, 3=Disetujui',
  `status` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_spv` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kedep` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kacab` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_hrd` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_direksi` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `user_spv` varchar(255) NOT NULL,
  `user_kedep` varchar(255) DEFAULT NULL,
  `user_kacab` varchar(255) DEFAULT NULL,
  `user_hrd` varchar(255) DEFAULT NULL,
  `user_direksi` varchar(255) DEFAULT NULL,
  `tgl_apv_spv` datetime DEFAULT NULL,
  `tgl_apv_kedep` datetime DEFAULT NULL,
  `tgl_apv_kacab` datetime DEFAULT NULL,
  `tgl_apv_hrd` datetime DEFAULT NULL,
  `tgl_apv_direksi` datetime DEFAULT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_lemmulai`,`user_spv`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`approve`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `lembur_mulai` */

/*Table structure for table `lembur_selesai` */

DROP TABLE IF EXISTS `lembur_selesai`;

CREATE TABLE `lembur_selesai` (
  `id_lemselesai` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_lemmulai` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jam_absen` datetime NOT NULL,
  `lokasi_absen` varchar(250) NOT NULL,
  `timezone` varchar(150) NOT NULL,
  `gmt` varchar(100) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `keterangan` text NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_lemselesai`),
  KEY `lembur_selesai` (`id_karyawan`,`tgl_absen`,`id_company`,`id_lemmulai`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `lembur_selesai` */

/*Table structure for table `log_aktivitas` */

DROP TABLE IF EXISTS `log_aktivitas`;

CREATE TABLE `log_aktivitas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `waktu` datetime NOT NULL DEFAULT current_timestamp(),
  `modul` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `query` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21317 DEFAULT CHARSET=latin1;

/*Data for the table `log_aktivitas` */

insert  into `log_aktivitas`(`id`,`username`,`waktu`,`modul`,`action`,`query`,`id_company`) values 
(21295,'administrator','2022-09-05 04:48:42','export_karyawan','export','SELECT * FROM data_keluarga WHERE id_karyawan = \'75ff20caa9ff615abb3fe815d7b15114\' ORDER BY (\r\n												CASE hub_keluarga\r\n\r\n												WHEN \'Ayah\'\r\n												THEN 1\r\n\r\n												WHEN \'Ibu\'\r\n												THEN 2\r\n\r\n												WHEN \'Suami\'\r\n												THEN 3\r\n\r\n												WHEN \'Istri\'\r\n												THEN 4\r\n\r\n												WHEN \'Anak\'\r\n												THEN 5\r\n\r\n												WHEN \'Saudara Kandung\'\r\n												THEN 6\r\n\r\n												END\r\n							) ASC','D220905'),
(21302,'administrator','2022-09-05 04:52:58','export_karyawan','export','SELECT * FROM data_keluarga WHERE id_karyawan = \'75ff20caa9ff615abb3fe815d7b15114\' ORDER BY (\r\n												CASE hub_keluarga\r\n\r\n												WHEN \'Ayah\'\r\n												THEN 1\r\n\r\n												WHEN \'Ibu\'\r\n												THEN 2\r\n\r\n												WHEN \'Suami\'\r\n												THEN 3\r\n\r\n												WHEN \'Istri\'\r\n												THEN 4\r\n\r\n												WHEN \'Anak\'\r\n												THEN 5\r\n\r\n												WHEN \'Saudara Kandung\'\r\n												THEN 6\r\n\r\n												END\r\n							) ASC','D220905'),
(21309,'administrator','2022-10-04 03:40:20','master_shift','tambah_master_shift','INSERT INTO `master_shift` (`kode_shift`, `nama_shift`, `libur`, `jam_masuk`, `jam_pulang`, `start_absen_masuk`, `batas_absen_pulang`, `flag_jam_pulang`, `flag_batas_absen_pulang`, `id_cabang`, `id_company`, `id_master_shift`) VALUES (\'SS\', \'Shift Siang\', \'0\', \'13:00\', \'21:00\', \'12:00\', \'22:00\', \'0\', \'0\', \'C221004001\', \'C221004\', \'C221004202210001\')','C221004'),
(21316,'de_admin','2022-10-04 03:48:11','master_shift','tambah_master_shift','INSERT INTO `master_shift` (`kode_shift`, `nama_shift`, `libur`, `jam_masuk`, `jam_pulang`, `start_absen_masuk`, `batas_absen_pulang`, `flag_jam_pulang`, `flag_batas_absen_pulang`, `id_cabang`, `id_company`, `id_master_shift`) VALUES (\'SS\', \'Shift Siang\', \'0\', \'13:00\', \'21:00\', \'12:00\', \'22:00\', \'0\', \'0\', \'D221004001\', \'D221004\', \'D221004202210001\')','D221004');

/*Table structure for table `log_notifikasi` */

DROP TABLE IF EXISTS `log_notifikasi`;

CREATE TABLE `log_notifikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `waktu` datetime NOT NULL,
  `modul` varchar(50) NOT NULL,
  `query` text NOT NULL,
  `id_karyawan` varchar(20) NOT NULL,
  `status` int(11) NOT NULL,
  `id_company` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `log_notifikasi` (`id`,`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `log_notifikasi` */

/*Table structure for table `log_notifikasi_trial` */

DROP TABLE IF EXISTS `log_notifikasi_trial`;

CREATE TABLE `log_notifikasi_trial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_company` int(9) NOT NULL COMMENT 'master_company.id_company',
  `nama_company` varchar(100) NOT NULL COMMENT 'master_company.nama',
  `nama_customer` varchar(100) NOT NULL COMMENT 'master_customer.nama',
  `email` varchar(100) NOT NULL COMMENT 'master_customer.email',
  `telepon` varchar(50) NOT NULL COMMENT 'master_customer.telp',
  `feedback` enum('-','extend','positif','negatif') NOT NULL DEFAULT '-',
  `feedback_hplus8` enum('-','extend','positif','negatif') DEFAULT '-',
  `catatan` varchar(300) DEFAULT '-',
  `waktu` datetime NOT NULL COMMENT 'YYYY-mm-dd HH:ii:ss',
  `waktu_hplus8` date DEFAULT NULL,
  `id_wablas` char(50) NOT NULL COMMENT 'id dari hasil pengirima pesan pada API wablas',
  `id_wablas_hplus8` char(50) DEFAULT NULL,
  `status` enum('-','0','1','2','3','4','5') NOT NULL DEFAULT '-' COMMENT '-: belum ada action, 0: gagal terkirim ke dewa, 1: terkirim ke dewa, 2: sent(centang 1), 3: delivered(centang 2), 4: read(centang 2 biru), 5: failed',
  `status_hplus8` enum('-','0','1','2','3','4','5') NOT NULL DEFAULT '-' COMMENT '-: belum ada action, 0: gagal terkirim ke dewa, 1: terkirim ke dewa, 2: sent(centang 1), 3: delivered(centang 2), 4: read(centang 2 biru), 5: failed',
  `tanggal_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3396 DEFAULT CHARSET=latin1 COMMENT='menyimpan list perusahaan pengguna paket absenku trial yang sudah dikirim notifikasi wablas h-2 masa layanan berakhir';

/*Data for the table `log_notifikasi_trial` */

/*Table structure for table `m_pengaduan` */

DROP TABLE IF EXISTS `m_pengaduan`;

CREATE TABLE `m_pengaduan` (
  `id_pengaduan` int(11) NOT NULL AUTO_INCREMENT,
  `id_kategori` int(11) NOT NULL,
  `id_topik` int(11) NOT NULL,
  `id_wali` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `date` datetime NOT NULL,
  `id_company` int(11) DEFAULT 1,
  `flag` enum('0','1') NOT NULL DEFAULT '1' COMMENT '0 = karyawan; 1 = admin',
  `cek` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 = belum di buka; 1 = sudah di buka',
  PRIMARY KEY (`id_pengaduan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `m_pengaduan` */

/*Table structure for table `m_version` */

DROP TABLE IF EXISTS `m_version`;

CREATE TABLE `m_version` (
  `current_version` varchar(10) NOT NULL,
  `descr` text NOT NULL,
  `cons_apps` enum('1','0') DEFAULT NULL COMMENT '0:skip update; 1: wajib update',
  KEY `current_version` (`current_version`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `m_version` */

/*Table structure for table `master_cabang` */

DROP TABLE IF EXISTS `master_cabang`;

CREATE TABLE `master_cabang` (
  `id_cabang` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `kode` varchar(50) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `flag` enum('1','2') NOT NULL DEFAULT '1' COMMENT '1 = pusat, 2 = cabang',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_cabang`),
  KEY `id` (`id_company`,`kode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_cabang` */

insert  into `master_cabang`(`id_cabang`,`kode`,`nama`,`flag`,`id_company`,`tgl_input`) values 
('C221004001','PST','PUSAT','1','C221004','2022-10-04 15:03:28'),
('D221004001','PST','PUSAT','1','D221004','2022-10-04 15:03:08');

/*Table structure for table `master_company` */

DROP TABLE IF EXISTS `master_company`;

CREATE TABLE `master_company` (
  `id_company` varchar(10) NOT NULL COMMENT 'tahun + 5 digit nomor urut',
  `nama` varchar(100) NOT NULL,
  `deskripsi` text NOT NULL,
  `alamat` varchar(255) NOT NULL,
  `url_logo` varchar(255) NOT NULL,
  `url_icon` varchar(255) NOT NULL,
  `themes` int(11) NOT NULL,
  `id_customer` int(11) NOT NULL,
  `id_tb_paket` int(11) NOT NULL DEFAULT 5,
  `zona_waktu` int(11) NOT NULL DEFAULT 1,
  `flag` int(11) NOT NULL DEFAULT 0 COMMENT '0:Tidak Aktif, 1;Aktif',
  `payroll` int(11) NOT NULL DEFAULT 0,
  `flag1` enum('0','1') NOT NULL DEFAULT '0',
  `id_induk` bigint(20) unsigned DEFAULT NULL,
  `custom_jumlah_karyawan` int(11) NOT NULL DEFAULT 0,
  `lock_device` enum('0','1') NOT NULL DEFAULT '0',
  `lock_lokasi` enum('0','1') NOT NULL DEFAULT '1',
  `lock_facerecognition` enum('0','1') NOT NULL DEFAULT '0',
  `jenis_perusahaan` tinyint(4) NOT NULL COMMENT '1 = Perusahaan;\r\n2 = Hotel;\r\n3 = Warnet/Game Center;\r\n4 = Sekolah / Perguruan Tinggi;\r\n5 = Dinas / Pemerintahan;\r\n6 = Personal;\r\n7 = Lainnya;',
  `npwp` varchar(20) NOT NULL,
  `jenis_registrasi` enum('generik','custom') NOT NULL DEFAULT 'generik',
  `source` varchar(255) DEFAULT NULL,
  `landingpage` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_company`),
  KEY `KEY` (`nama`,`id_tb_paket`,`id_customer`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_company` */

insert  into `master_company`(`id_company`,`nama`,`deskripsi`,`alamat`,`url_logo`,`url_icon`,`themes`,`id_customer`,`id_tb_paket`,`zona_waktu`,`flag`,`payroll`,`flag1`,`id_induk`,`custom_jumlah_karyawan`,`lock_device`,`lock_lokasi`,`lock_facerecognition`,`jenis_perusahaan`,`npwp`,`jenis_registrasi`,`source`,`landingpage`,`url`) values 
('C221004','Custom','Custom','Karangrejo, Banyumanik, Semarang','21866/logo-perusahaan/21866-c62e68f1-3d76-4d91-b39f-0a17496a3ade.jpg','',0,1,202108007,1,1,0,'0',NULL,0,'0','0','0',7,'','custom',NULL,NULL,NULL),
('D221004','Developer','Developer Aplikasi Online Masa Kini','Karangrejo, Banyumanik, Semarang','21866/logo-perusahaan/21866-c62e68f1-3d76-4d91-b39f-0a17496a3ade.jpg','',0,2,202108007,1,1,0,'0',NULL,0,'0','0','0',7,'','custom',NULL,NULL,NULL);

/*Table structure for table `master_customer` */

DROP TABLE IF EXISTS `master_customer`;

CREATE TABLE `master_customer` (
  `id_customer` varchar(15) NOT NULL COMMENT 'tahun + 5 digit nomor urut',
  `nama` varchar(100) NOT NULL,
  `propinsi` varchar(255) DEFAULT NULL,
  `kota` varchar(255) DEFAULT NULL,
  `alamat` varchar(255) NOT NULL,
  `tgl_lahir` date NOT NULL,
  `email` varchar(100) NOT NULL,
  `telp` varchar(50) NOT NULL,
  `login` int(11) NOT NULL DEFAULT 1,
  `hash` varchar(11) NOT NULL,
  PRIMARY KEY (`id_customer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_customer` */

insert  into `master_customer`(`id_customer`,`nama`,`propinsi`,`kota`,`alamat`,`tgl_lahir`,`email`,`telp`,`login`,`hash`) values 
('1','karyawan','33','3374','Semarang','2018-01-01','karyawan@gmail.com','08122999321',1,'PJ05SM'),
('2','karyawan','33','3374','Semarang','2018-01-01','karyawan@gmail.com','08122999321',1,'PJ05SM');

/*Table structure for table `master_departemen` */

DROP TABLE IF EXISTS `master_departemen`;

CREATE TABLE `master_departemen` (
  `id_departemen` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 3 digit number',
  `kode` varchar(50) NOT NULL,
  `nama` varchar(225) NOT NULL,
  `jenis` enum('HR','Finance','','') DEFAULT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_departemen`),
  KEY `KEY` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_departemen` */

insert  into `master_departemen`(`id_departemen`,`kode`,`nama`,`jenis`,`id_company`,`tgl_input`) values 
('C221004202210001','MKT','Marketing',NULL,'C221004','2022-10-04 15:27:36'),
('D221004202210001','MKT','Marketing',NULL,'D221004','2022-10-04 15:44:17');

/*Table structure for table `master_grade` */

DROP TABLE IF EXISTS `master_grade`;

CREATE TABLE `master_grade` (
  `id_grade` int(11) NOT NULL AUTO_INCREMENT,
  `grade` varchar(100) DEFAULT NULL,
  `gaji` varchar(9) DEFAULT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id_grade`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_grade` */

/*Table structure for table `master_jabatan` */

DROP TABLE IF EXISTS `master_jabatan`;

CREATE TABLE `master_jabatan` (
  `id_jabatan` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `kode_jabatan` varchar(15) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `level_user` smallint(2) NOT NULL,
  `id_company` varchar(10) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_jabatan`),
  KEY `indexy` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_jabatan` */

insert  into `master_jabatan`(`id_jabatan`,`kode_jabatan`,`nama`,`level_user`,`id_company`,`tgl_input`) values 
('C221004001','ADM-HRD','ADMIN HRGA',1,'C221004','2022-10-04 15:06:45'),
('C221004202210001','STF','Staff',3,'C221004','2022-10-04 15:27:55'),
('C221004202210002','HOD','Kepala Departemen',2,'C221004','2022-10-04 15:28:15'),
('C221004202210003','KACAB','Kepala Cabang',5,'C221004','2022-10-04 15:28:27'),
('C221004202210004','ADM-FIN','Finance',6,'C221004','2022-10-04 15:28:58'),
('C221004202210005','DIR','Direksi',4,'C221004','2022-10-04 15:29:10'),
('C221004202210006','SPV','Supervisi',7,'C221004','2022-10-04 15:29:32'),
('D221004001','ADM-HRD','ADMIN HRGA',1,'D221004','2022-10-04 15:05:35'),
('D221004002','HOD','Kepala Departemen',2,'D221004','2022-10-04 15:05:43'),
('D221004003','STF','Pegawai',3,'D221004','2022-10-04 15:05:50'),
('D221004004','DIR','Direksi',4,'D221004','2022-10-04 15:06:01'),
('D221004005','KACAB','kepala Cabang',5,'D221004','2022-10-04 15:06:11'),
('D221004006','ADM-FIN','ADMIN FINANCE',6,'D221004','2022-10-04 15:06:20'),
('D221004007','SPV','Supervisi',7,'D221004','2022-10-04 15:06:27');

/*Table structure for table `master_jenis_izin` */

DROP TABLE IF EXISTS `master_jenis_izin`;

CREATE TABLE `master_jenis_izin` (
  `id_jenis_izin` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `kode_izin` varchar(5) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `jenis_izin` enum('sakit','izin','cuti') NOT NULL DEFAULT 'cuti',
  `max_izin` varchar(3) NOT NULL COMMENT 'satuan hari',
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0; tidak mengurangi cuti tahunan, 1; mengurangi cuti tahunan',
  `id_company` varchar(9) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_jenis_izin`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_jenis_izin` */

insert  into `master_jenis_izin`(`id_jenis_izin`,`kode_izin`,`nama`,`jenis_izin`,`max_izin`,`flag`,`id_company`,`tgl_input`) values 
('C221004202210001','C','Cuti','cuti','3','1','C221004','2022-10-04 15:34:41'),
('C221004202210002','S','Sakit','sakit','','0','C221004','2022-10-04 15:35:03'),
('C221004202210003','I','Izin','izin','','0','C221004','2022-10-04 15:35:18'),
('D221004202210001','C','Cuti','cuti','3','1','D221004','2022-10-04 15:46:31'),
('D221004202210002','S','Sakit','sakit','','0','D221004','2022-10-04 15:46:48'),
('D221004202210003','I','Izin','izin','','0','D221004','2022-10-04 15:47:07');

/*Table structure for table `master_kecamatan` */

DROP TABLE IF EXISTS `master_kecamatan`;

CREATE TABLE `master_kecamatan` (
  `id_kecamatan` int(6) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  `id_kota` int(4) DEFAULT NULL,
  PRIMARY KEY (`id_kecamatan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_kecamatan` */

/*Table structure for table `master_kelurahan` */

DROP TABLE IF EXISTS `master_kelurahan`;

CREATE TABLE `master_kelurahan` (
  `id_kelurahan` varchar(10) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  `id_kecamatan` int(6) DEFAULT NULL,
  PRIMARY KEY (`id_kelurahan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_kelurahan` */

/*Table structure for table `master_komponen_paket` */

DROP TABLE IF EXISTS `master_komponen_paket`;

CREATE TABLE `master_komponen_paket` (
  `id_komponen_paket` varchar(50) NOT NULL COMMENT 'id_company + 5 digit nomor urut',
  `kode_komponen` varchar(50) NOT NULL,
  `nama_komponen` varchar(255) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:tidak aktfi; 1:aktif',
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_komponen_paket`),
  KEY `KEY` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_komponen_paket` */

/*Table structure for table `master_kota` */

DROP TABLE IF EXISTS `master_kota`;

CREATE TABLE `master_kota` (
  `id_kota` int(4) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  `id_prov` int(2) DEFAULT NULL,
  PRIMARY KEY (`id_kota`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_kota` */

/*Table structure for table `master_paket` */

DROP TABLE IF EXISTS `master_paket`;

CREATE TABLE `master_paket` (
  `id_paket` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `tarif` float NOT NULL,
  `komponen_web` varchar(255) NOT NULL,
  `komponen_mobile` varchar(255) NOT NULL COMMENT '1=izin, 2=lembur, 3=shift, 4= remburse, 5=info gaji, 6=aktivitas, 7=berita',
  `max_karyawan` int(11) NOT NULL DEFAULT 0,
  `max_cabang` varchar(250) NOT NULL DEFAULT '-',
  PRIMARY KEY (`id_paket`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

/*Data for the table `master_paket` */

/*Table structure for table `master_plan` */

DROP TABLE IF EXISTS `master_plan`;

CREATE TABLE `master_plan` (
  `id_plan` int(11) NOT NULL AUTO_INCREMENT,
  `id_customer` int(11) NOT NULL,
  `status` int(11) NOT NULL COMMENT '2=trial; 3=lunas/aktif; 4=request aktivasi; 5=perpanjangan;\r\n6=request upgrade;',
  `tgl_aktif` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `tgl_daftar` date DEFAULT NULL,
  `masa_layanan` int(11) NOT NULL DEFAULT 1 COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan',
  `max_cabang` varchar(10) NOT NULL DEFAULT '~',
  `max_karyawan` varchar(10) NOT NULL DEFAULT '~',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_plan`),
  KEY `master_plan` (`id_company`,`id_customer`,`tgl_daftar`)
) ENGINE=InnoDB AUTO_INCREMENT=81811 DEFAULT CHARSET=latin1;

/*Data for the table `master_plan` */

insert  into `master_plan`(`id_plan`,`id_customer`,`status`,`tgl_aktif`,`tgl_berakhir`,`tgl_daftar`,`masa_layanan`,`max_cabang`,`max_karyawan`,`id_company`,`tgl_input`) values 
(1,1,2,'2020-10-08','2022-10-31','2020-10-08',2,'~','30','C221004','2022-10-04 14:57:06'),
(2,2,2,'2020-10-08','2022-10-31','2020-10-08',2,'~','30','D221004','2022-10-04 15:00:41');

/*Table structure for table `master_plan_temp` */

DROP TABLE IF EXISTS `master_plan_temp`;

CREATE TABLE `master_plan_temp` (
  `id_plan_temp` int(11) NOT NULL AUTO_INCREMENT,
  `id_company` int(11) DEFAULT NULL,
  `id_transaksi` varchar(20) DEFAULT NULL,
  `id_plan` tinyint(4) DEFAULT NULL COMMENT 'id plan temp',
  `tgl_aktif` date DEFAULT NULL,
  `tgl_berakhir` date DEFAULT NULL,
  `masa_layanan` smallint(6) DEFAULT NULL,
  `jumlah_tambahan` smallint(1) DEFAULT NULL,
  PRIMARY KEY (`id_plan_temp`)
) ENGINE=InnoDB AUTO_INCREMENT=2232 DEFAULT CHARSET=latin1;

/*Data for the table `master_plan_temp` */

/*Table structure for table `master_provinsi` */

DROP TABLE IF EXISTS `master_provinsi`;

CREATE TABLE `master_provinsi` (
  `id_prov` int(2) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id_prov`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_provinsi` */

insert  into `master_provinsi`(`id_prov`,`nama`) values 
(11,'ACEH'),
(12,'SUMATERA UTARA'),
(13,'SUMATERA BARAT'),
(14,'RIAU'),
(15,'JAMBI'),
(16,'SUMATERA SELATAN'),
(17,'BENGKULU'),
(18,'LAMPUNG'),
(19,'KEPULAUAN BANGKA BELITUNG'),
(21,'KEPULAUAN RIAU'),
(31,'DKI JAKARTA'),
(32,'JAWA BARAT'),
(33,'JAWA TENGAH'),
(34,'DAERAH ISTIMEWA YOGYAKARTA'),
(35,'JAWA TIMUR'),
(36,'BANTEN'),
(51,'BALI'),
(52,'NUSA TENGGARA BARAT'),
(53,'NUSA TENGGARA TIMUR'),
(61,'KALIMANTAN BARAT'),
(62,'KALIMANTAN TENGAH'),
(63,'KALIMANTAN SELATAN'),
(64,'KALIMANTAN TIMUR'),
(65,'KALIMANTAN UTARA'),
(71,'SULAWESI UTARA'),
(72,'SULAWESI TENGAH'),
(73,'SULAWESI SELATAN'),
(74,'SULAWESI TENGGARA'),
(75,'GORONTALO'),
(76,'SULAWESI BARAT'),
(81,'MALUKU'),
(82,'MALUKU UTARA'),
(91,'PAPUA'),
(92,'PAPUA BARAT');

/*Table structure for table `master_shift` */

DROP TABLE IF EXISTS `master_shift`;

CREATE TABLE `master_shift` (
  `id_master_shift` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 2 digit nomor urut',
  `kode_shift` varchar(50) NOT NULL,
  `nama_shift` varchar(20) NOT NULL,
  `jam_masuk` time NOT NULL,
  `jam_pulang` time NOT NULL,
  `flag_jam_pulang` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=hari yang sama, 1=lewat hari',
  `start_absen_masuk` time DEFAULT NULL,
  `batas_absen_pulang` time DEFAULT NULL,
  `flag_batas_absen_pulang` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=hari yang sama, 1=lewat hari',
  `libur` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=Masuk Kerja; 1=Libur',
  `id_cabang` varchar(20) NOT NULL,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_master_shift`),
  KEY `KEY` (`kode_shift`,`id_company`,`jam_masuk`,`id_cabang`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `master_shift` */

insert  into `master_shift`(`id_master_shift`,`kode_shift`,`nama_shift`,`jam_masuk`,`jam_pulang`,`flag_jam_pulang`,`start_absen_masuk`,`batas_absen_pulang`,`flag_batas_absen_pulang`,`libur`,`id_cabang`,`id_company`,`tgl_input`) values 
('C221004202210001','SS','Shift Siang','13:00:00','21:00:00','0','12:00:00','22:00:00','0','0','C221004001','C221004','2022-10-04 15:40:20'),
('D221004202210001','SS','Shift Siang','13:00:00','21:00:00','0','12:00:00','22:00:00','0','0','D221004001','D221004','2022-10-04 15:48:11');

/*Table structure for table `migrations` */

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `migrations` */

/*Table structure for table `monev_aktif` */

DROP TABLE IF EXISTS `monev_aktif`;

CREATE TABLE `monev_aktif` (
  `id_plan` int(11) NOT NULL,
  `id_customer` int(11) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `status` int(11) NOT NULL COMMENT '2=trial; 3=lunas/aktif; 4=request aktivasi; 5=perpanjangan',
  `flag` enum('0','1') NOT NULL DEFAULT '1' COMMENT '1=ON, 0=OFF',
  `tgl_aktif` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `id_company` bigint(20) NOT NULL,
  `tgl_daftar` date DEFAULT NULL,
  `masa_layanan` int(11) NOT NULL DEFAULT 1 COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `monev_aktif` */

/*Table structure for table `mutasi_karyawan` */

DROP TABLE IF EXISTS `mutasi_karyawan`;

CREATE TABLE `mutasi_karyawan` (
  `id_mutasi` int(11) NOT NULL AUTO_INCREMENT,
  `id_karyawan` int(11) DEFAULT NULL,
  `tgl_mutasi` date DEFAULT NULL,
  `dari_departemen` varchar(225) DEFAULT NULL,
  `dari_jabatan` varchar(225) DEFAULT NULL,
  `ke_departemen` varchar(225) DEFAULT NULL,
  `ke_jabatan` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id_mutasi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `mutasi_karyawan` */

/*Table structure for table `nonaktif` */

DROP TABLE IF EXISTS `nonaktif`;

CREATE TABLE `nonaktif` (
  `nik` varchar(9) DEFAULT NULL,
  `status` enum('7') NOT NULL DEFAULT '7',
  `id_company` int(5) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `nonaktif` */

/*Table structure for table `otp` */

DROP TABLE IF EXISTS `otp`;

CREATE TABLE `otp` (
  `telepon` varchar(15) NOT NULL,
  `waktu` int(11) NOT NULL,
  `kode_otp` mediumint(9) NOT NULL,
  PRIMARY KEY (`telepon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `otp` */

/*Table structure for table `p_approval_izin` */

DROP TABLE IF EXISTS `p_approval_izin`;

CREATE TABLE `p_approval_izin` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `level_user` varchar(50) NOT NULL,
  `level_approval` varchar(50) NOT NULL COMMENT 'level approval bisa diisi lebih dari satu dengan pemisah tanda koma',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_approval_izin` */

insert  into `p_approval_izin`(`id`,`id_cabang`,`level_user`,`level_approval`,`id_company`,`tgl_input`) values 
('C221004001','C221004001','3','7,2,1','C221004','2022-10-04 15:49:59'),
('C221004002','C221004001','7','2,1','C221004','2022-10-04 15:50:18'),
('C221004003','C221004001','2','5,4','C221004','2022-10-04 15:48:38'),
('C221004004','C221004001','5','4','C221004','2022-10-04 15:48:44'),
('D221004001','D221004001','3','7,2,1','D221004','2022-10-04 15:48:25'),
('D221004002','D221004001','7','2,1','D221004','2022-10-04 15:50:18'),
('D221004003','D221004001','2','5,4','D221004','2022-10-04 15:48:38'),
('D221004004','D221004001','5','4','D221004','2022-10-04 15:48:44');

/*Table structure for table `p_approval_lembur` */

DROP TABLE IF EXISTS `p_approval_lembur`;

CREATE TABLE `p_approval_lembur` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `level_user` varchar(50) NOT NULL,
  `level_approval` varchar(50) NOT NULL COMMENT 'level approval bisa diisi lebih dari satu dengan pemisah tanda koma',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `KEY` (`id_cabang`,`level_user`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_approval_lembur` */

insert  into `p_approval_lembur`(`id`,`id_cabang`,`level_user`,`level_approval`,`id_company`,`tgl_input`) values 
('C221004001','C221004001','3','2','C221004','2022-10-04 15:53:15'),
('C221004002','C221004001','7','2','C221004','2022-10-04 15:53:38'),
('C221004003','C221004001','2','5','C221004','2022-10-04 15:53:58'),
('C221004004','C221004001','5','4','C221004','2022-10-04 15:54:16'),
('D221004001','D221004001','3','2','D221004','2022-10-04 15:53:15'),
('D221004002','D221004001','7','2','D221004','2022-10-04 15:53:38'),
('D221004003','D221004001','2','5','D221004','2022-10-04 15:53:58'),
('D221004004','D221004001','5','4','D221004','2022-10-04 15:54:16');

/*Table structure for table `p_approval_reimbursement` */

DROP TABLE IF EXISTS `p_approval_reimbursement`;

CREATE TABLE `p_approval_reimbursement` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `level_user` varchar(50) NOT NULL,
  `level_approval` varchar(50) NOT NULL COMMENT 'level approval bisa diisi lebih dari satu dengan pemisah tanda koma',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_approval_reimbursement` */

/*Table structure for table `p_atasan` */

DROP TABLE IF EXISTS `p_atasan`;

CREATE TABLE `p_atasan` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `id_jabatan` varchar(50) NOT NULL,
  `atasan` varchar(50) NOT NULL COMMENT 'Atasan adalah id jabatan yg levelnya sama dengan id_jabatan',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_atasan` */

/*Table structure for table `p_jenis_klien` */

DROP TABLE IF EXISTS `p_jenis_klien`;

CREATE TABLE `p_jenis_klien` (
  `id_jenis_klien` varchar(11) NOT NULL,
  `nama_jenis_klien` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_jenis_klien` */

/*Table structure for table `p_kacab` */

DROP TABLE IF EXISTS `p_kacab`;

CREATE TABLE `p_kacab` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=cabang tambahan, 1=cabang utama',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_kacab` */

insert  into `p_kacab`(`id`,`id_karyawan`,`id_cabang`,`flag`,`id_company`,`tgl_input`,`tgl_update`) values 
('C221004202210001','C2210045','C221004001','1','C221004','2022-10-04 16:26:21','2022-10-04 16:26:21'),
('D221004202210001','D2210045','D221004001','1','D221004','2022-10-04 16:22:31','2022-10-04 16:22:31');

/*Table structure for table `p_kedep` */

DROP TABLE IF EXISTS `p_kedep`;

CREATE TABLE `p_kedep` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=departemen tambahan, 1= departemen utama',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_karyawan` (`id_karyawan`,`id_departemen`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_kedep` */

insert  into `p_kedep`(`id`,`id_karyawan`,`id_cabang`,`id_departemen`,`flag`,`id_company`,`tgl_input`,`tgl_update`) values 
('C221004202210001','C2210042','C221004001','C221004202210001','1','C221004','2022-10-04 16:26:21','2022-10-04 16:26:21'),
('D221004202210001','D2210042','D221004001','D221004202210001','1','D221004','2022-10-04 16:22:31','2022-10-04 16:22:31');

/*Table structure for table `p_notification` */

DROP TABLE IF EXISTS `p_notification`;

CREATE TABLE `p_notification` (
  `id_notification` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `notif_hrd` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0= tidak dapat notif, 1=dapat notif',
  `notif_finance` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0= tidak dapat notif, 1=dapat notif',
  `id_company` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_notification`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `p_notification` */

/*Table structure for table `r_absensi` */

DROP TABLE IF EXISTS `r_absensi`;

CREATE TABLE `r_absensi` (
  `id_karyawan` varchar(50) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `nama_karyawan` varchar(255) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `kode_cabang` varchar(20) NOT NULL,
  `nama_cabang` varchar(255) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `kode_departemen` varchar(50) NOT NULL,
  `nama_departemen` varchar(255) NOT NULL,
  `id_jabatan` varchar(50) NOT NULL,
  `kode_jabatan` varchar(50) NOT NULL,
  `nama_jabatan` varchar(255) NOT NULL,
  `supervisi` varchar(50) NOT NULL,
  `nama_supervisi` varchar(255) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jenis_absen` varchar(20) NOT NULL COMMENT 'reguler; shift; libur; izin(Sakit, cuti), alpha',
  `kode_absensi` varchar(255) NOT NULL,
  `ket_kode` varchar(255) NOT NULL,
  `jam_masuk_kerja` time DEFAULT NULL,
  `absen_masuk` datetime DEFAULT NULL,
  `terlambat` int(4) NOT NULL DEFAULT 0,
  `lokasi_masuk` varchar(255) DEFAULT NULL,
  `timezone_masuk` varchar(255) DEFAULT NULL,
  `gmt_masuk` varchar(6) DEFAULT NULL,
  `lat_masuk` varchar(30) DEFAULT NULL,
  `long_masuk` varchar(30) DEFAULT NULL,
  `ket_absen_masuk` text DEFAULT NULL,
  `foto_masuk` text DEFAULT NULL,
  `absen_ist_mulai` datetime DEFAULT NULL,
  `lokasi_ist_mulai` varchar(255) DEFAULT NULL,
  `timezone_ist_mulai` varchar(255) DEFAULT NULL,
  `gmt_ist_mulai` varchar(6) DEFAULT NULL,
  `lat_ist_mulai` varchar(30) DEFAULT NULL,
  `long_ist_mulai` varchar(30) DEFAULT NULL,
  `ket_ist_mulai` text DEFAULT NULL,
  `foto_ist_mulai` text DEFAULT NULL,
  `absen_ist_selesai` datetime DEFAULT NULL,
  `lokasi_ist_selesai` varchar(255) DEFAULT NULL,
  `timezone_ist_selesai` varchar(255) DEFAULT NULL,
  `gmt_ist_selesai` varchar(6) DEFAULT NULL,
  `lat_ist_selesai` varchar(30) DEFAULT NULL,
  `long_ist_selesai` varchar(30) DEFAULT NULL,
  `ket_ist_selesai` text DEFAULT NULL,
  `foto_ist_selesai` text DEFAULT NULL,
  `jam_pulang_kerja` time DEFAULT NULL,
  `absen_pulang` datetime DEFAULT NULL,
  `pulang_cepat` int(4) NOT NULL DEFAULT 0,
  `lokasi_pulang` varchar(255) DEFAULT NULL,
  `timezone_pulang` text DEFAULT NULL,
  `gmt_pulang` tinytext DEFAULT NULL,
  `lat_pulang` varchar(30) DEFAULT NULL,
  `long_pulang` varchar(30) DEFAULT NULL,
  `ket_absen_pulang` text DEFAULT NULL,
  `foto_absen_pulang` text DEFAULT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_karyawan`,`tgl_absen`,`id_company`),
  KEY `filter_1` (`id_company`,`tgl_absen`),
  KEY `filter_2` (`id_company`,`tgl_absen`,`id_karyawan`),
  KEY `filter_3` (`id_company`,`tgl_absen`,`id_cabang`),
  KEY `filter_4` (`id_company`,`tgl_absen`,`id_cabang`,`id_departemen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `r_absensi` */

/*Table structure for table `r_lembur` */

DROP TABLE IF EXISTS `r_lembur`;

CREATE TABLE `r_lembur` (
  `id_lembur` varchar(50) NOT NULL,
  `tgl_lembur` date NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `nama_karyawan` varchar(250) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `nama_cabang` varchar(250) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `nama_departemen` varchar(250) NOT NULL,
  `id_jabatan` varchar(50) NOT NULL,
  `nama_jabatan` varchar(250) NOT NULL,
  `ttl_lembur` varchar(50) NOT NULL DEFAULT '0',
  `lembur_mulai` datetime NOT NULL,
  `lok_mulai` varchar(225) DEFAULT NULL,
  `timezone_mulai` varchar(150) DEFAULT NULL,
  `gmt_mulai` varchar(225) DEFAULT NULL,
  `lat_mulai` varchar(50) NOT NULL,
  `long_mulai` varchar(50) NOT NULL,
  `ket_mulai` varchar(225) NOT NULL,
  `foto_mulai` varchar(225) DEFAULT NULL,
  `lembur_selesai` datetime NOT NULL,
  `lok_selesai` varchar(225) DEFAULT NULL,
  `timezone_selesai` varchar(150) DEFAULT NULL,
  `gmt_selesai` varchar(100) DEFAULT NULL,
  `lat_selesai` varchar(50) NOT NULL,
  `long_selesai` varchar(50) NOT NULL,
  `ket_selesai` varchar(225) NOT NULL,
  `foto_selesai` varchar(225) NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_lembur`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `r_lembur` */

/*Table structure for table `r_login_mobile` */

DROP TABLE IF EXISTS `r_login_mobile`;

CREATE TABLE `r_login_mobile` (
  `id_karyawan` varchar(50) NOT NULL,
  `nama_karyawan` varchar(100) NOT NULL,
  `emulator` enum('false','true') NOT NULL DEFAULT 'false',
  `os` varchar(100) NOT NULL,
  `versi_os` varchar(100) NOT NULL,
  `base_os` varchar(100) NOT NULL,
  `brand` varchar(100) NOT NULL,
  `model` varchar(100) NOT NULL,
  `token_fcm` varchar(200) NOT NULL,
  `device_id` varchar(100) NOT NULL,
  `tgl_login` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `id_company` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `r_login_mobile` */

insert  into `r_login_mobile`(`id_karyawan`,`nama_karyawan`,`emulator`,`os`,`versi_os`,`base_os`,`brand`,`model`,`token_fcm`,`device_id`,`tgl_login`,`id_company`) values 
('D220905003','Example Staff','false','Android','10','','Redmi','M2003J15SC','fqBtvNHFQyOOFe8YNp36-U:APA91bH1r2PbLtNOtDSRedrbGkinsxSezFOl-fRWiXeeUlV_grtek6rPavLIf1ycOX2JVSJGX2TYpQAcRw3-fDTSKKGA8-IRZmU-z2JH7LgNxmr1CjKk4KzI7SghRfz4o9zLGALX04AK','20c37f0df179eab7','2022-09-05 14:46:02','D220905');

/*Table structure for table `r_plan` */

DROP TABLE IF EXISTS `r_plan`;

CREATE TABLE `r_plan` (
  `id_plan` int(11) NOT NULL AUTO_INCREMENT,
  `id_customer` int(11) NOT NULL,
  `status` int(11) NOT NULL COMMENT '2=trial; 3=lunas/aktif; 4=request aktivasi; 5=perpanjangan; 6=Layanan Berakhir',
  `tgl_aktif` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `tgl_daftar` date DEFAULT NULL,
  `masa_layanan` int(11) NOT NULL DEFAULT 1 COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan',
  `max_cabang` varchar(10) NOT NULL DEFAULT '~',
  `max_karyawan` varchar(10) NOT NULL DEFAULT '~',
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id_plan`),
  KEY `master_plan` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `r_plan` */

/*Table structure for table `referal` */

DROP TABLE IF EXISTS `referal`;

CREATE TABLE `referal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_company` int(11) NOT NULL,
  `nama_company_referal` varchar(100) NOT NULL,
  `email_referal` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `referal` */

/*Table structure for table `reimbursement_akun` */

DROP TABLE IF EXISTS `reimbursement_akun`;

CREATE TABLE `reimbursement_akun` (
  `id_akun` varchar(50) NOT NULL,
  `kode_akun` varchar(20) NOT NULL,
  `nama_akun` varchar(150) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `user_input` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(50) NOT NULL,
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_akun`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `reimbursement_akun` */

/*Table structure for table `reimbursement_data` */

DROP TABLE IF EXISTS `reimbursement_data`;

CREATE TABLE `reimbursement_data` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_pengajuan_reimbursement` varchar(50) NOT NULL,
  `id_karyawan` varchar(100) NOT NULL,
  `id_jenis_reimbursement` varchar(50) NOT NULL,
  `nominal` int(11) NOT NULL,
  `nominal_disetujui` int(11) NOT NULL,
  `keterangan` text DEFAULT NULL,
  `tgl_bukti` date NOT NULL,
  `file` text DEFAULT NULL COMMENT 'uploads/reimbursement/id_company/id_karyawan/yyyymm/nama_file',
  `kode_akun` varchar(100) NOT NULL COMMENT 'kode-nama',
  `apv_spv` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_kedep` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_kacab` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_finance` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_direksi` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `ket_rev_spv` text DEFAULT NULL COMMENT 'Keterangan Revisi',
  `ket_rev_kedep` text DEFAULT NULL COMMENT 'Keterangan Revisi',
  `ket_rev_kacab` text DEFAULT NULL COMMENT 'Keterangan Revisi',
  `ket_rev_finance` text DEFAULT NULL COMMENT 'Keterangan Revisi',
  `ket_rev_direksi` text DEFAULT NULL COMMENT 'Keterangan Revisi',
  `ket_tolak_spv` text DEFAULT NULL,
  `ket_tolak_kedep` text DEFAULT NULL,
  `ket_tolak_kacab` text DEFAULT NULL,
  `ket_tolak_finance` text DEFAULT NULL,
  `ket_tolak_direksi` text DEFAULT NULL,
  `user_spv` varchar(100) DEFAULT NULL,
  `user_kedep` varchar(100) DEFAULT NULL,
  `user_kacab` varchar(100) DEFAULT NULL,
  `user_finance` varchar(100) DEFAULT NULL,
  `user_direksi` varchar(100) DEFAULT NULL,
  `tgl_apv_spv` datetime DEFAULT NULL,
  `tgl_apv_kedep` datetime DEFAULT NULL,
  `tgl_apv_kacab` datetime DEFAULT NULL,
  `tgl_apv_finance` datetime DEFAULT NULL,
  `tgl_apv_direksi` datetime DEFAULT NULL,
  `id_company` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `reimbursement_data` */

/*Table structure for table `reimbursement_jenis` */

DROP TABLE IF EXISTS `reimbursement_jenis`;

CREATE TABLE `reimbursement_jenis` (
  `id_jenis_reimbursement` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `jenis_plafon` varchar(150) NOT NULL,
  `max_nominal_plafon` float NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id_jenis_reimbursement`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `reimbursement_jenis` */

/*Table structure for table `reimbursement_pengajuan` */

DROP TABLE IF EXISTS `reimbursement_pengajuan`;

CREATE TABLE `reimbursement_pengajuan` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `no_pengajuan` varchar(50) NOT NULL COMMENT 'yyyymm + 4 digit nomor urut',
  `tgl_pengajuan` datetime NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `status` enum('1','2','3','4','5') NOT NULL COMMENT '1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui,',
  `apv_spv` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_kedep` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_kacab` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_finance` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_direksi` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `user_spv` varchar(50) DEFAULT NULL,
  `user_kedep` varchar(50) DEFAULT NULL,
  `user_kacab` varchar(50) DEFAULT NULL,
  `user_finance` varchar(50) DEFAULT NULL,
  `user_direksi` varchar(50) DEFAULT NULL,
  `tgl_apv_spv` datetime DEFAULT NULL,
  `tgl_apv_kedep` datetime DEFAULT NULL,
  `tgl_apv_kacab` datetime DEFAULT NULL,
  `tgl_apv_finance` datetime DEFAULT NULL,
  `tgl_apv_direksi` datetime DEFAULT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `reimbursement_pengajuan` */

/*Table structure for table `reimbursement_temp` */

DROP TABLE IF EXISTS `reimbursement_temp`;

CREATE TABLE `reimbursement_temp` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(100) NOT NULL,
  `id_jenis_reimbursement` varchar(50) NOT NULL,
  `nominal` int(11) NOT NULL,
  `keterangan` text NOT NULL,
  `tgl_bukti` date NOT NULL,
  `file` text NOT NULL,
  `id_company` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `reimbursement_temp` */

/*Table structure for table `reset_password` */

DROP TABLE IF EXISTS `reset_password`;

CREATE TABLE `reset_password` (
  `id_reset` int(11) NOT NULL AUTO_INCREMENT,
  `id_karyawan` varchar(50) NOT NULL,
  `email` varchar(255) NOT NULL,
  `aktif` int(11) NOT NULL,
  `id_company` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id_reset`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `reset_password` */

/*Table structure for table `riwayat_pekerjaan` */

DROP TABLE IF EXISTS `riwayat_pekerjaan`;

CREATE TABLE `riwayat_pekerjaan` (
  `id_riwayat_pekerjaan` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `nama_perusahaan` varchar(250) NOT NULL,
  `jenis_perusahaan` varchar(250) NOT NULL,
  `jabatan` varchar(250) NOT NULL,
  `kota` varchar(150) NOT NULL,
  `provinsi` varchar(150) NOT NULL,
  `alamat_perusahaan` text NOT NULL,
  `tgl_masuk` date NOT NULL,
  `tgl_keluar` date NOT NULL,
  `alasan_berhenti` text NOT NULL,
  `file` varchar(250) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `riwayat_pekerjaan` */

/*Table structure for table `riwayat_pendidikan` */

DROP TABLE IF EXISTS `riwayat_pendidikan`;

CREATE TABLE `riwayat_pendidikan` (
  `id_riwayat_pendidikan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `nama_sekolah` varchar(150) NOT NULL,
  `jenjang` varchar(50) NOT NULL,
  `jurusan` varchar(150) NOT NULL,
  `lulusan_asal` varchar(100) NOT NULL,
  `gelar` varchar(50) NOT NULL,
  `tahun_masuk` varchar(4) NOT NULL,
  `tahun_lulus` varchar(4) NOT NULL,
  `ijazah` varchar(250) NOT NULL,
  `transkrip` varchar(250) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_riwayat_pendidikan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `riwayat_pendidikan` */

/*Table structure for table `slip_gaji` */

DROP TABLE IF EXISTS `slip_gaji`;

CREATE TABLE `slip_gaji` (
  `id_slip` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nama` varchar(50) NOT NULL,
  `jabatan` varchar(50) NOT NULL,
  `no_rekening` varchar(50) NOT NULL,
  `gaji_pokok` varchar(50) NOT NULL DEFAULT '0',
  `tunj_jab` varchar(50) NOT NULL DEFAULT '0',
  `tunj_ops` varchar(50) NOT NULL DEFAULT '0',
  `thp` varchar(50) NOT NULL DEFAULT '0',
  `tunj_transport` varchar(50) NOT NULL DEFAULT '0',
  `uang_makan` varchar(50) NOT NULL DEFAULT '0',
  `total_gaji` varchar(50) NOT NULL DEFAULT '0',
  `lain_lain` varchar(50) NOT NULL DEFAULT '0',
  `tunj_istri` varchar(50) NOT NULL DEFAULT '0',
  `tunj_anak` varchar(50) NOT NULL DEFAULT '0',
  `komisi` varchar(50) NOT NULL DEFAULT '0',
  `lembur` varchar(50) NOT NULL DEFAULT '0',
  `cashbon` varchar(50) NOT NULL DEFAULT '0',
  `koperasi` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ketenagakerjaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_kesehatan` varchar(50) NOT NULL DEFAULT '0',
  `iuran_koperasi` varchar(50) NOT NULL DEFAULT '0',
  `absensi` varchar(50) NOT NULL DEFAULT '0',
  `kekurangan_sebelumnya` varchar(50) NOT NULL DEFAULT '0',
  `gaji_bersih` varchar(50) NOT NULL DEFAULT '0',
  `nik` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_tk_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ks_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `axa` varchar(50) NOT NULL DEFAULT '0',
  `pot_asuransi` varchar(20) NOT NULL DEFAULT '0' COMMENT 'personal',
  `email` varchar(100) DEFAULT NULL,
  `nikx` varchar(100) DEFAULT NULL,
  `kirim` tinyint(4) NOT NULL DEFAULT 0,
  `id_company` int(11) NOT NULL DEFAULT 1,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_slip`),
  KEY `slip_gaji` (`tanggal`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `slip_gaji` */

/*Table structure for table `slip_gaji_temp` */

DROP TABLE IF EXISTS `slip_gaji_temp`;

CREATE TABLE `slip_gaji_temp` (
  `id_slip_temp` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `flag` int(11) NOT NULL DEFAULT 0,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tanggal` date NOT NULL,
  `nama` varchar(50) NOT NULL,
  `jabatan` varchar(50) NOT NULL,
  `no_rekening` varchar(50) NOT NULL,
  `gaji_pokok` varchar(50) NOT NULL DEFAULT '0',
  `tunj_jab` varchar(50) NOT NULL DEFAULT '0',
  `tunj_ops` varchar(50) NOT NULL DEFAULT '0',
  `thp` varchar(50) NOT NULL DEFAULT '0',
  `tunj_transport` varchar(50) NOT NULL DEFAULT '0',
  `uang_makan` varchar(50) NOT NULL DEFAULT '0',
  `total_gaji` varchar(50) NOT NULL DEFAULT '0',
  `lain_lain` varchar(50) NOT NULL DEFAULT '0',
  `tunj_istri` varchar(50) NOT NULL DEFAULT '0',
  `tunj_anak` varchar(50) NOT NULL DEFAULT '0',
  `komisi` varchar(50) NOT NULL DEFAULT '0',
  `lembur` varchar(50) NOT NULL DEFAULT '0',
  `cashbon` varchar(50) NOT NULL DEFAULT '0',
  `koperasi` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ketenagakerjaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_kesehatan` varchar(50) NOT NULL DEFAULT '0',
  `iuran_koperasi` varchar(50) NOT NULL DEFAULT '0',
  `absensi` varchar(50) NOT NULL DEFAULT '0',
  `kekurangan_sebelumnya` varchar(50) NOT NULL DEFAULT '0',
  `gaji_bersih` varchar(50) NOT NULL DEFAULT '0',
  `nik` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_tk_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ks_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `axa` varchar(50) NOT NULL DEFAULT '0',
  `pot_asuransi` varchar(50) NOT NULL DEFAULT '0',
  `email` varchar(100) NOT NULL DEFAULT '0',
  `kirim` tinyint(4) NOT NULL DEFAULT 0,
  `id_company` int(11) NOT NULL,
  `nikx` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_slip_temp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `slip_gaji_temp` */

/*Table structure for table `status_karyawan` */

DROP TABLE IF EXISTS `status_karyawan`;

CREATE TABLE `status_karyawan` (
  `id_status` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(250) NOT NULL,
  PRIMARY KEY (`id_status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `status_karyawan` */

/*Table structure for table `tb_history` */

DROP TABLE IF EXISTS `tb_history`;

CREATE TABLE `tb_history` (
  `id_history` int(11) NOT NULL AUTO_INCREMENT,
  `id_company` int(11) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `tgl_request` datetime DEFAULT NULL,
  `tgl_approval_marketing` datetime DEFAULT NULL,
  `tgl_approval_support` datetime DEFAULT NULL,
  `id_paket` int(11) DEFAULT NULL,
  `id_paket_lama` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_history`)
) ENGINE=InnoDB AUTO_INCREMENT=26100 DEFAULT CHARSET=latin1;

/*Data for the table `tb_history` */

/*Table structure for table `tb_invoice` */

DROP TABLE IF EXISTS `tb_invoice`;

CREATE TABLE `tb_invoice` (
  `id_invoice` int(11) NOT NULL AUTO_INCREMENT,
  `tgl_invoice` datetime DEFAULT NULL,
  `tgl_jatuh_tempo` datetime DEFAULT NULL,
  `total` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `tgl_bayar` datetime DEFAULT NULL,
  `gateway` varchar(255) DEFAULT NULL,
  `id_order` varchar(20) DEFAULT NULL COMMENT 'relasi dengan id_transaksi pada tabel tb_transaksi',
  PRIMARY KEY (`id_invoice`),
  KEY `id_order` (`id_order`)
) ENGINE=InnoDB AUTO_INCREMENT=5750 DEFAULT CHARSET=latin1;

/*Data for the table `tb_invoice` */

/*Table structure for table `tb_paket` */

DROP TABLE IF EXISTS `tb_paket`;

CREATE TABLE `tb_paket` (
  `id_tb_paket` int(11) NOT NULL,
  `id_paket` int(11) DEFAULT NULL,
  `nama` varchar(100) NOT NULL,
  `tarif` float NOT NULL,
  `komponen_web` longtext NOT NULL,
  `komponen_mobile` varchar(255) NOT NULL COMMENT '1=izin, 2=lembur, 3=shift, 4= remburse, 5=info gaji, 6=aktivitas, 7=berita',
  `max_karyawan` int(11) NOT NULL DEFAULT 0,
  `max_cabang` varchar(250) NOT NULL DEFAULT '-',
  `id_company` varchar(255) NOT NULL,
  PRIMARY KEY (`id_tb_paket`),
  KEY `idx_idpaket` (`id_paket`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `tb_paket` */

insert  into `tb_paket`(`id_tb_paket`,`id_paket`,`nama`,`tarif`,`komponen_web`,`komponen_mobile`,`max_karyawan`,`max_cabang`,`id_company`) values 
(202108007,13,'Absenku Custom',0,'1-1-1-1-1-1-1-1-1-1-1-1-1-1-1-1-1-1-1-1-1-1-1-1-1','1-1-1-0-1-1-1',30,'-','');

/*Table structure for table `tb_transaksi` */

DROP TABLE IF EXISTS `tb_transaksi`;

CREATE TABLE `tb_transaksi` (
  `id_transaksi` varchar(20) NOT NULL COMMENT 'id_company + yyyy + 2 digit',
  `id_company` int(11) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `tgl_aktif` date DEFAULT NULL COMMENT 'tgl_berakhir',
  `id_tb_paket` int(11) DEFAULT NULL,
  `masa_layanan` int(11) DEFAULT NULL COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan',
  `sub_total` varchar(15) NOT NULL DEFAULT '0',
  `diskon` varchar(15) NOT NULL DEFAULT '0',
  `ppn` varchar(15) NOT NULL DEFAULT '0',
  `materai` int(11) NOT NULL DEFAULT 0,
  `tagihan` varchar(15) NOT NULL DEFAULT '0',
  `opsi` int(11) NOT NULL DEFAULT 1 COMMENT '1=beli; 2=perpanjang; 3=ubah',
  `status` int(11) NOT NULL COMMENT '1=belum bayar; 2=waiting; 3=aktif',
  `tarif` int(11) NOT NULL DEFAULT 0,
  `dp` int(11) NOT NULL DEFAULT 0,
  `jenis_hutang_piutang` enum('0','1') NOT NULL DEFAULT '0',
  `hutang_piutang` int(11) NOT NULL DEFAULT 0,
  `keterangan` text DEFAULT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_transaksi`),
  KEY `tb_transaksi` (`id_company`,`opsi`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `tb_transaksi` */

/*Table structure for table `token_auto_login` */

DROP TABLE IF EXISTS `token_auto_login`;

CREATE TABLE `token_auto_login` (
  `id_company` int(11) NOT NULL,
  `token` varchar(100) NOT NULL,
  `waktu` datetime DEFAULT NULL,
  `tgl_input` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='tabel untuk menyimpan token fitur auto login';

/*Data for the table `token_auto_login` */

/*Table structure for table `user_dashboard` */

DROP TABLE IF EXISTS `user_dashboard`;

CREATE TABLE `user_dashboard` (
  `id_user` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(10) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `nama` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `level` int(11) DEFAULT NULL COMMENT '1=admin; 2=marketing; 3=apps; 4=finance;',
  PRIMARY KEY (`id_user`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;

/*Data for the table `user_dashboard` */

/*Table structure for table `usergroup` */

DROP TABLE IF EXISTS `usergroup`;

CREATE TABLE `usergroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(50) NOT NULL,
  `urutan` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

/*Data for the table `usergroup` */

insert  into `usergroup`(`id`,`level`,`urutan`) values 
(1,'Administrator',1),
(2,'Kepala Departemen',5),
(3,'Pegawai',7),
(4,'Direksi',3),
(5,'Kepala Cabang',4),
(6,'Admin Finance',2),
(7,'Supervisi',6);

/*Table structure for table `users` */

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id_user` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4digit nomor urut',
  `username` varchar(50) NOT NULL,
  `password` varchar(100) NOT NULL DEFAULT '2bdbce3554458f3211dd08fdd30d86f1a180dce4',
  `password_2` varchar(100) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `device_id` varchar(255) NOT NULL,
  `lock_device` enum('0','1') NOT NULL DEFAULT '0',
  `token_fcm` varchar(255) NOT NULL,
  `lock_facerecognition` enum('0','1') DEFAULT '0',
  `matrix_facerecognition` text DEFAULT NULL,
  `foto_facerecognition` text DEFAULT NULL,
  `kamera` enum('0','1') NOT NULL DEFAULT '1',
  `login` tinyint(4) NOT NULL DEFAULT 0,
  `id_company` varchar(11) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_user`),
  KEY `user` (`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `users` */

insert  into `users`(`id_user`,`username`,`password`,`password_2`,`id_karyawan`,`device_id`,`lock_device`,`token_fcm`,`lock_facerecognition`,`matrix_facerecognition`,`foto_facerecognition`,`kamera`,`login`,`id_company`,`tgl_input`) values 
('C2210040001','administrator','2bdbce3554458f3211dd08fdd30d86f1a180dce4','593596','C221004001','','0','','0',NULL,NULL,'1',1,'C221004','2022-10-04 15:16:11'),
('C2210042022100001','e_hod','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2210042','','0','','0',NULL,NULL,'1',0,'C221004','2022-10-04 16:26:21'),
('C2210042022100002','e_staff','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2210043','','0','','0',NULL,NULL,'1',0,'C221004','2022-10-04 16:26:21'),
('C2210042022100003','e_direksi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2210044','','0','','0',NULL,NULL,'1',0,'C221004','2022-10-04 16:26:21'),
('C2210042022100004','e_kacab','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2210045','','0','','0',NULL,NULL,'1',0,'C221004','2022-10-04 16:26:21'),
('C2210042022100005','e_finance','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2210046','','0','','0',NULL,NULL,'1',0,'C221004','2022-10-04 16:26:21'),
('C2210042022100006','e_supervisi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C2210047','','0','','0',NULL,NULL,'1',0,'C221004','2022-10-04 16:26:21'),
('D2210040001','de_admin','2bdbce3554458f3211dd08fdd30d86f1a180dce4','593596','D221004001','','0','','0',NULL,NULL,'1',1,'D221004','2022-10-04 15:16:11'),
('D2210042022100005','de_finance','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2210046','','0','','0',NULL,NULL,'1',0,'D221004','2022-10-04 16:13:41'),
('D2210042022100006','de_hod','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2210042','','0','','0',NULL,NULL,'1',0,'D221004','2022-10-04 16:22:31'),
('D2210042022100007','de_staff','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2210043','','0','','0',NULL,NULL,'1',0,'D221004','2022-10-04 16:22:31'),
('D2210042022100008','de_direksi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2210044','','0','','0',NULL,NULL,'1',0,'D221004','2022-10-04 16:22:31'),
('D2210042022100009','de_kacab','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2210045','','0','','0',NULL,NULL,'1',0,'D221004','2022-10-04 16:22:31'),
('D2210042022100010','de_supervisi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D2210047','','0','','0',NULL,NULL,'1',0,'D221004','2022-10-04 16:22:31');

/*Table structure for table `v_aplikasi` */

DROP TABLE IF EXISTS `v_aplikasi`;

CREATE TABLE `v_aplikasi` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `version_code` varchar(50) NOT NULL,
  `version_name` varchar(50) NOT NULL,
  `keterangan_update` text NOT NULL,
  `aktif` enum('0','1') NOT NULL DEFAULT '0',
  `force_update` enum('0','1') NOT NULL DEFAULT '0',
  `link_update` text NOT NULL,
  `link_update_android` varchar(255) NOT NULL,
  `link_update_ios` varchar(255) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `v_aplikasi` */

/*Table structure for table `wilayah` */

DROP TABLE IF EXISTS `wilayah`;

CREATE TABLE `wilayah` (
  `kode` varchar(13) NOT NULL,
  `nama` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `wilayah` */

/*Table structure for table `wizard` */

DROP TABLE IF EXISTS `wizard`;

CREATE TABLE `wizard` (
  `data_lokasi` enum('0','1') NOT NULL DEFAULT '0',
  `akun_kedep` enum('0','1') NOT NULL DEFAULT '0',
  `akun_staff` enum('0','1') NOT NULL DEFAULT '0',
  `tambah_akun` enum('0','1') NOT NULL DEFAULT '0',
  `selesai` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `wizard` */

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
