<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Karyawan extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Karyawan_m');

		$this->level_user           = $this->session->userdata('level_user');
        $this->id_company           = $this->session->userdata('id_company');
        $this->multi_cabang         = $this->session->userdata('multi_cabang');
        $this->id_cabang            = $this->session->userdata('id_cabang');
        $this->id_cabang_arr        = $this->session->userdata('id_cabang_arr');
        $this->multi_departemen     = $this->session->userdata('multi_departemen');
        $this->id_departemen        = $this->session->userdata('id_departemen');
        $this->id_departemen_arr    = $this->session->userdata('id_departemen_arr');
        $this->id_karyawan          = $this->session->userdata('id_karyawan');
    }

	public function index(){
		$data['judul'] = 'Karyawan';
		$data['aktif'] = 'karyawan';
		$this->session->set_userdata('id_kar',0);
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('karyawan/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function tabs($tabs = null){
		if($tabs == "jabatan"){
			$this->load->view('karyawan/tabs_jabatan');
		}else if($tabs == "pengguna_aktif"){
			$this->load->view('karyawan/tabs_pengguna_aktif');
		}else if($tabs == "pendidikan"){
			$this->load->view('karyawan/tabs_pendidikan');
		}else if($tabs == "lokasi"){
			$this->load->view('karyawan/tabs_lokasi');
		}else if($tabs == "device"){
			$this->load->view('karyawan/tabs_device');
		}else if($tabs == "facerecognition"){
			$this->load->view('karyawan/tabs_facerecognition');
		}else if($tabs == "camera"){
			$this->load->view('karyawan/tabs_camera');
		}

	}

	public function form($id_karyawan=null){
		$data['judul'] = 'Tambah Karyawan';
		$data['aktif'] = 'Tambah Karyawan';
		$data['menu'] = $this->load->view('main_menu', $data, true);
		if($id==null){
			$data['content'] = $this->load->view('karyawan/form', $data, true);
		}else{
			$data['data'] = $this->Karyawan_m->getDataById($id_karyawan);
			$data['id'] = $data['data']->id_karyawan;
			$data['content'] = $this->load->view('karyawan/form', $data, true);
		}

		$data['menu'] = $this->load->view('main_menu', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function detail($id_karyawan){
		$data['judul'] = 'Karyawan';
		$data['aktif'] = 'karyawan';
		$data['row'] = $this->Karyawan_m->getDataById($id_karyawan);
		$data['id_karyawan'] = md5($data['row']->id_karyawan);
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('karyawan/karyawan_detail', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function data_tabs_jabatan($jenis=null, $id_cabang="0", $id_departemen="0", $id_jabatan="0", $status="0",$id_karyawan="0"){
		$list = $this->Karyawan_m->get_datatables_tabs_jabatan($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $id_karyawan);
		$jml_admin = $this->Karyawan_m->getDataById_numrows();
		$jml_finance = $this->Karyawan_m->getDataByIFnc_numrows();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();

			$foto = $this->config->item('base_image').'imagebiodata?_t=photo&_d='.$field->foto;

			$row[] = $no;
			$row[] = '<img class="media-object avatar avatar-sm img-fit-cover" src="'.$foto.'" style="border-radius: 2;">';
			$row[] = '<a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" class="media border-0">'.$field->nama_lengkap.'</a>'.$field->nik;
			$row[] = isset($field->nama_cabang) ? $field->kode_cabang." - ".$field->nama_cabang: "";
			$row[] = isset($field->nama_departemen) ? $field->kode_departemen." - ".$field->nama_departemen : "-";
			$row[] = isset($field->nama_jabatan) ? $field->kode_jabatan." - ".$field->nama_jabatan : "";
			$row[] = $this->fungsi->status_karyawan($field->status);

			$btn_detail = '<a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary"><i class="btn_detail fa fa-info-circle (alias) "> </i></a>';
			$btn_hapus = '<a href="#" title="Delete" class="text-danger"><i class="btn_delete fa fa-trash" id="'.md5($field->id_karyawan).'"></i></a>';

			if($this->level_user == '1') {
				if ($field->level_user == 1) {
					if ($jml_admin >1) {
						$row[] = $btn_detail.'&nbsp;'.$btn_hapus;
					}else{
						$row[] = $btn_detail;
					}
				}else if($field->level_user == 6){
					if ($jml_finance >1) {
						$row[] = $btn_detail.'&nbsp;'.$btn_hapus;
					}else{
						$row[] = $btn_detail;
					}
				}else{
					$row[] = $btn_detail.'&nbsp;'.$btn_hapus;
				}
			}else{
				$row[] = $btn_detail;
			}

			$data[] = $row;
		}

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Karyawan_m->count_all_tabs_jabatan($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $id_karyawan),
							"recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_jabatan($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $id_karyawan),
							"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function data_tabs_pengguna_aktif($jenis=null, $id_cabang="0", $id_departemen="0", $id_jabatan="0", $id_karyawan="0"){
		$list = $this->Karyawan_m->get_datatables_tabs_pengguna_aktif($jenis, $id_cabang, $id_departemen, $id_jabatan, $id_karyawan);
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();

			$foto = $this->config->item('base_image').'imagebiodata?_t=photo&_d='.$field->foto;

			$row[] = $no;
			$row[] = '<img class="media-object avatar avatar-sm img-fit-cover" src="'.$foto.'" style="border-radius: 2;">';
			$row[] = '<a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" class="media border-0">'.$field->nama_lengkap.'</a>'.$field->nik;
			$row[] = isset($field->nama_cabang) ? $field->kode_cabang." - ".$field->nama_cabang: "";
			$row[] = isset($field->nama_departemen) ? $field->kode_departemen." - ".$field->nama_departemen : "-";
			$row[] = isset($field->nama_jabatan) ? $field->kode_jabatan." - ".$field->nama_jabatan : "";

			if(in_array($this->session->userdata('level_user'), array("1"))) {
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="'.md5($field->id_karyawan).'"></i>
                                </a>';
			}else{
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
			}

			$data[] = $row;
		}

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Karyawan_m->count_all_tabs_pengguna_aktif($jenis, $id_cabang, $id_departemen, $id_jabatan, $id_karyawan),
							"recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_pengguna_aktif($jenis, $id_cabang, $id_departemen, $id_jabatan, $id_karyawan),
							"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function data_tabs_pendidikan($jenis=null, $id_cabang="0", $id_departemen="0", $id_jabatan="0", $pendidikan="0",$id_karyawan="0"){
		$list = $this->Karyawan_m->get_datatables_tabs_pendidikan($jenis, $id_cabang, $id_departemen, $id_jabatan, $pendidikan, $id_karyawan);
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();

			$foto = $this->config->item('base_image').'imagebiodata?_t=photo&_d='.$field->foto;

			$row[] = $no;
			$row[] = '<img class="media-object avatar avatar-sm img-fit-cover" src="'.$foto.'" style="border-radius: 2;">';
			$row[] = '<a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" class="media border-0">'.$field->nama_lengkap.'</a>'.$field->nik;
			$row[] = $field->kode_cabang." - ".$field->nama_cabang;
			$row[] = $field->kode_departemen." - ".$field->nama_departemen;
			$row[] = $field->kode_jabatan." - ".$field->nama_jabatan;
			$row[] = $field->pendidikan_terakhir;

			if(in_array($this->session->userdata('level_user'), array("1"))) {
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="'.md5($field->id_karyawan).'"></i>
                                </a>';
			}else{
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
			}

			$data[] = $row;
		}

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Karyawan_m->count_all_tabs_pendidikan($jenis, $id_cabang, $id_departemen, $id_jabatan, $pendidikan, $id_karyawan),
							"recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_pendidikan($jenis, $id_cabang, $id_departemen, $id_jabatan, $pendidikan, $id_karyawan),
							"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function data_tabs_lokasi($jenis=null, $id_cabang="-", $id_departemen="-", $id_jabatan="-", $lock_lokasi="-",$id_karyawan="-"){
		$list = $this->Karyawan_m->get_datatables_tabs_lokasi($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_lokasi, $id_karyawan);
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();

			$foto = $this->config->item('base_image').'imagebiodata?_t=photo&_d='.$field->foto;

			$row[] = $no;
			$row[] = '<img class="media-object avatar avatar-sm img-fit-cover" src="'.$foto.'" style="border-radius: 2;">';
			$row[] = '<a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" class="media border-0">'.$field->nama_lengkap.'</a>'.$field->nik;
			$row[] = $field->kode_cabang." - ".$field->nama_cabang;
			$row[] = $field->kode_departemen." - ".$field->nama_departemen;
			$row[] = $field->kode_jabatan." - ".$field->nama_jabatan;
			$row[] = ($field->lock_lokasi === "0")?'<div class="badge badge-warning">Tidak</div>':'<div class="badge badge-success">Ya</div>';

			if(in_array($this->session->userdata('level_user'), array("1"))) {
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="'.md5($field->id_karyawan).'"></i>
                                </a>';
			}else{
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
			}

			$data[] = $row;
		}

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Karyawan_m->count_all_tabs_lokasi($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_lokasi, $id_karyawan),
							"recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_lokasi($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_lokasi, $id_karyawan),
							"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function data_tabs_device($jenis=null, $id_cabang="-", $id_departemen="-", $id_jabatan="-", $lock_device="-",$id_karyawan="-"){
		$list = $this->Karyawan_m->get_datatables_tabs_device($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_device, $id_karyawan);
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();

			$foto = $this->config->item('base_image').'imagebiodata?_t=photo&_d='.$field->foto;

			$row[] = $no;
			$row[] = '<img class="media-object avatar avatar-sm img-fit-cover" src="'.$foto.'" style="border-radius: 2;">';
			$row[] = '<a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" class="media border-0">'.$field->nama_lengkap.'</a>'.$field->nik;
			$row[] = $field->kode_cabang." - ".$field->nama_cabang;
			$row[] = $field->kode_departemen." - ".$field->nama_departemen;
			$row[] = $field->kode_jabatan." - ".$field->nama_jabatan;
			$row[] = ($field->lock_device === "0")?'<div class="badge badge-warning">Tidak</div>':'<div class="badge badge-success">Ya</div>';

			if(in_array($this->session->userdata('level_user'), array("1"))) {
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="'.md5($field->id_karyawan).'"></i>
                                </a>';
			}else{
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
			}

			$data[] = $row;
		}

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Karyawan_m->count_all_tabs_device($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_device, $id_karyawan),
							"recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_device($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_device, $id_karyawan),
							"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function data_tabs_facerecognition($jenis=null, $id_cabang="-", $id_departemen="-", $id_jabatan="-", $lock_facerecognition="-",$id_karyawan="-"){
		$list = $this->Karyawan_m->get_datatables_tabs_facerecognition($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_facerecognition, $id_karyawan);
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();

			$foto = $this->config->item('base_image').'imagebiodata?_t=photo&_d='.$field->foto;

			$row[] = $no;
			$row[] = '<img class="media-object avatar avatar-sm img-fit-cover" src="'.$foto.'" style="border-radius: 2;">';
			$row[] = '<a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" class="media border-0">'.$field->nama_lengkap.'</a>'.$field->nik;
			$row[] = $field->kode_cabang." - ".$field->nama_cabang;
			$row[] = $field->kode_departemen." - ".$field->nama_departemen;
			$row[] = $field->kode_jabatan." - ".$field->nama_jabatan;
			$row[] = ($field->lock_facerecognition === "0")?'<div class="badge badge-warning">Tidak</div>':'<div class="badge badge-success">Ya</div>';

			if(in_array($this->session->userdata('level_user'), array("1"))) {
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="'.md5($field->id_karyawan).'"></i>
                                </a>';
			}else{
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
			}

			$data[] = $row;
		}

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Karyawan_m->count_all_tabs_facerecognition($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_facerecognition, $id_karyawan),
							"recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_facerecognition($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_facerecognition, $id_karyawan),
							"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function data_tabs_camera($jenis=null, $id_cabang="-", $id_departemen="-", $id_jabatan="-", $camera="-",$id_karyawan="-"){
		$list = $this->Karyawan_m->get_datatables_tabs_camera($jenis, $id_cabang, $id_departemen, $id_jabatan, $camera, $id_karyawan);
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();

			$foto = $this->config->item('base_image').'imagebiodata?_t=photo&_d='.$field->foto;

			$row[] = $no;
			$row[] = '<img class="media-object avatar avatar-sm img-fit-cover" src="'.$foto.'" style="border-radius: 2;">';
			$row[] = '<a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" class="media border-0">'.$field->nama_lengkap.'</a>'.$field->nik;
			$row[] = $field->kode_cabang." - ".$field->nama_cabang;
			$row[] = $field->kode_departemen." - ".$field->nama_departemen;
			$row[] = $field->kode_jabatan." - ".$field->nama_jabatan;
			$row[] = ($field->kamera === "1")?'<div class="badge badge-primary">Absenku</div>':'<div class="badge badge-warning">HP</div>';

			if(in_array($this->session->userdata('level_user'), array("1"))) {
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="'.md5($field->id_karyawan).'"></i>
                                </a>';
			}else{
				$row[] = '  <a href="'.site_url('master/karyawan/detail/'.md5($field->id_karyawan)).'" title="Detail" class="text-primary">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
			}

			$data[] = $row;
		}

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Karyawan_m->count_all_tabs_camera($jenis, $id_cabang, $id_departemen, $id_jabatan, $camera, $id_karyawan),
							"recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_camera($jenis, $id_cabang, $id_departemen, $id_jabatan, $camera, $id_karyawan),
							"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function export_pdf($karyawan = ''){
        $data['data_diri']   = $this->db->select('*')->from('data_karyawan')->where('md5(id_karyawan)',$karyawan)->get()->row();
        $data['riwayat_pendidikan']   = $this->db->select('*')->from('riwayat_pendidikan')->where('md5(id_karyawan)',$karyawan)->order_by('tahun_lulus', 'DESC')->get()->result();
        $data['riwayat_pekerjaan']   = $this->db->select('*')->from('riwayat_pekerjaan')->where('md5(id_karyawan)',$karyawan)->order_by('tgl_keluar', 'DESC')->get()->result();
        $data['karir_pekerjaan']   = $this->db->select('*')->from('karir_pekerjaan')->where('md5(id_karyawan)',$karyawan)->order_by('tgl_mulai', 'DESC')->get()->result();
        $data['data_sertifikat']   = $this->db->select('*')->from('data_sertifikat')->where('md5(id_karyawan)',$karyawan)->order_by('tgl_berakhir', 'DESC')->get()->result();
        $data['data_keluarga']   = $this->db->query("SELECT * FROM data_keluarga WHERE id_karyawan = '$karyawan' ORDER BY (
												CASE hub_keluarga

												WHEN 'Ayah'
												THEN 1

												WHEN 'Ibu'
												THEN 2

												WHEN 'Suami'
												THEN 3

												WHEN 'Istri'
												THEN 4

												WHEN 'Anak'
												THEN 5

												WHEN 'Saudara Kandung'
												THEN 6

												END
							) ASC")->result();

        // $this->logger->create_log('export_karyawan', 'export', $this->db->last_query());
        $html = $this->load->view('karyawan/cetak_karyawan', $data, true);
        $html = preg_replace('/>\s+</', '><', $html); //bug dompdf
        $this->load->add_package_path(APPPATH . 'third_party/dompdf/');
        require_once(APPPATH . "third_party/dompdf/dompdf_config.inc.php");
        $name = "Data_karyawan.pdf";
        $dompdf = new DOMPDF();
        $dompdf->set_paper('A4', 'potrait');
        $dompdf->load_html($html);
        $dompdf->render();
        $dompdf->stream($name, array("Attachment" => false));
        echo $html;
    }

    public function view_pdf($karyawan = ''){
        $data['data_diri']   = $this->db->select('*')->from('data_karyawan')->where('md5(id_karyawan)',$karyawan)->get()->row();
        $data['riwayat_pendidikan']   = $this->db->select('*')->from('riwayat_pendidikan')->where('md5(id_karyawan)',$karyawan)->order_by('tahun_keluar', 'DESC')->get()->result();
        $data['riwayat_pekerjaan']   = $this->db->select('*')->from('riwayat_pekerjaan')->where('md5(id_karyawan)',$karyawan)->order_by('tgl_keluar', 'DESC')->get()->result();
        $data['karir_pekerjaan']   = $this->db->select('*')->from('karir_pekerjaan')->where('md5(id_karyawan)',$karyawan)->order_by('tgl_mulai', 'DESC')->get()->result();
        $data['data_sertifikat']   = $this->db->select('*')->from('data_sertifikat')->where('md5(id_karyawan)',$karyawan)->order_by('tgl_berakhir', 'DESC')->get()->result();
        $data['data_keluarga']   = $this->db->query("SELECT * FROM data_keluarga WHERE md5(id_karyawan) = '$karyawan' ORDER BY (
												CASE hub_keluarga

												WHEN 'Ayah'
												THEN 1

												WHEN 'Ibu'
												THEN 2

												WHEN 'Suami'
												THEN 3

												WHEN 'Istri'
												THEN 4

												WHEN 'Anak'
												THEN 5

												WHEN 'Saudara Kandung'
												THEN 6

												END
							) ASC")->result();
        $this->load->view('karyawan/cetak_karyawan', $data, false);
    }

	public function delete(){
		$id_karyawan = $this->fungsi->decrypt_idkaryawan($this->input->post('id_karyawan'));

		$cek_jabatan = $this->db->query("SELECT id_jabatan FROM data_karyawan WHERE id_company = '".$this->id_company."' AND id_karyawan = '".$id_karyawan."'")->row()->id_jabatan;

		$cek_level_user = $this->db->query("SELECT level_user FROM master_jabatan WHERE id_company = '".$this->id_company."' AND id_jabatan = '".$cek_jabatan."' ")->row()->level_user;

		if ($cek_level_user == 1 && $id_karyawan == $this->id_karyawan) {
			$message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data user ini sedang anda gunakan untuk login</font>';
			return __response_save(false, array('message' => $message));
		}else{
			$this->Karyawan_m->delete($id_karyawan);
		}
    }

	public function download($jenis=0, $id_cabang=0, $id_departemen=0, $id_jabatan=0, $status=0, $id_karyawan=0){
		if($id_karyawan != "0") {
			$nama = $this->_nama_karyawan($id_karyawan);
			$filename = "Data Karyawan" . $nama;
		} else {
			if($id_cabang == "0"){
				$filename = "Data Karyawan Semua Cabang";
			}else{
				if($id_departemen != "0") {
					$nama_cab 	  = $this->_nama_cabang($id_cabang);
					$nama_dep 	  = $this->_nama_departemen($id_departemen);
					$nama 		  = " Cabang " . $nama_cab . ", Departemen " . $nama_dep;
					$filename 	  = "Data Karyawan " . $nama;
				}else {
					$nama_cab 	  = $this->_nama_cabang($id_cabang);
					$filename = "Data Karyawan Cabang " . $nama_cab . " Semua Departemen";
				}
			}
		}

		$data['nama'] = $nama;
		$data['jenis']	= $jenis;
		$data['title']	= $filename;

		$data['data'] = $this->Karyawan_m->get_datatables_tabs_jabatan($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $id_karyawan, $order_by = "custom");

		$output = true;

		$data['is_excel'] = true;
		$sb_view = $this->load->view('karyawan/download/status', $data, $output);
		// echo $sb_view;
		// die();

		$param = [
			'download' => true,
			'cLength'    => 18,
			'file_name'    => strtoupper($filename),
			'paper_size'	=> 'LEGAL',
			'font-size'		=> 9,
			'pagebreak'		=> true,
			'page_margin'	=> ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
			'orientation'	=> 'landscape',
			'freezecolumn'	=> ['D5'],
			'header'    => [
				'1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
				'3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold']
			],
			'thead'        => ['4'],
			'tbody'        => [
				'start' => '4',
				'height'	=> 13,
				'wrap' => ['B','C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P','Q','R','S'],
				'column' => [
					'A'    => ['width' => 7, 'align' => 'center', 'valign' => 'middle'],
					'B'    => ['width' => 15, 'align' => 'center', 'valign' => 'middle', 'format'=>'text'],
					'C'    => ['width' => 25, 'align' => 'left', 'valign' => 'middle'],
					'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
					'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
					'E'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
					'F'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
					'G'    => ['width' => 16, 'align' => 'center', 'valign' => 'top'],
					'H'    => ['width' => 15, 'align' => 'center', 'valign' => 'top'],
					'I'    => ['width' => 18, 'align' => 'center', 'valign' => 'top'],
					'J'    => ['width' => 20, 'align' => 'center', 'valign' => 'top'],
					'K'    => ['width' => 18, 'align' => 'center', 'valign' => 'top'],
					'L'    => ['width' => 18, 'align' => 'center', 'valign' => 'top'],
					'M'    => ['width' => 12, 'align' => 'center', 'valign' => 'top'],
					'N'    => ['width' => 10, 'align' => 'center', 'valign' => 'top'],
					'O'    => ['width' => 15, 'align' => 'left', 'valign' => 'top'],
					'P'    => ['width' => 15, 'align' => 'center', 'valign' => 'top'],
					'Q'    => ['width' => 50, 'align' => 'left', 'valign' => 'top'],
					'R'    => ['width' => 13, 'align' => 'center', 'valign' => 'top', 'format'=>'text'],
					'S'    => ['width' => 30, 'align' => 'left', 'valign' => 'top'],
				],
			],
		];

		if ($output) {
			$this->load->library('PHPExcel/Excel');
			$this->excel->generateExcel($sb_view, $param);
		}
	}

	private function _nama_karyawan($id_karyawan = null){
		$this->db->select("nama_lengkap");
		$this->db->where("id_karyawan",$id_karyawan);
		$this->db->where("id_company",$this->id_company);
		$this->db->from("data_karyawan");
		$query = $this->db->get()->row();

		return $query->nama_lengkap;
	}

	private function _nama_cabang($id_cabang = null){
		$this->db->select("nama");
		$this->db->where("id_cabang",$id_cabang);
		$this->db->where("id_company",$this->id_company);
		$this->db->from("master_cabang");
		$query = $this->db->get()->row();

		return $query->nama;
	}

	private function _nama_departemen($id_departemen = null){
		$this->db->select("nama");
		$this->db->where("id_departemen",$id_departemen);
		$this->db->where("id_company",$this->id_company);
		$this->db->from("master_departemen");
		$query = $this->db->get()->row();

		return $query->nama;
	}

}
