<style>
    .border-dashed {
        border-style: dashed !important;
    }

    .input_isi_tahapan{
        width: 50%;
        background-color: transparent;
        border: none;
        border-bottom: 1px solid #000;
        padding: 5px 0;
        outline: none;
    }

    /* Start Css Colorpicker */
    .colorpicker {
        padding: 0;
        border: none;
    }

    .colorpicker::-webkit-color-swatch-wrapper {
        padding: 0;
    }

    .colorpicker::-webkit-color-swatch {
        border: none;
    }
</style>

<script type="text/javascript">
    $(function() {
        active_stage_only_1();
        var oldContent = $('.ul-list-tahapan').html();

        // action orderring active stage
        $(".ul-list-tahapan").sortable({
            cursor: "move",
            cancel: ".non-sortable, input, .input_isi_tahapan",
            update: function(event, ui) {
                var order = [];
                var tahapan = $(".ul-list-tahapan .sortable-item-tahapan");
                var array_tahapan = [];
                for (let i = 0; i < tahapan.length; i++) {
                    array_tahapan.push({id : tahapan[i].getAttribute('data-id'),
                                        no_urut: i+2 });
                }

                var param              = {};
                param.array_tahapan  = array_tahapan;

                $.ajax({
                    type: 'POST',
                    url: "<?= route('sales_activity.master.tahapan.order') ?>",
                    data: param,
                    dataType: 'JSON',
                    success: function(result) {
                        if (result.success == true) {
                            showMsg(result.message);
                        }
                    },
                    error: function() {
                        $('.ul-list-tahapan').html(oldContent);
                        showMsg("<?= $this->lang->line('error') ?>");
                    }
                });        
            }
        });
    });
</script>

<!-- START LIST COLOR -->
<datalist id="colors">
  <option value="#d9d9d9">
  <option value="#acb9ca">
  <option value="#f8cbad">
  <option value="#ffe699">
  <option value="#c6e0b4">

  <option value="#bfbfbf">
  <option value="#8ea9db">
  <option value="#f4b084">
  <option value="#ffd966">
  <option value="#a9d08e">

  <option value="#a6a6a6">
  <option value="#305496">
  <option value="#c65911">
  <option value="#bf8f00">
  <option value="#548235">
</datalist>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Master <?= $this->lang->line('tahapan_penjualan') ?></h5>
    </div>
</div>

<hr>

<div class="m_tahapan_penjualan">
    <?php
        $incoming = $data['incoming'];
        $activity = $data['activity'];
        $wont     = $data['wont'];
        $lost     = $data['lost'];
    ?>
    
    <!-- INCOMING LEAD STAGE -->
    <div id="div_incoming_lead_stage">
        <!-- Title -->
        <div class="div_judul_tahapan">
            <label class="font-weight-bold"><?= $this->lang->line('title_incoming_lead') ?></label><BR>
            <span><?= $this->lang->line('desc_incoming_lead') ?></span>
        </div>
        <!-- List -->
        <div class="div_list_tahapan mt-1">
            <div class="d-inline-flex justify-content-between w-100">
                <div class="div_left_tahapan pt-0 pb-1 w-100">
                    <div class="d-flex justify-content-between align-items-center rounded pb-1" 
                        style="background-color: <?= $incoming['warna'] ?>; color: <?= $incoming['warna_text'] ?>">
                            <div class="font-weight-bold mt-1 ml-1" style="width: 100%;">
                                <span id="span_isi_tahapan"><?= $incoming['nama'] ?></span>
                                <input type="text" id="input_isi_tahapan" class="input_isi_tahapan" 
                                    value="<?= htmlspecialchars($incoming['nama']) ?>" 
                                    style="display:none; color: <?= $incoming['warna_text'] ?>; border-color: <?= $incoming['warna_text'] ?>">
                            </div>
                    </div>
                </div>
                <div class="div_right_tahapan p-0 pb-1 px-1 d-flex align-items-center justify-content-end" style="font-size: 12px;">
                    <a id="btn_edit" class="btn_edit_tahapan text-nowrap text-secondary font-weight-bold" data-stage="incoming_close">
                        <i  class="fa fa-edit (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_perbarui'))) ?>
                    </a>
                    <a id="btn_warna" class="text-secondary text-nowrap font-weight-bold mr-3" style="display:none">
                        <input id="head_colorpicker" type="color" class="colorpicker align-middle" name="name_colorpicker" list="colors" style="width:13px; height:13px;" onchange="set_color(this)" value="<?= $incoming['warna'] ?>" data-prev-color="<?= $incoming['warna'] ?>">
                        <?= $this->lang->line('warna') ?>
                    </a>
                    <a id="btn_batal" class="text-warning text-nowrap font-weight-bold mr-3" data-stage="incoming_close" data-action-crud="EDIT" style="display:none">
                        <i  class="fa fa-close (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_batal'))) ?>
                    </a>
                    <a id="btn_simpan" class="text-primary text-nowrap font-weight-bold" data-stage="incoming_close" data-action-crud="EDIT" style="display:none"
                        data-id_tahapan_m="<?= MD5($incoming['id_tahapan_m']) ?>">
                                <i  class="fa fa-save (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_simpan'))) ?>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- ACTIVE STAGE -->
    <div id="div_active_stage" class="mt-3">
        <!-- Title -->
        <div class="div_judul_tahapan">
            <label class="font-weight-bold"><?= $this->lang->line('title_active_stage') ?></label><BR>
            <span><?= $this->lang->line('desc_active_stage') ?></span>
        </div>
        <!-- List -->
        <ul class="ul-list-tahapan mt-1" style="list-style-type: none; padding-left: 0;">
            <?php
                foreach($activity AS $value){
                    if($value['status_hapus'] == "TIDAK"){
                        $non_sortable = "non-sortable";
                        $style_cursor_move = "not-allowed";
                    }else{
                        $non_sortable = "";
                        $style_cursor_move = "move";
                    }
            ?>
                        <li class="sortable-item-tahapan <?= $non_sortable ?>" data-id="<?= $value['id_tahapan_m'] ?>">
                            <div class="div_list_tahapan">
                                <div class="d-inline-flex justify-content-between w-100">
                                    <div class="div_left_tahapan pt-0 pb-1 w-100">
                                        <div class="d-flex justify-content-between align-items-center rounded pb-1" 
                                            style="background-color: <?= $value['warna'] ?>; 
                                                color: <?= $value['warna_text'] ?>;
                                                cursor: <?= $style_cursor_move ?>;"
                                        >
                                                <div class="font-weight-bold mt-1 ml-1" style="width: 100%;">
                                                    <i class="fa fa-sort mr-2"></i>
                                                    <span id="span_isi_tahapan"><?= $value['nama'] ?></span>
                                                    <input type="text" id="input_isi_tahapan" class="input_isi_tahapan" 
                                                        value="<?= htmlspecialchars($value['nama']) ?>" 
                                                        style="display:none; color: <?= $value['warna_text'] ?>; border-color: <?= $value['warna_text'] ?>">
                                                </div>
                                        </div>
                                    </div>
                                    <div class="div_right_tahapan p-0 pb-1 px-1 d-flex align-items-center justify-content-end" style="font-size: 12px;">
                                        <a id="btn_delete" class="btn_delete_tahapan text-nowrap text-danger font-weight-bold mr-3" data-stage="active"
                                            data-id_tahapan_m="<?= MD5($value['id_tahapan_m']) ?>"
                                            data-status_hapus="<?= $value['status_hapus'] ?>"
                                        >
                                                    <i  class="fa fa-trash (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_hapus'))) ?>
                                        </a>
                                        <a id="btn_edit" class="btn_edit_tahapan text-nowrap text-secondary font-weight-bold" data-stage="active">
                                            <i  class="fa fa-edit (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_perbarui'))) ?>
                                        </a>
                                        <a id="btn_warna" class="text-secondary text-nowrap font-weight-bold mr-3" style="display:none">
                                            <input id="head_colorpicker" type="color" class="colorpicker align-middle" name="name_colorpicker" list="colors" style="width:13px; height:13px;" onchange="set_color(this)" value="<?= $value['warna'] ?>" data-prev-color="<?= $value['warna'] ?>">
                                            <?= $this->lang->line('warna') ?>
                                        </a>
                                        <a id="btn_batal" class="text-danger text-nowrap font-weight-bold mr-3" data-stage="active" data-action-crud="EDIT" style="display:none">
                                            <i  class="fa fa-close (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_batal'))) ?>
                                        </a>
                                        <a id="btn_simpan" class="text-primary text-nowrap font-weight-bold" data-stage="active" data-action-crud="EDIT" style="display:none"
                                            data-id_tahapan_m="<?= MD5($value['id_tahapan_m']) ?>">
                                                    <i  class="fa fa-save (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_simpan'))) ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </li>
            <?php
                } 
            ?>
        </ul>

        <!-- TAMBAH TAHAPAN -->
        <div class="div_tambah_tahapan mt-2">
            <?php if(count($activity) >= 5){ ?>
                    <!-- kosong -->
            <?php }else{ ?>
                    <div id="btn_tambah" class="row row_tambah_tahapan btn_tambah_tahapan" style="cursor:pointer;">
                        <div class="col-md-12">
                            <div class="d-flex justify-content-center align-items-center rounded pb-1 border border-dashed text-center">
                                <a  class="text-secondary font-weight-bold mt-1">
                                    <i  class="fa fa-plus (alias)"></i> Stage Title
                                </a>
                            </div>
                        </div>
                    </div>
            <?php } ?>
        </div>
    </div>

    <!-- CLOSED STAGE -->    
    <div id="div_closed_stage" class="mt-3">
        <!-- Title -->
        <div class="div_judul_tahapan">
            <label class="font-weight-bold"><?= $this->lang->line('title_closed_stage') ?></label><BR>
            <span><?= $this->lang->line('desc_closed_stage') ?></span>
        </div>
        <!-- List Won -->
        <div class="div_list_tahapan mt-1">
            <div class="d-inline-flex justify-content-between w-100">
                <div class="div_left_tahapan pt-0 pb-1 w-100">
                    <div class="d-flex justify-content-between align-items-center rounded pb-1" 
                        style="background-color: <?= $wont['warna'] ?>; color: <?= $wont['warna_text'] ?>">
                            <div class="font-weight-bold mt-1 ml-1" style="width: 100%;">
                                <span id="span_isi_tahapan"><?= $wont['nama'] ?></span>
                                <input type="text" id="input_isi_tahapan" class="input_isi_tahapan" 
                                    value="<?= htmlspecialchars($wont['nama']) ?>" 
                                    style="display:none; color: <?= $wont['warna_text'] ?>; border-color: <?= $wont['warna_text'] ?>">
                            </div>
                    </div>
                </div>
                <div class="div_right_tahapan p-0 pb-1 px-1 d-flex align-items-center justify-content-end" style="font-size: 12px;">
                    <a id="btn_edit" class="btn_edit_tahapan text-nowrap text-secondary font-weight-bold" data-stage="incoming_close">
                        <i  class="fa fa-edit (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_perbarui'))) ?>
                    </a>
                    <a id="btn_warna" class="text-secondary text-nowrap font-weight-bold mr-3" style="display:none">
                        <input id="head_colorpicker" type="color" class="colorpicker align-middle" name="name_colorpicker" list="colors" style="width:13px; height:13px;" onchange="set_color(this)" value="<?= $wont['warna'] ?>" data-prev-color="<?= $wont['warna'] ?>">
                        <?= $this->lang->line('warna') ?>
                    </a>
                    <a id="btn_batal" class="text-warning text-nowrap font-weight-bold mr-3" data-stage="incoming_close" data-action-crud="EDIT" style="display:none">
                        <i  class="fa fa-close (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_batal'))) ?>
                    </a>
                    <a id="btn_simpan" class="text-primary text-nowrap font-weight-bold" data-stage="incoming_close" data-action-crud="EDIT" style="display:none"
                        data-id_tahapan_m="<?= MD5($wont['id_tahapan_m']) ?>">
                                <i  class="fa fa-save (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_simpan'))) ?>
                    </a>
                </div>
            </div>
        </div>
        <!-- List Failed -->
        <div class="div_list_tahapan mt-1">
            <div class="d-inline-flex justify-content-between w-100">
                <div class="div_left_tahapan pt-0 pb-1 w-100">
                    <div class="d-flex justify-content-between align-items-center rounded pb-1" 
                        style="background-color: <?= $lost['warna'] ?>; color: <?= $lost['warna_text'] ?>">
                            <div class="font-weight-bold mt-1 ml-1" style="width: 100%;">
                                <span id="span_isi_tahapan"><?= $lost['nama'] ?></span>
                                <input type="text" id="input_isi_tahapan" class="input_isi_tahapan" 
                                    value="<?= htmlspecialchars($lost['nama']) ?>" 
                                    style="display:none; color: <?= $lost['warna_text'] ?>; border-color: <?= $lost['warna_text'] ?>">
                            </div>
                    </div>
                </div>
                <div class="div_right_tahapan p-0 pb-1 px-1 d-flex align-items-center justify-content-end" style="font-size: 12px;">
                    <a id="btn_edit" class="btn_edit_tahapan text-nowrap text-secondary font-weight-bold" data-stage="incoming_close">
                        <i  class="fa fa-edit (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_perbarui'))) ?>
                    </a>
                    <a id="btn_warna" class="text-secondary text-nowrap font-weight-bold mr-3" style="display:none">
                        <input id="head_colorpicker" type="color" class="colorpicker align-middle" name="name_colorpicker" list="colors" style="width:13px; height:13px;" onchange="set_color(this)" value="<?= $lost['warna'] ?>" data-prev-color="<?= $lost['warna'] ?>">
                        <?= $this->lang->line('warna') ?>
                    </a>
                    <a id="btn_batal" class="text-warning text-nowrap font-weight-bold mr-3" data-stage="incoming_close" data-action-crud="EDIT" style="display:none">
                        <i  class="fa fa-close (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_batal'))) ?>
                    </a>
                    <a id="btn_simpan" class="text-primary text-nowrap font-weight-bold" data-stage="incoming_close" data-action-crud="EDIT" style="display:none"
                        data-id_tahapan_m="<?= MD5($lost['id_tahapan_m']) ?>">
                                <i  class="fa fa-save (alias)"></i> <?= ucwords(strtolower($this->lang->line('button_form_simpan'))) ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_hapus" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content">
            <input type="hidden" id="id_tahapan_m">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-body p-1">
                <div class="warning_hapus form-group">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- <div id="div_status_hapus_ya" class="alert alert-warning" style="display:none;">
                                <strong>Warning!</strong> jika Anda menghapus data ini maka data tahapan pada kanban juga akan ikut <strong>terhapus</strong>.
                            </div> -->
                            <div id="div_status_hapus_tidak" class="alert alert-warning" style="display:none;">
                                <strong>Warning!</strong> tidak dapat menghapus data karena terdapat kanban yang menggunakan tahapan ini pada bulan berjalan.
                            </div>
                        </div>
                    </div>  
                </div>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_hapus ladda-button" id="btn_hapus" data-style="expand-left"><?= $this->lang->line('button_form_hapus') ?></button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
