<?= $tab ?><br>
<div class="row">
    <div class="col-md-12 table-responsive">
        <table id="list_data" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center">NO</th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('jenis_pengajuan') ?></th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('nama_perusahaan') ?></th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('jenis_perusahaan') ?></th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('jabatan_terakhir') ?></th>
                    <th class="text-left text-uppercase"><?= $this->lang->line('keterangan_revisi') ?></th>
                    <th class="text-center"><?= $this->lang->line('aksi') ?></th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<script type="text/javascript">
    var table = $('#list_data').DataTable({
        'searching': true,
        'paging': true,
        'lengthChange': true,
        'ordering': true,
        'info': true,
        'scrollX': true,
        // 'scrollCollapse': true,
        // 'fixedColumns': true,

        <?php if ($this->code_lang == 'id') {
            echo "
                'language': {
                    'url': '" . base_url("assets/plugins/datatables/dataTables-language-id.json") . "',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan'
                },";
        }; ?> "processing": true,
        "serverSide": true,
        "order": [],

        "ajax": {
            "url": "<?= route('master.karyawan.pengalamankerja.pengajuan.list-data') . '/' . $id_karyawan_md5 ?>",
            "type": "GET",
            "data": function(d) {
                delete d.columns;
            },
            "complete": function(data) {
                reconfigure(data);
            }
        },

        "aoColumnDefs": [{
                "aTargets": [0],
                "bSortable": false
            },
            {
                "aTargets": [5, 6],
                "bSortable": false
            }
        ],
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            $('td:eq(0)', nRow).css({
                'text-align': 'center'
            });
            $('td:eq(5)', nRow).css({
                'text-align': 'center'
            });
            $('td:eq(6)', nRow).css({
                'text-align': 'center'
            });

            $('td:eq(0)', nRow).css({
                'width': '10px'
            });
            $('td:eq(6)', nRow).css({
                'width': '150px'
            });
        }

    });

    function form_revisi(id) {
        $('#tampil_form').load("<?= route('master.karyawan.pengalamankerja.pengajuan.form') ?>/revisi/" + id, function() {
            $('#modal_form').modal('show');
            $(".title").text("<?= strtoupper($this->lang->line('revisi')) ?>");
        });
    }

    function form_info(id) {
        $('#tampil_form').load("<?= route('master.karyawan.pengalamankerja.pengajuan.form') ?>/info/" + id, function() {
            $('#modal_form').modal('show');
            $(".title").text("INFO");
        });
    }

    function form_approve(id) {
        $('#tampil_form').load("<?= route('master.karyawan.pengalamankerja.pengajuan.form') ?>/approve/" + id, function() {
            $('#modal_form').modal('show');
            $(".title").text("<?= strtoupper($this->lang->line('title_form_approve_pengajuan')) ?>");
        });
    }

    function form_hapus(id) {
        $('#tampil_form').load("<?= route('master.karyawan.pengalamankerja.pengajuan.form') ?>/hapus/" + id, function() {
            $('#modal_form').modal('show');
            $("#form_input :input").prop("disabled", true);
            $(".title").text("<?= strtoupper($this->lang->line('title_form_hapus_data')) ?>");
        });
    }

    function hapus() {
        var l = Ladda.create(document.querySelector('#hapus'));
        l.start();
        $.get('<?= route("master.karyawan.pengalamankerja.pengajuan.hapus"); ?>', {
                id: $('#id').val()
            },
            function(result) {
                l.stop();
                if (result.success) {
                    $('.card-footer').hide();
                    $('.title').html(result.message);
                    $('.title font').attr('color', '#FFFFFF');
                    table.ajax.reload();
                } else {
                    $('#message_modal').html(result.message);
                }
            },
            'json');
    }

    function revisi() {
        var l = Ladda.create(document.querySelector('#revisi'));
        l.start();
        $.get('<?= route("master.karyawan.pengalamankerja.pengajuan.revisi"); ?>', {
                id: $('#id').val(),
                keterangan: $('#keterangan').val()
            },
            function(result) {
                l.stop();
                if (result.success) {
                    table.ajax.reload();
                    $('#revisi, #keterangan, #batal').prop('disabled', true);
                }
                $('#message_modal').html(result.message);
            },
            'json');
    }

    function approve() {
        var l = Ladda.create(document.querySelector('#approve'));
        l.start();
        $.get('<?= route("master.karyawan.pengalamankerja.pengajuan.approve"); ?>', {
                id: $('#id').val()
            },
            function(result) {
                l.stop();
                if (result.success) {
                    $('.card-footer').hide();
                    $('.title').html(result.message);
                    $('.title font').attr('color', '#FFFFFF');
                    table.ajax.reload();
                } else {
                    $('#message_modal').html(result.message);
                }
            },
            'json');
    }
</script>
