<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Adm_reimburse_m extends CI_Model {
    var $table = 'p_adm_reimbursement';

    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->db->select("par.id");
        $this->db->from($this->table." AS par");
        $this->db->where('par.id_company', $this->id_company);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("
            par.id,
            dk.id_karyawan,
            dk.nik,
            dk.nama_lengkap AS nm_karyawan,
            par.id_cabang"
        );
        $this->db->from($this->table." AS par");
        $this->db->join("data_karyawan AS dk", "dk.id_karyawan = par.id_karyawan");
        $this->db->where('par.id_company', $this->id_company);

        $column_search = array('dk.nik','dk.nama_lengkap');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode GET

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('', 'nm_karyawan');
        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            $order_by = array("par.tgl_input"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $this->db->select("par.id,
                            dk.id_karyawan,
                            dk.nik,
                            dk.nama_lengkap AS nm_karyawan,
                            par.id_cabang");
        $this->db->from($this->table." AS par");
        $this->db->join("data_karyawan AS dk", "dk.id_karyawan = par.id_karyawan");
        $this->db->where('par.id_company', $this->id_company);
        $query = $this->db->where('MD5(par.id)', $id)->get()->row();
        return $query;
    }

    public function getCabang(){
        $this->db->select("id_cabang,
                            kode AS kd_cabang,
                            nama AS nm_cabang");
        $this->db->from("master_cabang");
        $this->db->where("id_company", $this->id_company);

        $query = $this->db->get()->result();

        $cabang_arr = [];
        foreach($query as $row){
            $cabang_arr[$row->id_cabang] = array("id_cabang" => $row->id_cabang,
                                                    "nm_cabang" => $row->kd_cabang." - ".$row->nm_cabang);
        }

        return $cabang_arr;
    }

    public function save($data,$id = null){
        if($id != null){
            $data['user_update'] = $this->nik_karyawan." - ".$this->nm_karyawan;
            $data['tgl_update']  = date('Y-m-d h:i:s');

            $this->db->select();
            $this->db->from($this->table);
            $this->db->where("id_company", $this->id_company);
            $this->db->where("id_karyawan", $data['id_karyawan']);
            $this->db->where("MD5(id) !=", $id);
            $cek_karyawan = $this->db->get()->num_rows();

            if($cek_karyawan > 0){
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL: Karyawan sudah ada</font>');
                return __response_save(false,$message);
            }else{
                $this->db->where(array('md5(id)'=>$id, 'id_company'=>$this->id_company));
                $update = $this->db->update($this->table,$data);
                $this->logger->create_log('pengaturan_admin_reimbursement', 'edit', $this->db->last_query());
                return  __response_update($update);
            }

        }else{
            $data['user_input'] = $this->nik_karyawan." - ".$this->nm_karyawan;

            $this->db->select();
            $this->db->from($this->table);
            $this->db->where("id_company", $this->id_company);
            $this->db->where("id_karyawan", $data['id_karyawan']);
            $cek_karyawan = $this->db->get()->num_rows();

            if($cek_karyawan > 0){
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL: Karyawan sudah ada</font>');
                return __response_save(false,$message);
            }else{
                $nextId = $this->fungsi->getNextId($this->table,'id', $this->id_company,3);
                $id = array('id' => $nextId);
                $save = $this->db->insert($this->table, array_merge($data,$id));
                return __response_save($save);
            }
        }

    }

    public function delete($id=null){
        $this->db->where(array('md5(id)'=>$id, 'id_company'=>$this->id_company));
        $delete =$this->db->delete($this->table);
        $this->logger->create_log('pengaturan_admin_reimbursement', 'delete', $this->db->last_query());
        return  __response_delete($delete);
    }

}