<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Data_sertifikat_m extends CI_Model {
    var $table = 'data_sertifikat';

    public function getDataById($id_sertifikat=null){
        $select = $this->db->select("id_sertifikat,
                                    id_karyawan,
                                    nama_sertifikat,
                                    penyelenggara,
                                    tgl_berlaku,
                                    tgl_berakhir,
                                    deskripsi,
                                    file")
                            ->from($this->table)
                            ->where("MD5(id_sertifikat)",$id_sertifikat)
                            ->get()
                            ->row();
        return $select;
    }

    public function listData($id_karyawan=null){
        $select = $this->db->select("id_sertifikat,
                                    nama_sertifikat,
                                    penyelenggara,
                                    tgl_berlaku,
                                    tgl_berakhir,
                                    deskripsi,
                                    file")
                            ->from($this->table)
                            ->where("MD5(id_karyawan)",$id_karyawan)
                            ->get()
                            ->result();
        return $select;
    }

    public function save($data,$id_sertifikat = null){
        $id_company = $id_company;
        if($id_sertifikat != null){
            if($data['file'] == ""){
                $predir_file = $this->db->select("file")
                                        ->from($this->table)
                                        ->where("md5(id_sertifikat)",$id_sertifikat)
                                        ->where("id_company",$id_company)
                                        ->get()
                                        ->row("file");
            }
            $this->db->where('md5(id_sertifikat)',$id_sertifikat);
            $this->db->where('id_company',$id_company);
            $update = $this->db->update('data_sertifikat',$data);
            if($update){
                if($data['file'] == ""){
                    $this->fungsi->delete_fileupload($predir_file);
                }
                $new_params["new_params"] = ["sertifikat"=>$data["file"]];
                return __response_update(true,$new_params);
            }else{
                return __response_update(false);
            }
        }else{
            $nextId = $this->fungsi->getNextId('data_sertifikat','id_sertifikat',$id_company,4);
            $id_sertifikat = array('id_sertifikat' => $nextId);
            $save = $this->db->insert('data_sertifikat', array_merge($data, $id_sertifikat));
            return __response_save($save);
        }
        
    }

    public function delete($id_sertifikat=null){
        $id_company = $id_company;
        $predir_file = $this->db->select("file")
                                ->from($this->table)
                                ->where("md5(id_sertifikat)",$id_sertifikat)
                                ->where("id_company",$id_company)
                                ->get()
                                ->row("file");
                                
        $this->db->where('md5(id_sertifikat)',$id_sertifikat);
        $this->db->where('id_company',$id_company);
        $delete =$this->db->delete($this->table);
        if($delete){
            $this->fungsi->delete_fileupload($predir_file);
            return __response_delete(true);
        }else{
            return __response_delete(false);
        }
        
    }

}