<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Admin_sales extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/pengaturan/Admin_sales_m');
    }

    public function list_data(){
        $list = $this->Admin_sales_m->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap . "<br><b>" . $field->nik . "</b>";
            
            if(empty($field->id_group_m)){
                $row[] = "";
            }elseif($field->id_group_m == "all"){
                $row[] = "<B>SEMUA GROUP/AREA</B>";
            }else{
                $get_group = $this->Admin_sales_m->get_group($field->id_group_m);
                
                $no_group = 1;
                $string_group = "";
                foreach($get_group AS $group){
                    $string_group .= $no_group.". ". $group['nama_group']. "<BR>";
                    $no_group++;
                }

                $row[] = $string_group;
            }
            
            $btn_edit = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_karyawan) . '" class="btn_edit fa fa-edit (alias)" onclick="edit(this)"> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="' . $this->lang->line('hapus') . '"><i id="' . md5($field->id_karyawan) . '" class="btn_delete fa fa-trash" onclick="hapus_form(this)"></i></a>';
            $row[] = $btn_edit. '&nbsp'. $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Admin_sales_m->count_all(),
            "recordsFiltered" => $this->Admin_sales_m->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null){
        $data = [];
        if($id != null){
			$data['data'] = $this->Admin_sales_m->getDataById($id);

            $id_group_m = $data['data']->id_group_m;
            if($id_group_m == "all"){
                $data['group'][] = array(
                        "id_group_m" => "all",
                        "nama_group" => "Semua Group"
                    );
            }else{
                $data['group'] = $this->Admin_sales_m->get_group($id_group_m);
            }
		}

		$this->load->view('sales_activity/pengaturan/admin_sales/form',$data);
    }

    public function save(){
        $id           = $this->input->post('id');
        $id_group_arr = json_decode($this->input->post('id_group_m'));

        $data = array( 
            'id_karyawan'    => $this->input->post('id_karyawan'),
            'id_group_m'    => implode(',', $id_group_arr),
            'id_company'    => $this->id_company,
            'user_input'    => $this->nik_karyawan. ' - '. $this->nm_karyawan,
            'tgl_input'     => date("Y-m-d H:i:s")
        );
        
        $this->Admin_sales_m->save($data, $id);
    }

    public function delete(){
        $id = $this->input->post("id");
        $this->Admin_sales_m->delete($id);
    }
}