<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Predikat extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('kpi/admin/pengaturan/Predikat_m', 'model');
    }

    public function index()
    {   
        $this->model->check_data_predikat();
        $this->load->view('kpi/admin/pengaturan/predikat/home');
        $this->load->view('kpi/admin/pengaturan/predikat/js');
    }

    public function list_data()
    {
        $list = $this->model->get_datatables();
        
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->grade;
            $row[] = $field->batas_bawah;
            $row[] = $field->batas_atas;
            $row[] = $field->keterangan;

             $row[] = '<a href="javascript:void(0)" class="text-warning" title="EDIT">
                        <i id="' . md5($field->grade.$field->id_company) . '" class="btn_edit fa fa-edit (alias)" onclick="edit(this)"> </i></a>';

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all(),
            "recordsFiltered" => $this->model->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id)
    {
        $data['data'] = $this->model->getDataById($id);
        $this->load->view('kpi/admin/pengaturan/predikat/form', $data);
    }

    public function save()
    {
        $id          = $this->input->post('id_predikat');
        $batas_bawah = $this->input->post('batas_bawah');
        $batas_atas  = $this->input->post('batas_atas');
        
        // $check_data  = $this->_check_data($id, $batas_bawah, $batas_atas);
        // if($check_data == false){
        //     exit;
        // }

        $data = array(
            'batas_bawah' => $this->input->post('batas_bawah'),
            'batas_atas'  => $this->input->post('batas_atas'),
            'keterangan'  => $this->input->post('keterangan'),
            'tgl_update'  => date("Y-m-d H:i:s"),
            'user_update' => $this->nik_karyawan. " - ". $this->nm_karyawan
        );

        $this->model->save($data, $id);
    }

    // CEK VALIDASI
    private function _check_data($id="", $val_batas_bawah="0", $val_batas_atas="0"){
        // Find Input Grade
        $grade = $this->db->select("grade")
                            ->from("kpi_predikat_p")
                            ->where("id_company", $this->id_company)
                            ->where("MD5(CONCAT(grade,id_company))", $id)
                            ->get()
                            ->row()
                            ->grade;

        $next_grade = chr(ord($grade) + 1);
        $prev_grade = chr(ord($grade) - 1);

        // Get All Data Grade
        $query_grade_all = $this->db->select("
            grade,
            keterangan,
            batas_atas,
            batas_bawah
        ")
            ->from("kpi_predikat_p")
            ->where("id_company", $this->id_company)
            ->get()
            ->result();

        $data_grade = array();
        foreach($query_grade_all AS $value){
            $data_grade[$value->grade] = array(
                "keterangan"  => $value->keterangan,
                "batas_atas"  => $value->batas_atas,
                "batas_bawah" => $value->batas_bawah,
            );
        }
        

        // Batas Bawah > Batas Atas
        if($val_batas_bawah > $val_batas_atas){
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Batas bawah tidak boleh melebihi batas atas</font>');
            __response_update(false, $message);
            return false;
        }

        // Minimal Batas Bawah
        if($next_grade == "E"){
            if((float)$val_batas_bawah < 0){
                $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Batas bawah tidak boleh kurang dari 0</font>');
                __response_update(false, $message);
                return false;
            }
        }else{
            $batas_atas =  $data_grade[$next_grade]['batas_atas'];
            if((float)$val_batas_bawah <= (float)$batas_atas){
                $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Minimal batas bawah adalah '. $batas_atas.'</font>');
                __response_update(false, $message);
                return false;
            }
        }

        // Minimal Batas Bawah
        if($prev_grade == "@"){
            if((float)$val_batas_atas > 5){
                $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Maximal batas atas adalah 5</font>');
                __response_update(false, $message);
                return false;
            }
        }else{
            $batas_bawah =  $data_grade[$prev_grade]['batas_bawah'];
            if((float)$val_batas_atas >= (float)$batas_bawah){
                $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Maximal batas atas adalah '. $batas_bawah.'</font>');
                __response_update(false, $message);
                return false;
            }
        }

        return true;
    }
}