<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Total_karyawan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
    }

    public function ttlkaryawanByGenre($id_cabang = "all", $id_departemen = "all")
    {
        $this->db->select('dk.jenis_kelamin,
                            count(dk.id_karyawan) as ttl');
        $this->db->join("master_jabatan AS mj", "mj.id_company = dk.id_company AND mj.id_jabatan = dk.id_jabatan");
        $this->db->where('dk.id_company', $this->id_company);
        $this->db->where_in('dk.status', ['1', '2', '3', '4']);
        $this->db->where_not_in('mj.level_user', ['1', '6']);

        if ($id_cabang != "all") {
            $this->db->where('dk.id_cabang', $id_cabang);
        }

        if ($id_departemen != "all") {
            $this->db->where('dk.id_departemen', $id_departemen);
        }

        $this->db->group_by('dk.jenis_kelamin');
        $this->db->from('data_karyawan AS dk');

        $ttl_karyawan = $this->db->get()->result();
        $ttl_pria   = 0;
        $ttl_wanita = 0;
        $ttl_uknown = 0;

        foreach ($ttl_karyawan as $row) {
            if ($row->jenis_kelamin == 'L') {
                $ttl_pria = $row->ttl;
            } else if ($row->jenis_kelamin == 'P') {
                $ttl_wanita = $row->ttl;
            } else {
                $ttl_uknown = $row->ttl;
            }
        }

        $ttl_karyawan = $ttl_pria + $ttl_wanita + $ttl_uknown;
        $persentase_pria = round((($ttl_pria / $ttl_karyawan) * 100));
        $persentase_wanita = round((($ttl_wanita / $ttl_karyawan) * 100));
        $persentase_uknown = round((($ttl_uknown / $ttl_karyawan) * 100));

        $response = [
            "success" => true,
            "data" => [
                "ttl_pria"              => $ttl_pria . " " . $this->lang->line('orang'),
                "persentase_pria"       => "<b>" . $persentase_pria . " %</b> " . $this->lang->line('laki_laki'),
                "ttl_wanita"            => $ttl_wanita . " " . $this->lang->line('orang'),
                "persentase_wanita"     => "<b>" . $persentase_wanita . " %</b> " . $this->lang->line('perempuan'),
                "ttl_uknown"            => $ttl_uknown . " " . $this->lang->line('orang'),
                "persentase_uknown"     => "<b>" . $persentase_uknown . " %</b> " . $this->lang->line('belum_diatur'),
                "ttl_karyawan"          => $ttl_karyawan . " " . $this->lang->line('orang')
            ]
        ];

        echo json_encode($response);
    }

    public function dropdown_cabang()
    {

        $search = $this->input->get("q");

        $this->db->select('dk.id_cabang,
                            mc.kode as kd_cabang,
                            mc.nama as nm_cabang');
        $this->db->join('master_cabang mc', 'mc.id_cabang = dk.id_cabang');
        $this->db->where('dk.id_company', $this->id_company);
        $this->db->group_start();
        $this->db->like('mc.kode', $search);
        $this->db->or_like('mc.nama', $search);
        $this->db->group_end();
        $this->db->group_by('dk.id_cabang');
        $this->db->order_by('mc.kode', 'ASC');

        $result = $this->db->get('data_karyawan dk')->result();

        $json = [];
        foreach ($result as $row) {
            $json[] = [
                'id'     => $row->id_cabang,
                'text'  => $row->kd_cabang . " - " . $row->nm_cabang
            ];
        }
        echo json_encode($json);
    }

    public function dropdown_departemen($id_cabang = "all")
    {
        $search = $this->input->get("q");

        $this->db->select('dk.id_departemen,
                            md.kode as kd_departemen,
                            md.nama as nm_departemen');
        $this->db->join('master_departemen md', 'md.id_departemen = dk.id_departemen');
        $this->db->where('dk.id_company', $this->id_company);
        $this->db->where('dk.id_cabang', $id_cabang);
        $this->db->group_start();
        $this->db->like('md.kode', $search);
        $this->db->or_like('md.nama', $search);
        $this->db->group_end();
        $this->db->group_by('dk.id_departemen');
        $this->db->order_by('md.kode', 'ASC');

        $result = $this->db->get('data_karyawan dk')->result();

        $json = [];
        foreach ($result as $row) {
            $json[] = [
                'id'     => $row->id_departemen,
                'text'  => $row->kd_departemen . " - " . $row->nm_departemen
            ];
        }
        echo json_encode($json);
    }
}
