<script>
    if (location.href == "<?= route('payroll.master.lembur.pengaturan') ?>") window.location.replace("<?= route('payroll.master.lembur.home') ?>");
    $(function() {
        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function(e, settings, techNote, message) {
            if (confirm('Terjadi kesalahan saat memproses data, muat ulang halaman ?')) {
                window.location.reload();
            }
        }).DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            'stateSave': true,
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                'searchPlaceholder': 'Kode/Keterangan'
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route("payroll.master.lembur.data", ["tab" => "pengaturan"]) ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                "className": "text-left",
                "aTargets": [2]
            }, {
                "className": "text-center",
                "targets": "_all"
            }],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(3), td:eq(4)', nRow).css({
                    'text-align': 'center',
                    'width': '100px'
                })
            }
        });

        $("#tambah_data").on("click", function() {
            $("#tampil_form").load("<?= route("payroll.master.lembur.pengaturan.form", ['for' => 'tambah']) ?>", function() {
                $("#modal_form .modal-dialog").removeClass("modal-md");
                $("#modal_form .modal-dialog").addClass("modal-lg");
                $("#modal_form").modal("show");
                $(".title").text("Tambah Data Master Pengaturan Lembur");
                $("#btn_submit").html("<i class='fa fa-save'></i> SIMPAN");
                $("#btn_submit").addClass("btn_save btn btn-primary");
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click', '#pengaturan .btn_edit', function() {
            var id = $(this).attr("id");
            $("#tampil_form").load("<?= route('payroll.master.lembur.pengaturan.form', ['for' => 'edit', 'id' => '"+id+"']) ?>", function() {
                $("#modal_form .modal-dialog").removeClass("modal-md");
                $("#modal_form .modal-dialog").addClass("modal-lg");
                $("#modal_form").modal("show");
                $(".title").text("Edit Data Master Pengaturan Lembur");
                $("#btn_submit").html("<i class='fa fa-edit (alias)'></i> PERBARUI");
                $("#btn_submit").addClass("btn_update btn btn-warning");
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click', '#pengaturan .btn_delete', function() {
            var id = $(this).attr("id");
            $("#tampil_form").load("<?= route('payroll.master.lembur.pengaturan.form', ['for' => 'delete', 'id' => '"+id+"']) ?>", function() {
                $("#modal_form .modal-dialog").removeClass("modal-lg");
                $("#modal_form .modal-dialog").addClass("modal-md");
                $("#modal_form").modal("show");
                $("#form_input :input").prop("disabled", true);
                $(".title").text("Hapus Data Master Pengaturan Lembur");
                $("#btn_submit").html("<i class='fa fa-trash (alias)'></i> HAPUS");
                $("#btn_submit").addClass("btn_destroy btn btn-danger");
                $("#btn_new_input").hide();
            });
        });
    });
</script>
<div class="row align-items-center">
    <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
        <h3 class="content-header-title"><?= $judul ?></h3>
    </div>
    <div class="content-header-right text-right col-md-6 col-12 mb-md-0 mb-1">
        <button id="tambah_data" class="btn btn-biru text-white">
            <i class="fa fa-plus"></i> Tambah Data
        </button>
    </div>
</div>
<hr>
<div class="table-responsive">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th rowspan="2" class="text-center align-middle" width="20">NO</th>
                <th rowspan="2" class="text-center align-middle">KODE</th>
                <th rowspan="2" class="text-center align-middle">KETERANGAN</th>
                <th colspan="2" class="text-center align-middle">DIIKUTSERTAKAN HITUNGAN</th>
                <th rowspan="2" class="text-center align-middle" width="50">AKSI</th>
            </tr>
            <tr>
                <th class="text-center align-middle">PPH21</th>
                <th class="text-center align-middle">POT. ABSENSI</th>
            </tr>
        </thead>
        <tbody id="pengaturan">
        </tbody>
    </table>
</div>
