<script type="text/javascript">
    $(document).ready(function() {
        // START INFORMASI PENDIDIKAN
        list_data();

        // Modal Tambah
        $('.btn_tambah_pendidikan').click(function() {
            $('#tampil_form').load("<?= site_url('master/karyawan/riwayat-pendidikan/form/tambah/' . $id) ?>", function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
                $(".btn_save_pendidikan").addClass("btn_save_pendidikan btn btn-primary");
                $(".btn_save_pendidikan").append('<i class="fa fa-save"></i> ');
                $(".btn_save_pendidikan").append('<?= $this->lang->line('button_form_simpan') ?>');
                $("#btn_new_input").hide();

                simpan_data();
            });
        });

    });

    function list_data() {
        $("#list_data").load("<?= site_url('master/karyawan/riwayat-pendidikan/data/' . $id) ?>", function() {

            // Modal Edit Pendidikan
            $('.btn_edit_pendidikan').click(function() {
                var id_pendidikan = $(this).attr('id');
                $('#tampil_form').load("<?= site_url('master/karyawan/riwayat-pendidikan/form/edit/' . $id . '/') ?>" + $(this).attr('id'), function() {
                    $('#modal_form').modal('show');
                    $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
                    $(".btn_save_pendidikan").addClass("btn_save_pendidikan btn btn-warning");
                    $(".btn_save_pendidikan").append('<i class="fa fa-edit (alias)"></i> ');
                    $(".btn_save_pendidikan").append('<?= $this->lang->line('button_form_perbarui') ?>');
                    $("#btn_new_input").hide();

                    simpan_data();
                });
            });

            // Modal Hapus Pendidikan
            $('.btn_delete_pendidikan').click(function() {
                $('#tampil_form').load("<?php echo site_url('master/karyawan/riwayat-pendidikan/form/delete/' . $id . '/') ?>" + $(this).attr('id'), function() {
                    $('#modal_form').modal('show');
                    $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
                    $('#form_input input[type=file]').prop("disabled", true);
                    $('#form_input input[type=text]').prop("disabled", true);
                    $('#form_input input[type=date]').prop("disabled", true);
                    $('#jenjang, #lulusan_asal').prop("disabled", true);
                    $(".btn_save_pendidikan").append('<i class="fa fa-trash"></i> ');
                    $(".btn_save_pendidikan").append('<?= $this->lang->line('button_form_hapus') ?>');
                    $(".btn_save_pendidikan").removeClass("btn_save_pendidikan").addClass("btn_hapus_pendidikan btn btn-danger");
                    $("#btn_new_input").hide();

                    hapus_data();
                });
            });

            $('#btn_new_input').click(function() {
                var transkrip = $('#form_input #transkrip').dropify();
                transkrip = transkrip.data('dropify');
                transkrip.resetPreview();
                transkrip.clearElement();

                var ijazah = $('#form_input #ijazah').dropify();
                ijazah = ijazah.data('dropify');
                ijazah.resetPreview();
                ijazah.clearElement();

                $('#form_input input[type=file]').prop("disabled", false);
                $("#form_input input[type=file]").val('');

                $('#form_input input[type=text]').prop("disabled", false);
                $("#form_input input[type=text]").val('');

                $('#form_input select').prop("disabled", false);
                $('#form_input select').prop('selectedIndex', 0);



                $('.btn_save_pendidikan').show();
                $('#btn_new_input').hide();
                $('#message').hide();
            });
        });
    }

    function simpan_data() {
        // Button Save Pendidikan
        $('.btn_save_pendidikan').click(function(e) {
            // $(document).on('click','.btn_save_pendidikan',function(e){
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            if ($("#jenjang").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jenjang_pendidikan') ?></font>");
                $('#jenjang').focus();
                return false;
            } else if ($("#nama_sekolah").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_sekolah') ?></font>");
                $("#nama_sekolah").focus();
                return false;
            } else if ($("#lulusan_asal").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_lulusan_asal') ?></font>");
                $('#lulusan_asal').focus();
                return false;
            } else if ($("#tahun_masuk").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tahun_masuk') ?></font>");
                $('#tahun_masuk').focus();
                return false;
            } else if ($("#tahun_lulus").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tahun_keluar') ?></font>");
                $('#tahun_lulus').focus();
                return false;
            }

            loading.start();

            var param = new FormData();
            param.append('nama_sekolah', $("#nama_sekolah").val());
            param.append('jenjang', $("#jenjang").val());
            param.append('jurusan', $("#jurusan").val());
            param.append('lulusan_asal', $("#lulusan_asal").val());
            param.append('gelar', $("#gelar").val());
            param.append('tahun_masuk', $("#tahun_masuk").val());
            param.append('tahun_lulus', $("#tahun_lulus").val());
            param.append('ijazah', $('#ijazah').prop('files')[0]);
            param.append('transkrip', $('#transkrip').prop('files')[0]);
            param.append('ijazah_lama', $("#ijazah_lama").val());
            param.append('transkrip_lama', $("#transkrip_lama").val());
            param.append('id_pendidikan', $("#id_pendidikan").val());
            param.append('id_karyawan', $("#id_karyawan").val());

            $.ajax({
                type: 'POST',
                url: "<?= site_url('master/karyawan/riwayat-pendidikan/save') ?>",
                data: param,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                cache: false,
                success: function(result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            $("#form_input :input").prop("disabled", true);
                            $('#form_input input[type=file]').prop("disabled", true);
                            $('.btn_save_pendidikan').hide();
                            $('#btn_new_input').show();
                        } else {
                            $("#form_input #ijazah_lama").val(result.ijazah);
                            $("#form_input #transkrip_lama").val(result.transkrip);
                        }
                        list_data();
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });
    }

    function hapus_data() {
        $('.btn_hapus_pendidikan').click(function() {
            var loading = Ladda.create(this);
            loading.start();
            $.ajax({
                type: 'POST',
                url: "<?php echo site_url('master/karyawan/riwayat-pendidikan/delete') ?>",
                data: 'id_riwayat_pendidikan=' + $("#id_pendidikan").val(),
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        list_data();
                    }
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message.replace("009900", "FFFFFF"));
                },
                error: function() {
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });
    }
</script>
<?php if ($this->session->userdata('level_user') == 1) {
    echo $tab . "<br>";
} ?>
<div class="row">
    <div class="col-md-12 text-right">
        <button type="button" class="btn_tambah_pendidikan btn btn-biru btn-min-width mb-1" id="tambah_pendidikan">
            <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_riwayat_pendidikan') ?>
        </button>
    </div>
</div>

<div class="row">
    <div id="list_data" class="col-md-12"></div>
</div>
