<div class="table-responsive">
    <div id="checkbox-filter" style="display: none;">
        <label class="mr-2 mb-0 ml-3">
            <input type="checkbox" class="jenis-filter" name="jenis[]" value="nasional" checked> <?= $this->lang->line('libur_nasional') ?>
        </label>
        <label class="mb-0">
            <input type="checkbox" class="jenis-filter" name="jenis[]" value="khusus" checked> <?= $this->lang->line('libur_khusus') ?>
        </label>
    </div>
    <table id="list_data" class="table table-striped" style="width:100%">
        <thead>
            <tr>
                <th class="text-center">NO</th>
                <th class="text-left"><?= strtoupper($this->lang->line('tgl')); ?></th>
                <th class="text-left"><?= strtoupper($this->lang->line('keterangan')); ?></th>
                <th class="text-center"><?= strtoupper($this->lang->line('jenis')); ?></th>
                <?php
                if (in_array($this->session->userdata('level_user'), array("1"))) {
                ?>
                    <th class="text-center"><?= $this->lang->line('aksi'); ?></th>
                <?php
                }
                ?>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({
            'searching': true,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Keterangan'
                <?php else : ?> 'searchPlaceholder': 'Description'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= site_url('pengaturan/hari-libur/list_data') ?>",
                "type": "GET",
                "data": function(d) {
                    d.jenis = [];
                    $('.jenis-filter:checked').each(function() {
                        d.jenis.push($(this).val());
                    });
                },
                "complete": function(data) {
                    reconfigure(data);
                },
            },

            "aoColumnDefs": [{
                    "aTargets": [0],
                    "bSortable": false
                }
                <?php
                if (in_array($this->session->userdata('level_user'), array("1"))) {
                ?>, {
                        "aTargets": [-1],
                        "bSortable": false
                    }

                <?php } ?>
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });

                <?php
                if (in_array($this->session->userdata('level_user'), array("1"))) {
                ?>

                    $('td:eq(3)', nRow).css({
                        'text-align': 'center',
                        'width': '150px'
                    });
                    
                    $('td:eq(-1)', nRow).css({
                        'text-align': 'center',
                        'width': '50px'
                    });

                <?php } ?>
            },

            initComplete: function () {
                // Pindahkan checkbox ke sebelah label "Tampilkan"
                $('#list_data_length').append($('#checkbox-filter').children());

                function manageCheckboxState() {
                    var checkedCheckboxes = $('.jenis-filter:checked');

                    $('.jenis-filter').prop('disabled', false);

                    if (checkedCheckboxes.length === 1) {
                        checkedCheckboxes.prop('disabled', true);
                    }
                }

                // Aktifkan handler checkbox
                $('.jenis-filter').on('change', function () {
                    manageCheckboxState();
                    list_data.ajax.reload();
                });

                // Reload ulang agar filter sudah aktif
                // list_data.ajax.reload();
            }
        });

    });
</script>
