<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Master_lembur_karyawan_m extends CI_Model
{
    protected $table = 'payroll_lembur_m';

    function get_datatables($params)
    {
        $this->_get_datatables_query($params);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($params)
    {
        $this->_get_datatables_query($params);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($params)
    {
        $this->_get_datatables_query($params);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($params)
    {
        $param = explode('.', $params);
        if ($param[0] != 'all') {
            if ($param[0] != '0') {
                $this->db->where('lm.lembur_hari_kerja != ""');
            } else {
                $this->db->group_start();
                $this->db->where('lm.lembur_hari_kerja', '');
                $this->db->or_where('lm.lembur_hari_kerja', null);
                $this->db->group_end();
            }
            if ($param[1] != '0') {
                $this->db->where('lm.lembur_libur_off != ""');
            } else {
                $this->db->group_start();
                $this->db->where('lm.lembur_libur_off', '');
                $this->db->or_where('lm.lembur_libur_off', null);
                $this->db->group_end();
            }
            if ($param[2] != '0') {
                $this->db->where('lm.lembur_libur_nasional != ""');
            } else {
                $this->db->group_start();
                $this->db->where('lm.lembur_libur_nasional', '');
                $this->db->or_where('lm.lembur_libur_nasional', null);
                $this->db->group_end();
            }
            if ($param[3] != '0') {
                $this->db->where('lm.lembur_libur_khusus != ""');
            } else {
                $this->db->group_start();
                $this->db->where('lm.lembur_libur_khusus', '');
                $this->db->or_where('lm.lembur_libur_khusus', null);
                $this->db->group_end();
            }
        }
        if ($param[4] != 'all') $this->db->where('md5(dk.id_karyawan)', $param[4]);
        if ($param[5] != 'all') $this->db->where('dk.id_cabang', $param[5]);
        if ($param[6] != 'all') $this->db->where('dk.id_departemen', $param[6]);

        $this->db->select('
            id_lembur_m,
            dk.id_karyawan,
            dk.nama_lengkap as nama,
            dk.nik,
            mc.nama as cabang,
            md.nama as departemen,
            lm.lembur_hari_kerja,
            lm.lembur_libur_off,
            lm.lembur_libur_nasional,
            lm.lembur_libur_khusus
        ')
            ->from('data_karyawan dk')
            ->join($this->table . ' lm', 'lm.id_karyawan = dk.id_karyawan', 'left')
            ->join('master_jabatan mj', 'mj.id_jabatan = dk.id_jabatan')
            ->join('master_cabang mc', 'mc.id_cabang = dk.id_cabang')
            ->join('master_departemen md', 'md.id_departemen = dk.id_departemen', 'left')
            ->where('dk.id_company', $this->id_company)
            ->where_in('dk.status', ['1', '2', '3', '4'])
            ->where_not_in('mj.level_user', ['1', '6'])
            ->order_by('dk.nama_lengkap ASC, dk.nik ASC');
    }

    public function getMasterLembur(): array
    {
        $query = $this->db->select('id_lembur_p, kode, keterangan')
            ->from('payroll_lembur_p')
            ->where('id_company', $this->id_company)
            ->get()
            ->result();

        $data = [];
        foreach ($query as $value) {
            $data[$value->id_lembur_p] = [
                'kode'       => $value->kode,
                'keterangan' => $value->keterangan
            ];
        }

        return $data;
    }

    public function getDataById($encrypt_id)
    {
        return $this->db->select('
            lm.id_lembur_m,
            dk.nama_lengkap as nama,
            dk.nik
        ')
            ->from($this->table . ' lm')
            ->join('data_karyawan dk', 'dk.id_karyawan = lm.id_karyawan')
            ->where('lm.id_company', $this->id_company)
            ->where('md5(lm.id_karyawan)', $encrypt_id)
            ->get()
            ->row();
    }

    public function save($data, $for)
    {
        $this->db->trans_begin();
        if ($for == 'update') {
            $data['user_update'] = $this->nik_karyawan . ' - ' . $this->nm_karyawan;
            $data['tgl_update']  = date('Y-m-d H:i:s');
            $this->db->update($this->table, $data, ['id_company' => $this->id_company, 'id_karyawan' => $data['id_karyawan']]);
        } else {
            $id_lembur           = $this->getNextId($this->table, 'id_lembur_m', $this->id_company, 4);
            $data['id_lembur_m'] = $id_lembur;
            $data['id_company']  = $this->id_company;
            $data['user_input']  = $this->nik_karyawan . ' - ' . $this->nm_karyawan;
            $this->db->insert($this->table, $data);
        }

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_update(false);
        } else {
            $this->db->trans_commit();
            return __response_update(true);
        }
    }

    public function delete($id)
    {
        $query = $this->db->delete($this->table, ['id_company' => $this->id_company, 'id_lembur_m' => $id]);
        if (!$query) {
            return __response_delete(false);
        }
        return __response_delete(true);
    }

    public function getNextId(string $tableName, string $fieldName, string $id_company, int $lengthNumber): string
    {
        $current_year = date('Y');
        $len_substring = -4 - $lengthNumber;
        $gedId = $this->db->query("SELECT
                                        MAX($fieldName) as id
                                    FROM $tableName
                                    WHERE
                                        id_company = '$id_company'
                                        AND SUBSTRING($fieldName,$len_substring,4) = '$current_year'
                                    FOR UPDATE");

        $nextId =  $id_company . $current_year . sprintf("%0" . $lengthNumber . "d", 1);
        if ($gedId->num_rows() > 0) {
            $current_id = substr($gedId->row()->id, "-" . $lengthNumber);
            $nextId =  $id_company . $current_year . sprintf("%0" . $lengthNumber . "d", ($current_id + 1));
        }

        return $nextId;
    }
}
