<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Kalender_m extends CI_Model
{
    var $table = 'holidays';

    function get_datatables()
    {
        $this->_get_datatables_query();
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {

        $this->db->select("id,tanggal,keterangan,jenis")->from($this->table);
        $this->db->where("id_company", $this->id_company);

        return $this->db->count_all_results();
    }

    private function _get_datatables_query()
    {
        $filter_jenis = $this->input->get('jenis');

        $this->db->select("id,tanggal,keterangan,jenis")->from($this->table);
        $this->db->where("id_company", $this->id_company);
        
        $this->db->where_in('jenis', $filter_jenis);

        $column_search = array('keterangan');
        $i = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('', 'tanggal', 'keterangan');

        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("tanggal" => "DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id = null)
    {
        $select = $this->db->query("SELECT id, tanggal, keterangan, jenis, id_company, color
                                    FROM $this->table
                                    WHERE MD5(id) = '$id'
                                    AND id_company = '" . $this->id_company . "'")->row();
        return $select;
    }

    public function save($data)
    {
        foreach ($data as $row) {

            $tanggal = $row['tanggal'];

            $cek_tanggal = $this->db->select("id, tanggal")
                ->from("holidays")
                ->where("tanggal", $tanggal)
                ->where("id_company", $this->id_company)
                ->get();

            $tgl_sudah_ada = date('d-m-Y', strtotime($cek_tanggal->row()->tanggal));

            if ($cek_tanggal->num_rows() > 0) {
                $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i> ' . $this->lang->line('error_tanggal_libur_2') . ' : '.$tgl_sudah_ada.'</font>');
                return __response_save(false, $message);
            }else {
                continue;
            }
        }

        $save = $this->db->insert_batch($this->table, $data);
        return __response_save($save);
    }

    public function update($data, $id = null)
    {
        $tanggal = $data['tanggal'];
        $cek_tanggal = $this->db->select("id")
            ->from("holidays")
            ->where("tanggal", $tanggal)
            ->where("md5(id) !=", $id)
            ->where("id_company", $this->id_company)
            ->get();
        if ($cek_tanggal->num_rows() > 0) {
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i> ' . $this->lang->line('error_tanggal_libur_2') . '</font>');
            return __response_update(false, $message);
        } else {
            $this->db->where(array('md5(id)' => $id, 'id_company' => $this->id_company));
            $update = $this->db->update($this->table, $data);
            $this->logger->create_log('pengaturan_holidays', 'edit', $this->db->last_query());
            return __response_update($update);
        }
    }

    public function delete($id = null)
    {
        $this->db->where(array('md5(id)' => $id));
        $delete = $this->db->delete($this->table);
        $this->logger->create_log('pengaturan_holidays', 'delete', $this->db->last_query());
        return  __response_delete($delete);
    }
}
