<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Aktual_kpi extends MY_Controller
{

    public function __construct(){
        parent::__construct();
        $this->load->model('kpi/admin/periode/aktual_kpi_m', 'model');
    }

    public function index(){
        $this->load->view('kpi/admin/periode/aktual_kpi/home');
    }

    public function list_data(){
        $tahun = $this->input->get('tahun');
        $list = $this->model->get_datatables($tahun);

        $data = array();
        for ($i=1; $i <=12 ; $i++) { 
            $id_bulan = sprintf("%02d", $i);
            $row = array();
            $row[] = $this->fungsi->konversi_bulan($id_bulan);
                
            $res = array_search($id_bulan, array_column($list, 'bulan'));
            $res = ($res !== false) ? $list[$res] : null;

            $periode_mulai   = ($res['periode_mulai'] !== null || $res['periode_mulai'] == '0000-00-00') ? $res['periode_mulai'] : '-';
            $periode_selesai = ($res['periode_selesai'] !== null || $res['periode_selesai'] == '0000-00-00') ? $res['periode_selesai'] : '-';

            $id_company = $res['id_company'];

            $span_periode_mulai  = ($periode_mulai != "1970-01-01") ? $this->fungsi->tgl_indo($periode_mulai) : "";
            $input_periode_mulai = ($periode_mulai != "1970-01-01") ? date_format(date_create($periode_mulai), "d-m-Y") : "";
            $tgl_mulai = '<span>' . $span_periode_mulai . '</span>';
            $tgl_mulai .= '<div class="row"><div class="col"></div><div class="col">';
            $tgl_mulai .= '<input type="text" data-old="' . $input_periode_mulai . '" name="tgl_mulai" class="hidden form-control periode_tgl text-center" value="' . $input_periode_mulai . '">';
            $tgl_mulai .= '</div><div class="col"></div></div>';

            $span_periode_selesai  = ($periode_selesai != "1970-01-01") ? $this->fungsi->tgl_indo($periode_selesai) : "";
            $input_periode_selesai = ($periode_selesai != "1970-01-01") ? date_format(date_create($periode_selesai), "d-m-Y") : "";
            $tgl_selesai = '<span>' . $span_periode_selesai . '</span>';
            $tgl_selesai .= '<div class="row"><div class="col"></div><div class="col">';
            $tgl_selesai .= '<input type="text" data-old="' . $input_periode_selesai . '" name="tgl_selesai" class=" hidden form-control periode_tgl text-center" value="' . $input_periode_selesai . '">';
            $tgl_selesai .= '</div><div class="col"></div></div>';

            $row[] = $tgl_mulai;
            $row[] = $tgl_selesai;

            $btn_edit = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i class="btn_edit fa fa-edit (alias)" onclick="edit(this)"> </i></a>';
            $btn_save = '<a href="javascript:void(0)" class="text-primary" title="SIMPAN"> <i id="' . ($tahun.$i.$id_company) . '" class="btn_save fa fa-save (alias)" onclick="save(this)"> </i></a>';
            $btn_batal = '<a href="javascript:void(0)" class="text-danger" title="BATAL"> <i class="btn_batal fa fa-close (alias)" onclick="batal(this)"> </i></a>';
            $loading  = '<div class="custom-loader hidden"></div>';

            $row[] = $loading . '<div id="save" class="hidden">' . $btn_save . ' ' . $btn_batal . '</div>
                    <div id="edit">' . $btn_edit . ' </div>';

           $data[] = $row;
        }


        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => 12,
            "recordsFiltered" => 12,
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function save(){
        $id              = $this->input->post('id');
        $periode         = $this->input->post('periode');
        $periode_mulai   = $periode[0];
        $periode_selesai = $periode[1];
        $strlen          = strlen($id);

        if(empty($periode_mulai)){
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Periode mulai harus diisi</font>');
            return __response_save(false, $message);
        }

        if(empty($periode_selesai)){
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Periode selesai harus diisi</font>');
            return __response_save(false, $message);
        }

        if ($strlen <= 6) {
            $tahun = substr($id,0,4);

            if ($strlen == 5) {
                $bulan = substr($id,-1, 1);
            }else if($strlen == 6){
                $bulan = substr($id,-2, 2);
            }

            $jenis = 'insert';
            $data = array(
                'periode_mulai'   => date('Y-m-d', strtotime($periode_mulai)),
                'periode_selesai' => date('Y-m-d', strtotime($periode_selesai)),
                'tahun'           => $tahun,
                'bulan'           => $bulan,
                'id_company'      => $this->id_company,
                'user_input'      => $this->nik_karyawan. ' - '. $this->nm_karyawan
            );

        }else if($strlen >= 7){
            $jenis = 'update';
            $data = array(
                'periode_mulai'   => date('Y-m-d', strtotime($periode_mulai)),
                'periode_selesai' => date('Y-m-d', strtotime($periode_selesai)),
                'user_update'     => $this->nik_karyawan. ' - '. $this->nm_karyawan,
                'tgl_update'      => date('Y-m-d h:i:s')
            );
        }

        $this->model->save($data, $id,$jenis);
    }
}