<script>
    $(function() {
        tanggal();
        pickrange('#periode_mulai', '#periode_selesai');
        dropdown_group();
        dropdown_karyawan();
        list_datatable("table");

        $("#btn_filter").on("click", function() {
            if ($("#view-table").length) {
                list_datatable("chart", this);
            } else {
                list_datatable("table", this);
            }
        });
    });

    function tanggal() {
        var d = new Date();
        d.setDate(d.getDate()); // - 1
        $('.input-daterange input').each(function() {
            $(this).datepicker({
                orientation: "bottom",
                format: "dd-mm-yyyy",
                endDate: d,
                autoclose: true,
            });
        });
    }

    function dropdown_group() {
        let periode_mulai   = $(".filter #periode_mulai").val();
        let periode_selesai = $(".filter #periode_selesai").val();
        $(".filter #id_group").select2({
            placeholder: "Semua Group",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.report.poin.harian.dropdown.group") ?>'+'?periode_mulai='+periode_mulai+'&periode_selesai='+periode_selesai,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function dropdown_karyawan() {
        var periode_mulai   = $(".filter #periode_mulai").val();
        var periode_selesai = $(".filter #periode_selesai").val();
        let id_group        = (!$('.filter #id_group').val())?"all":$('.filter #id_group').val();

        $(".filter #id_karyawan").select2({
            placeholder: "Semua Sales",
            allowClear: true,
            ajax: {
                url: "<?= route("sales_activity.report.poin.harian.dropdown.karyawan") ?>"+
                                '?periode_mulai='+periode_mulai+
                                '&periode_selesai='+periode_selesai+
                                '&id_group='+id_group,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function onchange_dropdown_periode(){
        $(".filter #id_group").val('').trigger('change');
        $(".filter #id_karyawan").val('').trigger('change');
        dropdown_group();
        dropdown_karyawan();
    }

    function onchange_dropdown_group() {
        $(".filter #id_karyawan").val('').trigger('change');
        dropdown_karyawan();
    }

    function list_datatable(view = "table", e = "") {
        var periode_mulai   = $(".filter #periode_mulai").val();
        var periode_selesai = $(".filter #periode_selesai").val();
        var id_group        = !$(".filter #id_group").val()?'all':$(".filter #id_group").val();
        var id_karyawan     = !$(".filter #id_karyawan").val()?'all':$(".filter #id_karyawan").val();

        if(view == "diagram"){
            if(periode_mulai == periode_selesai){
                periode_mulai = kurangi_satu_hari(periode_mulai);
                $(".filter_p_harian #periode_mulai").val(periode_mulai);
            }
        }

        if (e !== "") {
            var loading = Ladda.create(e);
            loading.start();
        }

        var load_url = "";
        if (view === "table") {
            load_url = "<?= route('sales_activity.report.poin.harian.table.data.view') ?>"+"?periode_mulai="+periode_mulai+"&periode_selesai="+periode_selesai+"&id_group="+id_group+"&id_karyawan="+id_karyawan;
        } else {
            load_url = "<?= route('sales_activity.report.poin.harian.diagram.data.view') ?>"+"?periode_mulai="+periode_mulai+"&periode_selesai="+periode_selesai+"&id_group="+id_group+"&id_karyawan="+id_karyawan;
        }

        return $.get(load_url, function(data) {
            $("#view_data").html(data);
            if (e !== "") loading.stop();
        });
    }

    function kurangi_satu_hari(tanggal){
        // Convert tanggal  to a Date object
        let tanggalDate = new Date(tanggal.split('-').reverse().join('-')); // Mengonversi dari DD-MM-YYYY ke YYYY-MM-DD

        // Kurangi satu hari
        tanggalDate.setDate(tanggalDate.getDate() - 1);

        // Format ulang ke string DD-MM-YYYY
        let tanggalUpdated =
            tanggalDate.getDate().toString().padStart(2, '0') + '-' +
            (tanggalDate.getMonth() + 1).toString().padStart(2, '0') + '-' +
            tanggalDate.getFullYear();

        return tanggalUpdated;
    }
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Report Poin Harian</h5>
    </div>
</div>
<hr>

<div class="filter row">
        <div class="col-md-3">
            <label><?= $this->lang->line('periode'); ?></label>
            <?php
                $date_now = date('d-m-Y',  strtotime(date('Y-m-d')));
            ?>
            <div class="input-group input-daterange">
                <input type="text" id="periode_mulai" class="form-control masktanggal" value="<?= $date_now; ?>" onchange="onchange_dropdown_periode()" required>
                <div class="align-self-center">&nbsp;<?= $this->lang->line('s/d'); ?>&nbsp;</div>
                <input type="text" id="periode_selesai" class="form-control masktanggal" value="<?= $date_now; ?>" onchange="onchange_dropdown_periode()" required>
            </div>
        </div>

        <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
            <div class="col-md-3">
                <label><?= $this->lang->line('group_area'); ?></label>
                <select id="id_group" class="form-control" style="width: 100%" onchange="onchange_dropdown_group()"></select>
            </div>
        <?php endif; ?>

        <div class="col-md-3">
            <label>Sales</label>
            <select id="id_karyawan" class="form-control" style="width: 100%"></select>
        </div>

        <div class="col-md-1 align-self-end">
            <button type="button" id="btn_filter" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
        </div>
    </div>
</div>


<div id="view_data"></div>
