<script type="text/javascript">
    function dropdown_karyawan() {
        $("#karyawan").select2({
            placeholder: 'Semua Karyawan',
            allowClear: true,
            ajax: {
                url: "<?= route('dropdown.karyawan') ?>",
                dataType: 'json',
                processResults: function (data) {
                    // Transforms the top-level key of the response object from 'items' to 'results'
                    return {
                        results: data
                    };
                }
            }
        });
        $('#karyawan ~ span input').attr('style', 'width: 100%;');
    }

    function dropdown_cabang() {
        $("#cabang").select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                url: "<?= route('dropdown.cabang') ?>",
                dataType: 'json',
                processResults: function (data) {
                    // Transforms the top-level key of the response object from 'items' to 'results'
                    return {
                        results: data
                    };
                }
            }
        });
    }

    function dropdown_departemen() {
        $("#departemen").select2({
            placeholder: 'Semua Departemen',
            allowClear: true,
            ajax: {
                url: "<?= route('dropdown.departemen') ?>",
                dataType: 'json',
                processResults: function (data) {
                    // Transforms the top-level key of the response object from 'items' to 'results'
                    return {
                        results: data
                    };
                }
            }
        });
    }


    $(function() {
        dropdown_cabang();
        dropdown_departemen();
        dropdown_karyawan();

        $(".btn_unduh").click(function(){
            if($("#template").val() == null) {
                $('#message').html('<span class="text-danger"><i class="fa fa-exclamation-triangle"></i> template belum dipilih</span>');
                $('#template').focus();
                return false;
            }
            var loading = Ladda.create(this);

            const id_template = $('#template').val();
            var id_cabang     = (!$("#form_template #cabang").val())?"all":$("#form_template #cabang").val();
            var id_departemen = (!$("#form_template #departemen").val())?"all":$("#form_template #departemen").val();
            var id_karyawan = (!$("#form_template #karyawan").val())?"all":$("#form_template #karyawan").val();

            loading.start();

            window.location.href = "<?= route('pkwt.import.template.excel') ?>"+"?id_template="+id_template+"&id_cabang=" + id_cabang + "&id_departemen=" + id_departemen + "&id_karyawan=" + id_karyawan;
            setTimeout(function (){
                loading.stop();
            },100);


        });
    });
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_template" class="card-body" disabled>
    <div class="form-group">
        <label>Pilih Template <span class="text-danger">*</span></label>
        <select id="template" class="form-control" style="width: 100%;">
        </select>
    </div>
    <div class="form-group">
        <label>CABANG</label>
        <select id="cabang" class="form-control" style="width: 100%;">
        </select>
    </div>

    <div class="form-group">
        <label>DEPARTEMEN</label>
        <select id="departemen" class="form-control" style="width: 100%;">
        </select>
    </div>
    
    <div class="form-group">
        <label>Karyawan</label>
            <select id="karyawan" class="form-control" style="width: 100%;" multiple="multiple">
        </select>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div id="message" class="col-md-7 text-left"></div>
        <div class="col-md-5 text-right">
            <button class="btn_unduh ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>

