<script src="<?=base_url('assets/js/')?>/autoNumeric.js"></script>

<script>
    $(document).ready(function() {
        datepicker();

        $(".numeric").autoNumeric('init', {
            aSep: '.', 
            aDec: ',',
            aForm: true,
            vMax: '999999999',
            vMin: '0'
        });

        <?php if(isset($template)) : ?>
            show_parameter(null, '<?= md5($data->id_pkwt) ?>');
        <?php endif; ?>
    });
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="form_input_id_pkwt" class="form-control" value="<?= ((!empty($data->id_pkwt))?MD5($data->id_pkwt):'') ?>">
    <input type="hidden" id="form_input_id_karyawan" class="form-control" value="<?= ((isset($data))?($data->id_karyawan):'') ?>">
    <input type="hidden" id="form_input_nik" class="form-control" value="<?= ((isset($data))?($data->nik):'') ?>">
    <input type="hidden" id="form_input_nm_karyawan" class="form-control" value="<?= ((isset($data))?($data->nama_lengkap):'') ?>">
    <input type="hidden" id="form_input_lahir_tempat" class="form-control" value="<?= ((isset($data))?($data->tempat_lahir):'') ?>">
    <input type="hidden" id="form_input_lahir_tgl" class="form-control" value="<?= ((isset($data))?($data->tgl_lahir):'') ?>">
    <input type="hidden" id="form_input_alamat" class="form-control" value="<?= ((isset($data))?($data->alamat_domisili):'') ?>">
    <input type="hidden" id="form_input_nm_level_user" class="form-control" value="<?= ((isset($data))?($data->nama_level_user):'') ?>">
    <input type="hidden" id="form_input_nm_jabatan" class="form-control" value="<?= ((isset($data))?($data->nama_jabatan):'') ?>">
    <input type="hidden" id="form_input_nm_departemen" class="form-control" value="<?= ((isset($data))?($data->nama_departemen):'') ?>">
    <input type="hidden" id="form_input_nm_cabang" class="form-control" value="<?= ((isset($data))?($data->nama_cabang):'') ?>">
    <input type="hidden" id="form_input_nm_draft_pkwt" class="form-control" value="<?= ((isset($data))?($data->nm_draft_pkwt):'') ?>">
    <input type="hidden" id="form_input_draft_pkwt_parameter" class="form-control" value='<?= ((isset($data))? htmlspecialchars($data->draft_pkwt_parameter) :'') ?>'>
    
    <div class="row">
        <!-- START KOLOM KIRI -->
        <div class="col-md-4 border-right">
            <div class="row mb-2">
                <div class="col-md-12 text-primary"><h5>Data Karyawan</h5></div>
            </div>
            <fieldset class="form-group">
                <label>Nama Karyawan</label>
                <p class="form-control-static font-weight-bold" ><?= $data->nik. " - ". $data->nama_lengkap ?></p>
            </fieldset>
            <fieldset class="form-group">
                <label>Tempat/Tanggal Lahir</label>
                <p class="form-control-static font-weight-bold" ><?= $data->tempat_lahir. ", ". indo_date(strtotime($data->tgl_lahir), "d F Y") ?></p>
            </fieldset>
            <fieldset class="form-group">
                <label>Alamat</label>
                <p class="form-control-static font-weight-bold" ><?= $data->alamat_domisili ?></p>
            </fieldset>
            <fieldset class="form-group">
                <label>Jabatan</label>
                <p class="form-control-static font-weight-bold" ><?= $data->nama_level_user. " - ". $data->nama_jabatan ?></p>
            </fieldset>
            <fieldset class="form-group">
                <label>Cabang-Departemen</label>
                <p class="form-control-static font-weight-bold" ><?= $data->nama_cabang. " - ". $data->nama_departemen ?></p>
            </fieldset>
            <?php if(!empty($data->tgl_berhenti_bekerja)){ ?>
                <fieldset class="form-group">
                    <label>Tgl Kontrak Habis</label>
                    <p class="form-control-static font-weight-bold" ><?= indo_date(strtotime($data->tgl_berhenti_bekerja), "d F Y") ?></p>
                </fieldset>
            <?php }?>
        </div>

        <!-- START KOLOM KANAN -->
        <div class="col-md-8">
            <div class="row mb-2">
                <div class="col-md-12 text-primary"><h5>Perpanjang PKWT</h5></div>
            </div>
            <div class="row form-group">
                <div class="col-md-4">Pilih Template <span class="text-danger">*</span></div>
                <div class="col-md-8">
                    <select class="form-control" name="template" id="template" class="select2 form-control" onchange="show_parameter(this.value, null);" style="width: 100%;" <?= isset($template) ? 'disabled' : '' ?>>
                    <?php if(isset($template)) : ?>
                        <option value="<?= $template->id_template ?>"><?= $template->nama ?></option>
                    <?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="row form-group">
                <div class="col-md-4">Tanggal PKWT <span class="text-danger">*</span></div>
                <div class="col-md-8">
                    <?php
                        if (!empty($data->tgl_pkwt)) {
                            $tgl_pkwt = date('d-m-Y', strtotime($data->tgl_pkwt));
                        }else{
                            $tgl_pkwt = "";
                        }
                    ?>
                    <input type="text" name="form_input_tanggal_pkwt" id="form_input_tanggal_pkwt" class="form-control datepicker" placeholder="dd-mm-yyyy" value="<?= $tgl_pkwt ?>" autocomplete="off">
                </div>
            </div>
            <div class="row form-group">
                <div class="col-md-4">Masa Kontrak Baru <span class="text-danger">*</span></div>
                <div class="col-md-8">
                    <div class="input-group input-daterange">
                        <?php
                            if (!empty($data->tgl_pkwt_mulai)) {
                                $tgl_pkwt_mulai = date('d-m-Y', strtotime($data->tgl_pkwt_mulai));
                                $tgl_pkwt_selesai = date('d-m-Y', strtotime($data->tgl_pkwt_selesai));
                            }else{
                                $tgl_pkwt = "";
                                $tgl_pkwt_selesai = "";
                            }
                        ?>
                        <input type="text" name="form_input_tanggal_mulai" id="form_input_tanggal_mulai" class="form-control datepicker" style="z-index: 3 !important;" placeholder="dd-mm-yyyy"  value="<?= $tgl_pkwt_mulai ?>" autocomplete="off">
                        <div class="align-self-center">&nbsp;s/d&nbsp;</div>
                        <input type="text" name="form_input_tanggal_selesai" id="form_input_tanggal_selesai" class="form-control datepicker" style="z-index: 3 !important;" placeholder="dd-mm-yyyy" value="<?= $tgl_pkwt_selesai ?>" autocomplete="off">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <h5>Parameter</h5>
                </div>
            </div>
            <div id="parameter" class="mb-2">-</div>
        </div>
    </div>
</div>

<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div>
</div>