<style>
    th {
        vertical-align: middle !important;
    }

    table.dataTable td {
        vertical-align: top !important;
    }
</style>
<div class="btn-group mb-1">
    <button id="excel_cortax" data-format="bpmp" class="btn btn-primary text-white ladda-button"
        data-style="expand-left"><i class="fa fa-file-excel-o"></i> DOWNLOAD FORMAT CORTAX <span
            class="badge badge-secondary">BPMP</span></button>
</div>
<!-- <div class="btn-group mb-1">
    <button id="excel_djp" class="btn btn-biru text-white ladda-button" data-style="expand-left"><i
            class="fa fa-file-excel-o"></i> DOWNLOAD FORMAT DJP 1721</button>
</div> -->

<div class="table-responsive">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="align-top">No</th>
                <th class="align-top">Masa Pajak</th>
                <th class="align-top">Tahun Pajak</th>
                <th class="align-top">Status Pegawai</th>
                <th class="align-top">Nama Pegawai</th>
                <th class="align-top">NPWP/NIK/TIN</th>
                <th class="align-top">Nomor Passport</th>
                <th class="align-top">Status</th>
                <th class="align-top">Posisi</th>
                <th class="align-top">Sertifikat/Fasilitas</th>
                <th class="align-top">Kode Objek Pajak</th>
                <th class="align-top">Penghasilan Kotor</th>
                <th class="align-top">Tarif</th>
                <th class="align-top">ID TKU</th>
                <th class="align-top">Tgl Pemotongan</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script>
    $(function () {
        $("#excel_cortax").click(function () {
            let format = $(this).data('format');
            if (format === 'bpmp') {
                let urlExcel = "<?= route('payroll.laporan.pph.download.excel.cortax_bpmp', ['bulan' => $bulan, 'id_cabang' => $id_cabang, 'id_departemen' => $id_departemen, 'id_karyawan' => $id_karyawan]) ?>";
                downloadFile(urlExcel, this);
            }
        });

        // LIST DATA
        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function (e, settings, techNote, message) {
            if (confirm('Terjadi kesalahan saat memproses data, muat ulang halaman ?')) {
                window.location.reload();
            }
        }).DataTable({
            'searching': false,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            'autoWidth': false,
            // 'fixedColumns': {
            //     leftColumns: 2
            // },
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                'searchPlaceholder': 'Kode/Nama'
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('payroll.laporan.pph.list.data', ['bulan' => $bulan, 'id_cabang' => $id_cabang, 'id_departemen' => $id_departemen, 'id_karyawan' => $id_karyawan]) ?>",
                "type": "GET",
                "data": function (d) {
                    delete d.columns;
                },
                "complete": function (data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [
                {
                    "aTargets": [3, 4, 5, 6, 7, 8, 9, 10, -1, -2],
                    "className": "text-left"
                },
                {
                    "aTargets": [11],
                    "className": "text-right"
                },
                {
                    "aTargets": "_all",
                    "className": "text-center"
                }
            ],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                // $('td:eq(-1)', nRow).css({
                //     'background': '#F5F5DC'
                // });
            }
        });
        // END LIST DATA
    });
</script>