<div class="content-header mt-4">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Payroll</a></li>
                        <li class="breadcrumb-item"><a href="#">BPJS</a></li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= route('payroll.bpjs.master') ?>" class="btn btn-secondary btn-min-width">
                    <i class="fa fa-arrow-left"></i> KEMBALI
                </a>
            </div>
        </div>
    </div>
</div>

<div id="content" class="card card-rounded">
    <div class="card-content">
        <div class="card-body form_import">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Upload File <span class="text-danger">*</span></label>
                        <input type="file" name="file" id="file" class="form-control">
                    </div>
                </div>
                <div class="col-md-7 align-self-end">
                    <div class="form-group">
                        <button type="button" id="btn_import_gaji" class="btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-upload"></i> IMPORT DATA BPJS</button>
                        <button type="button" id="btn_form_template" class="btn btn-primary"><i class="fa fa-download"></i> DOWNLOAD TEMPLATE</button>
                        <label id="message"></label>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="content" class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-md-5">
                    <button class="btn btn-success btn_simpan_semua" id="simpan_all"><i class="fa fa-save"></i> SIMPAN SEMUA DATA KE MASTER BPJS</button>
                    <button class="btn btn-danger btn_hapus_semua" id="hapus_all"><i class="fa fa-trash"></i> HAPUS SEMUA DRAFT</button>
                </div>
                <div class="col-md-7 text-right">
                    <button class="btn btn-success btn-sm" title="Data sudah diimport"></button> <span>Data sudah diimport</span>
                    <button class="btn btn-warning btn-sm" title="Data sudah ada"></button> <span>Data sudah ada</span>
                    <button class="btn btn-danger btn-sm" title="Data tidak lengkap"></button> <span>Data tidak lengkap</span>
                </div>
            </div>
            <div class="table-responsive mt-2">
                <table id="list_data" class="table table-striped table-bordered" style="width:100%">
                    <thead>
                        <tr>
                            <th rowspan="2" style="width: 50px;">NO</th>
                            <th rowspan="2" style="width: 150px;">KARYAWAN</th>
                            <th rowspan="2">GAJI DIDAFTARKAN</th>
                            <th colspan="4">BPJS KESEHATAN</th>
                            <th colspan="7">BPJS KETENAGAKERJAAN</th>
                            <th rowspan="2">TOTAL POT.</th>
                            <th rowspan="2">TOTAL TUNJ.</th>
                            <th rowspan="2" style="width: 50px;">AKSI</th>
                        </tr>
                        <tr>
                            <!-- bpjs kes -->
                            <th>NOMOR</th>
                            <th>JML ANAK</th>
                            <th>TUNJ. PERUS (<?= $data_bpjs_kes->tunj_perus ?> %)</th>
                            <th>POT. KRY (<?= $data_bpjs_kes->pot_kry ?> %)</th>
                            <!-- bpjs tk -->
                            <th>NOMOR</th>
                            <th>TUNJ. JHT PERUS (<?= $data_bpjs_tk->tunj_jht_perus ?> %)</th>
                            <th>POT. JHT KRY (<?= $data_bpjs_tk->pot_jht_kry ?> %)</th>
                            <th>TUNJ. JKK (<?= $data_bpjs_tk->tunj_jkk ?> %)</th>
                            <th>TUNJ. JKM (<?= $data_bpjs_tk->tunj_jkm ?> %)</th>
                            <th>TUNJ. JP PERUS (<?= $data_bpjs_tk->tunj_jp_perus ?> %)</th>
                            <th>POT. JP KRY (<?= $data_bpjs_tk->pot_jp_kry ?> %)</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- START TAMPIL MODAL -->
<div id="modal_hapus" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_hapus" class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right tombol">
                        <!-- <button class="btn_hapus ladda-button" id="btn_hapus" data-style="expand-left"></button> -->
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
<!-- START TAMPIL MODAL -->
<div id="modal_form_bpjs_m" class="modal fade in" data-keyboard="false" data-backdrop="static" aria-hidden="true">
    <div class="modal-dialog modal-lg" style="max-width: 80%;">
        <div id="tampil_form_bpjs_m" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
<?= $script ?>