<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Adm_absensi_m extends CI_Model
{
    var $table = 'p_adm_absensi';

    function get_datatables(){
        $this->_get_datatables_query();
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("
            admin.id_karyawan,
            karyawan.nik,
            karyawan.nama_lengkap,
        ")
            ->from($this->table. ' AS admin')
            ->join('data_karyawan as karyawan', 'karyawan.id_karyawan = admin.id_karyawan')
            ->where("admin.id_company", $this->id_company);

        $column_search = array('karyawan.nama_lengkap');
        $i = 0;
        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        // $column_order = array('', 'kode', 'nama', 'flag');
        if (isset($_GET['order'])) {
            // $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("karyawan.nama_lengkap" => "DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function save($data = [], $id){
        $cek_id_karyawan = $this->_cek_id_karyawan($data['id_karyawan'], $id);

        if(empty($cek_id_karyawan)){
            if(empty($id)){
                // PROSES SAVE
                $save = $this->db->insert($this->table, $data);
                return  __response_save($save);
            }else{
                // PROSES UPDATE
                $this->db->where('id_company', $this->id_company);
                $this->db->where('MD5(id_karyawan)', $id);
                $update = $this->db->update($this->table, $data);
                return  __response_update($update);
            }
        }else{
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_duplicate') . '</font>');
            return __response_save(false, $message);
        }
    }

    public function getDataById($id = null){
        $query = $this->db->select("
                admin.id_karyawan,
                karyawan.nik,
                karyawan.nama_lengkap
            ")
            ->from($this->table. ' AS admin')
            ->join('data_karyawan as karyawan', 'karyawan.id_karyawan = admin.id_karyawan')
            ->where('admin.id_company', $this->id_company)
            ->where('MD5(admin.id_karyawan)', $id)
            ->get()
            ->row();
        return $query;
    }

    public function delete($id = null){
        $this->db->where('MD5(id_karyawan)', $id);
        $this->db->where('id_company', $this->id_company);
        $delete = $this->db->delete($this->table);
        return  __response_delete($delete);
    }

    private function _cek_id_karyawan($id_karyawan="", $id=""){
        if(!empty($id)){
            $this->db->where('MD5(id_karyawan) !=', $id);
        }
        
        return $this->db->select("id_karyawan")
                        ->from($this->table)
                        ->where('id_company', $this->id_company)
                        ->where('id_karyawan', $id_karyawan)
                        ->get()
                        ->row()
                        ->id_karyawan;
    }
}