<?php

class Nilai_individu_m extends CI_Model {

    var $table = 'kpi_personal_score_trx';
    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query;
    }

    public function count_all($id_karyawan, $tahun, $bulan){
        $this->db->select("id_karyawan")->from($this->table);
        $this->db->where("id_company",$this->id_company);
        $this->db->where("id_karyawan", $id_karyawan);
        $this->db->where("tahun", $tahun);
        $this->db->where("bulan", $bulan);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query(){
        $this->db->from($this->table);
        $this->db->where("id_company",$this->id_company);
        $this->db->where("id_karyawan", htmlentities($this->input->get('karyawan')));
        $this->db->where("tahun", htmlentities($this->input->get('tahun')));
        $this->db->where("bulan", htmlentities($this->input->get('bulan')));
    }

    public function skorMaster() {
        $this->db->select('grade, keterangan, batas_bawah, batas_atas');
        $this->db->from('kpi_predikat_p');
        $this->db->where('id_company', $this->id_company);
        $this->db->order_by('grade', 'asc');
        $data   = $this->db->get()->result_array();
        $result = [];
        foreach($data as $index => $row) {
            $temp['batas_bawah'] = $row['batas_bawah'];
            $temp['batas_atas']  = $row['batas_atas'];
            $result[] = array_merge(array_slice($row, 0, 2), $temp, array_slice($row, 3));
        }
        return $result;
    }

    public function getAspekMaster($id_jabatan) {
        $this->db->from('kpi_aspek_bobot_p');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('id_jabatan', $id_jabatan);
        $row = $this->db->get()->row();
        return [
            'Aspek Kinerja'      => $row->bobot_aspek_kinerja      == null ? 0 : $row->bobot_aspek_kinerja,
            'Aspek Kepribadian'  => $row->bobot_aspek_kepribadian  == null ? 0 : $row->bobot_aspek_kepribadian,
            'Aspek Kedisiplinan' => $row->bobot_aspek_kedisiplinan == null ? 0 : $row->bobot_aspek_kedisiplinan
        ];
    }

    public function insertSkorTemporary($jenis) {
        $id_karyawan = htmlentities($this->input->post('karyawan'));
        $tahun       = htmlentities($this->input->post('tahun'));
        $bulan       = htmlentities($this->input->post('bulan'));
        $id_jabatan  = htmlentities($this->input->post('jabatan'));

        $total       = $this->count_all($id_karyawan, $tahun, $bulan);
        $aspekMaster = $this->getAspekMaster($id_jabatan);

        if($total == 0) {
            $data = [
                'id_karyawan' => $id_karyawan,
                'tahun'       => $tahun,
                'bulan'       => $bulan,
                'id_company'  => $this->id_company,
                'user_input'  => "$this->nik_karyawan - $this->nm_karyawan"
            ];

            foreach($aspekMaster as $index => $bobot) {
                $index_name = str_replace(" ", "_", strtolower($index));
                if($index == 'Aspek Kedisiplinan') {
                    break;
                }

                if($index_name == 'aspek_kinerja') {
                    $total = $this->totalAspekKepribadian($id_karyawan, $tahun, $bulan);
                    $skor  = round(($total*$bobot)/100, 2);
                } elseif($index_name == 'aspek_kepribadian') {
                    $total = $this->totalKepribadian($id_karyawan, $tahun, $bulan);
                    $skor  = round(($total*$bobot)/100, 2);
                }
                
                $data[$index_name.'_nm'] = $index;
                if($jenis == $index) {
                    $data[$index_name.'_bobot']  = $bobot;
                    $data[$index_name.'_aktual'] = $total;
                    $data[$index_name.'_skor']   = $skor;
                } else {
                    $data[$index_name.'_bobot']  = 0;
                    $data[$index_name.'_aktual'] = 0;
                    $data[$index_name.'_skor']   = 0;
                }
            }

            $this->db->insert('kpi_personal_score_trx', $data);
        } else {
            $index_name = str_replace(" ", "_", strtolower($jenis));
            $data[$index_name.'_bobot'] = $aspekMaster[$jenis];
            if($index_name == 'aspek_kinerja') {
                $total = $this->totalAspekKepribadian($id_karyawan, $tahun, $bulan);
                $skor  = round(($total*$data[$index_name.'_bobot'])/100, 2);
            } elseif($index_name == 'aspek_kepribadian') {
                $total = $this->totalKepribadian($id_karyawan, $tahun, $bulan);
                $skor  = round(($total*$data[$index_name.'_bobot'])/100, 2);
            }
            $data[$index_name.'_skor']   = $skor;
            $data[$index_name.'_aktual'] = $total;
            $data['user_update']         = "$this->nik_karyawan - $this->nm_karyawan";
            $data['tgl_update']          = date('Y-m-d H:i:s');

            $where = [
                'id_karyawan' => $id_karyawan,
                'tahun'       => $tahun,
                'bulan'       => $bulan,
                'id_company'  => $this->id_company
            ];

            $this->db->update('kpi_personal_score_trx', $data, $where);
        }
    }

    public function updateSkor($id_karyawan, $tahun, $bulan, $id_jabatan) {
        $total = $this->count_all($id_karyawan, $tahun, $bulan);
        if($total == 0) {
            $aspekMaster = $this->getAspekMaster($id_jabatan);

            $bobot = $aspekMaster['Aspek Kedisiplinan'];
            $total = $this->totalKedisiplinan($id_karyawan, $tahun, $bulan);
            $skor  = round(($total*$bobot)/100, 2);

            $data = [
                'id_karyawan' => $id_karyawan,
                'tahun'       => $tahun,
                'bulan'       => $bulan,
                'grade'       => json_encode($this->skorMaster()),
                'id_company'  => $this->id_company,
                'user_input'  => "$this->nik_karyawan - $this->nm_karyawan",
                $index_name.'_nm'          => $index,
                $index_name.'_aktual'      => $total,
                $index_name.'_bobot'       => $bobot,
                $index_name.'_skor'        => $skor,
                'skor_ttl'    => $skor
            ];

            $grade                 = $this->getGrade($skor, $data['grade']);
            $data['skor_predikat'] = $grade['grade'];
            $data['remark']        = $grade['remark'];
            $this->db->insert('kpi_personal_score_trx', $data);
        } else {
            $getData     = $this->getData();
            $aspekMaster = $this->getAspekMaster($id_jabatan);
            $skorTtl     = 0;
            $data        = [
                'grade'       => json_encode($this->skorMaster()),
                'user_update' => "$this->nik_karyawan - $this->nm_karyawan",
                'tgl_update'  => date('Y-m-d H:i:s')
            ];
            foreach($aspekMaster as $index => $bobot) {
                $index_name = str_replace(" ", "_", strtolower($index));
                if($index_name == 'aspek_kedisiplinan') {
                    $total = $this->totalKedisiplinan($id_karyawan, $tahun, $bulan);
                    $skor  = round(($total*$bobot)/100, 2);

                    $data[$index_name.'_nm']     = $index;
                    $data[$index_name.'_aktual'] = $total;
                    $data[$index_name.'_bobot']  = $bobot;
                    $data[$index_name.'_skor']   = $skor;
                } else {
                    $skor = $getData->{$index_name.'_skor'};
                }
                $skorTtl += $skor;
            }
            $data['skor_ttl']      = $skorTtl;
            $grade                 = $this->getGrade($skorTtl, $data['grade']);
            $data['skor_predikat'] = $grade['grade'];
            $data['remark']        = $grade['remark'];

            $where = [
                'id_karyawan' => $id_karyawan,
                'tahun'       => $tahun,
                'bulan'       => $bulan,
                'id_company'  => $this->id_company
            ];

            $this->db->update('kpi_personal_score_trx', $data, $where);
        }
    }

    private function getData() {
        $this->db->where('tahun', htmlentities($this->input->post('tahun')));
        $this->db->where('bulan', htmlentities($this->input->post('bulan')));
        $this->db->where('id_karyawan', htmlentities($this->input->post('karyawan')));
        return $this->db->get('kpi_personal_score_trx')->row();
    }

    public function jenis() {
        return ['aspek_kinerja', 'aspek_kepribadian', 'aspek_kedisiplinan'];
    }

    public function getGrade($skor, $grade) {
        $grade = json_decode($grade);
        $skor = floatval($skor);
        foreach($grade as $value) {
            $batasBawah = floatval($value->batas_bawah);
            $batasAtas  = floatval($value->batas_atas);
            if($batasBawah <= $skor and $batasAtas >= $skor) {
                return [
                    'grade'  => $value->grade,
                    'remark' => $value->keterangan
                ];
                break;
            }
        }
    }

    private function totalKepribadian($id_karyawan, $tahun, $bulan) {
        $this->db->select('sum((bobot/100)*actual_poin_approval) as total', false);
        $this->db->from('kpi_aspek_kepribadian_trx');
        $this->db->where('id_karyawan', $id_karyawan);
        $this->db->where('tahun', $tahun);
        $this->db->where('bulan', $bulan);
        return $this->db->get()->row()->total;
    }

    private function totalAspekKepribadian($id_karyawan, $tahun, $bulan) {
        $this->db->select('sum((bobot/100)*actual_poin_approval) as total', false);
        $this->db->from('kpi_aspek_kinerja_trx');
        $this->db->where('id_karyawan', $id_karyawan);
        $this->db->where('tahun', $tahun);
        $this->db->where('bulan', $bulan);
        return $this->db->get()->row()->total;
    }

    private function totalKedisiplinan($id_karyawan, $tahun, $bulan) {
        $this->db->select_sum('skor');
        $this->db->from('kpi_aspek_kedisiplinan_trx');
        $this->db->where('id_karyawan', $id_karyawan);
        $this->db->where('tahun', $tahun);
        $this->db->where('bulan', $bulan);
        return $this->db->get()->row()->skor;
    }

    public function getDataSkor($id_karyawan, $tahun, $bulan) {
        $this->db->select('grade');
        $this->db->from($this->table);
        $this->db->where("id_company",$this->id_company);
        $this->db->where("id_karyawan", $id_karyawan);
        $this->db->where("tahun", $tahun);
        $this->db->where("bulan", $bulan);
        return $this->db->get()->row()->grade;
    }

    public function getPersonalSkor($id_karyawan, $tahun, $bulan) {
        $this->db->select('skor_ttl ,aspek_kedisiplinan_skor, skor_predikat, remark');
        $this->db->from($this->table);
        $this->db->where("id_company",$this->id_company);
        $this->db->where("id_karyawan", $id_karyawan);
        $this->db->where("tahun", $tahun);
        $this->db->where("bulan", $bulan);
        $data = $this->db->get();
        if($data->num_rows() > 0) {
            return [
                'predikat'      => $data->row()->skor_predikat,
                'remark'        => $data->row()->remark,
                'disiplin'      => $data->row()->aspek_kedisiplinan_skor,
                'skor_ttl'      => $data->row()->skor_ttl,
            ];
        } else {
            return [
                'disiplin'      => "0.00",
                'predikat'      => "0.00",
                'skor_ttl'      => "0.00",
                'remark'        => "D"
            ];
        }
    }

    public function getBobotDisiplin() {
        $this->db->select('bobot');
        $this->db->from('kpi_aspek_m');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('aspek', 'Aspek Kedisiplinan');
        return $this->db->get()->row()->bobot;
    }

    public function getBobotKinerja($id_karyawan, $tahun, $bulan, $id_jabatan) {
        $total = $this->count_all($id_karyawan, $tahun, $bulan);
        if($total == 0) {
            $this->db->select('bobot_aspek_kinerja');
            $this->db->from('kpi_aspek_bobot_p');
            $this->db->where('id_company', $this->id_company);
            $this->db->where('id_jabatan', $id_jabatan);
            return $this->db->get()->row()->bobot_aspek_kinerja;
        } else {
            $this->db->select('aspek_kinerja_bobot');
            $this->db->from($this->table);
            $this->db->where("id_company",$this->id_company);
            $this->db->where("id_karyawan", $id_karyawan);
            $this->db->where("tahun", $tahun);
            $this->db->where("bulan", $bulan);
            return $this->db->get()->row()->aspek_kinerja_bobot;
        }
    }

    public function getBobotPribadi($id_karyawan, $tahun, $bulan, $id_jabatan) {
        $total = $this->count_all($id_karyawan, $tahun, $bulan);
        if($total == 0) {
            $this->db->select('bobot_aspek_kedisiplinan');
            $this->db->from('kpi_aspek_bobot_p');
            $this->db->where('id_company', $this->id_company);
            $this->db->where('id_jabatan', $id_jabatan);
            return $this->db->get()->row()->bobot_aspek_kedisiplinan;
        } else {
            $this->db->select('aspek_kepribadian_bobot');
            $this->db->from($this->table);
            $this->db->where("id_company",$this->id_company);
            $this->db->where("id_karyawan", $id_karyawan);
            $this->db->where("tahun", $tahun);
            $this->db->where("bulan", $bulan);
            return $this->db->get()->row()->aspek_kepribadian_bobot;
        }
    }

}