<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Group_area extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/master/Group_area_m');
    }

    public function list_data(){
        $list = $this->Group_area_m->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            
            // $row[] = $no;
            $row[] = '<span class="sort" style="cursor:-webkit-grab; cursor:grab;" title="Tarik keatas / kebawah" data-key="' . $field->id_group_m . '">
                        <i class="fa fa-sort"></i>&nbsp&nbsp'. $no.
                    '</span>';

            $row[] = htmlspecialchars($field->kode);
            $row[] = htmlspecialchars($field->nama);

            $btn_edit = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_group_m) . '" class="btn_edit fa fa-edit (alias)" onclick="edit(this)"> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="' . $this->lang->line('hapus') . '"><i id="' . md5($field->id_group_m) . '" class="btn_delete fa fa-trash" onclick="hapus_form(this)"></i></a>';
            $row[] = $btn_edit. '&nbsp'. $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Group_area_m->count_all(),
            "recordsFiltered" => $this->Group_area_m->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null){
        $data = [];
        if($id != null){
			$data['data'] = $this->Group_area_m->getDataById($id);
		}
		$this->load->view('sales_activity/master/group_area/form',$data);
    }

    public function save(){
        $id = $this->input->post('id_group_m');

        $data = array(
            'kode'       => $this->input->post('kode'),
            'nama'       => $this->input->post('nama'),
            'id_company' => $this->id_company
        );

        $this->Group_area_m->save($data, $id);
    }

    public function delete(){
        $id = $this->input->post("id");
        $this->Group_area_m->delete($id);
    }

    public function update_order(){
        $order = $this->input->post('order');

        $data = array();
        foreach ($order as $key) {
            $data[] = [
                'concat(id_group_m,id_company)' => $key['id_group_m'] . $this->id_company,
                'no_urut' => $key['no_urut']
            ];
        }

        $this->Group_area_m->update_order($data);
    }
}