<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Aspek_kepribadian extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('kpi/user/approval/aspek_kepribadian_m', 'model');
        $this->load->helper('kpi/kpi');
    }

    public function index() {
        $this->load->view('kpi/user/approval/detail/table/aspek_kepribadian');
    }

    public function list_data()
    {
        $this->load->model('kpi/user/team/detail_m');
        $this->load->model('karyawan_m');

        $dataTrx = $this->detail_m->getDataTrx()->row();
        if($this->model->count_all() == 0) {
            $idJabatan = $this->karyawan_m->getDataById(md5(htmlentities($this->input->get('karyawan'))))->id_jabatan;
            $list      = $this->model->getMaster($idJabatan)->result();
        } else {
            $list  = $this->model->get_datatables();
        }
        $data  = array();
        $no    = $_GET['start'];
        $indek = 0;
		foreach ($list as $field) {
			$no++;
			$row = array();

			$row[] = $no;
			$row[] = $field->personal_aspek;
			$row[] = $field->keterangan;
			$row[] = $field->bobot."%";
			$row[] = $field->poin_1;
			$row[] = $field->poin_2;
			$row[] = $field->poin_3;
			$row[] = $field->poin_4;
			$row[] = $field->poin_5;
            if($this->model->count_all() == 0) {
                $id                          = 'id_aspek_kepribadian_m';
                $field->actual_poin_approval = "0";
            } else {
                $id = 'id_aspek_kepribadian';
            }
			$row[] = actual($field, $indek, $dataTrx, $this->id_karyawan, $id);
            $row[] = $this->rating($field, $indek, $dataTrx);

			$data[] = $row;
            $indek++;
		}

		$output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all(),
            "recordsFiltered" => $this->model->count_filtered(),
            "data"            => $data
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
    }

    private function rating($data, $indek, $dataTrx) {
        $value = $data->actual_poin_approval == "0" ? "-" : number_format(($data->bobot/100)*$data->actual_poin_approval, 2, '.', ',');
        if(isPeriodeApv() and $this->id_karyawan == $dataTrx->id_atasan and in_array($dataTrx->status, ['1', '8'])) {
            return form_input(["name" => "skor[$indek]", "type" => "text", "class" => "form-control-plaintext text-center", "readonly" => "readonly"], $value);
        } else {
            return $value;
        }
    }

    public function save() {
        $this->load->model('kpi/user/approval/home_m');
        $this->load->model('kpi/user/approval/aspek_kepribadian_m');
        $this->load->model('kpi/user/approval/nilai_individu_m');
        $this->load->model('karyawan_m');
        $this->load->helper('generateid');
     
        $cek  = $this->aspek_kepribadian_m->count_all();
        if($cek == 0) {
            $idJabatan = $this->karyawan_m->getDataById(md5(htmlentities($this->input->post('karyawan'))))->id_jabatan;
            $this->db->trans_start();
            $this->aspek_kepribadian_m->insertKepribadian($idJabatan);
            $this->nilai_individu_m->insertSkorTemporary('Aspek Kepribadian');        
            $this->db->trans_complete();
        } else {
            $data = $this->aspek_kepribadian_m->data();
            $this->db->trans_start();
            $this->home_m->setDraftApproval();
            $this->db->update_batch('kpi_aspek_kepribadian_trx', $data, 'id_aspek_kepribadian');
            $this->nilai_individu_m->insertSkorTemporary('Aspek Kepribadian');        
            $this->db->trans_complete();
        }
        __response_save($this->db->trans_status());
    }
}