<script type="text/javascript">
    $(function() {
        // DATATABLE
        list_data = $('#list_data').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Kode/Nama'
                <?php else : ?> 'searchPlaceholder': 'Code/Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('sales_activity.master.group-area.list.data') ?>",
                "type": "GET",
                "data"  : function (d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({'text-align': 'center', 'width': '30px'});
                $('td:eq(3)', nRow).css({'text-align': 'center', 'width': '10px'});
            }
        });

        // ORDERING NUMBER
        $('#list_data').sortable({
            items: "tr",
            cursor: "move",
            handle: "span.sort",
            placeholder: "ui-state-highlight",
            update: function() {
                var order = [];
                $('#list_data tbody tr').each(function(index, element) {
                    order.push({
                        id_group_m: $(this).find("td:eq(0) span").data("key"),
                        no_urut: index + 1
                    });
                });
                // console.log(order);
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "<?= route("sales_activity.master.group-area.order") ?>",
                    data: {
                        order: order,
                    },
                    success: function(response) {
                        if (response.status == "success") {
                            // console.log(response);
                        } else {
                            // console.log(response);
                        }
                    }
                });
            }
        });
    });

    // START CRUD
    function tambah(e){
        $('#tampil_form').load("<?= route("sales_activity.master.group-area.form.tambah") ?>", function() {
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
            $(".btn_save").append('<i class="fa fa-save"></i> ');
            $(".btn_save").append("<?= $this->lang->line('button_form_simpan') ?>");
            $(".btn_save").addClass("btn_save btn btn-primary");
            $('.btn_save').attr('onClick','simpan(this)');
            $("#btn_new_input").hide();
        });
    }

    function edit(e){
        $('#tampil_form').load("<?= route('sales_activity.master.group-area.form.edit') ?>"+ "/" + $(e).attr('id'), function() {
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
            $(".btn_save").append('<i class="fa fa-update"></i> ');
            $(".btn_save").append("<?= $this->lang->line('button_form_perbarui') ?>");
            $(".btn_save").removeClass("btn_save").addClass("btn_update btn btn-warning");
            $('.btn_update').attr('onClick','simpan(this)');
            $("#btn_new_input").hide();
        });
    }

    function hapus_form(e){
        $('#tampil_form').load("<?= route('sales_activity.master.group-area.form.hapus') ?>"+ "/" + $(e).attr('id'), function() {
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
            $("#form_input input[type=text]").prop("disabled", true);
            $(".btn_save").append('<i class="fa fa-trash"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_hapus') ?>');
            $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            $('.btn_hapus').attr('onClick','hapus_action(this)');
        });
    }

    function new_input(e){
        $("#form_input :input").prop("disabled", false);
        $("#form_input input[type=text]").val('');
        $('.btn_save').show();
        $('#btn_new_input').hide();
        $('#message').html('');
    }

    function simpan(e){
        $('#message').html("");
        var loading = Ladda.create(e);

        if ($("#form_input #kode").val() == '') {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_kode_group_area') ?></font>");
            $("#form_input #kode").focus();
            return false;
        }else if ($("#form_input #nama").val() == '') {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_group_area') ?></font>");
            $("#form_input #nama").focus();
            return false;
        }

        loading.start();

        var param            = {};
            param.id_group_m = $("#form_input #id_group_m").val();
            param.kode       = $("#form_input #kode").val();
            param.nama       = $("#form_input #nama").val();

        $.ajax({
            type: 'POST',
            url: "<?= route('sales_activity.master.group-area.save') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                if (result.success == true) {
                    if (result.type == 'save') {
                        $("#form_input :input").prop("disabled", true);
                        $('.btn_save').hide();
                        $('#btn_new_input').show();
                    }
                }
                loading.stop();
                $('#message').show();
                $('#message').html(result.message);
            },
            error: function() {
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }

    function hapus_action(e){
        var loading = Ladda.create(e);
        loading.start();

        var param    = {};
            param.id = $("#id_group_m").val();

        $.ajax({
            type: 'POST',
            url: "<?= route('sales_activity.master.group-area.delete') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                loading.stop();
                if(result.success == true){
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message.replace("009900", "FFFFFF"));
                }else{
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                }
            },
            error: function() {
                loading.stop();
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }
    // END CRUD
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Master <?= $this->lang->line('group_area') ?></h5>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <button type="button" class="btn btn_tambah btn-success pull-right" onclick="tambah(this)">
            <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
        </button>
    </div>
</div> 
<hr>

<div class="table-responsive mt-2">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle" width="20">NO</th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('kode_group_area') ?></th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('nama_group_area') ?></th>
                <th class="text-center align-middle text-uppercase" width="50"><?= $this->lang->line('aksi') ?></th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>