<script type="text/javascript">
    $(function() {
        if ("<?= $pipeline->kategori_pelanggan ?>" === "perusahaan") {
            $("#form_kanban h6:eq(1)").html("Data Perusahaan");
            $("#select_pelanggan label").html('Nama Perusahaan<i class="text-danger">*</i>');
            $("#jenis_perusahaan label").html('Jenis Perorangan<i class="text-danger">*</i>');
            $("#form_kanban h6:eq(3)").html("Data PIC");
            $("#nama_pic").removeClass("hidden");
            $("#email_pic").removeClass("col-6");
            $("#telp_pic").removeClass("col-6");
            list_pelanggan();
            list_jenis_perusahaan("perusahaan");
        } else {
            $("#form_kanban h6:eq(1)").html("Data Personal");
            $("#select_pelanggan label").html('Nama<i class="text-danger">*</i>');
            $("#jenis_perusahaan label").html('Jenis Perorangan<i class="text-danger">*</i>');
            $("#form_kanban h6:eq(3)").html("Kontak");
            $("#nama_pic").addClass("hidden");
            $("#email_pic").addClass("col-6");
            $("#telp_pic").addClass("col-6");
            list_pelanggan("perorangan");
            list_jenis_perusahaan("perorangan");
        }

        list_lead_source();
        dropdown_provinsi();
        dropdown_kota();
        dropdown_kecamatan();
        dropdown_kelurahan();

        $('input[type="tel"]').on('input', function(e) {
            e.preventDefault();
            $(this).val($(this).val().replace(/[^0-9]/g, ''));
        });

        $('#alamat_perusahaan textarea').on('input', function(e) {
            e.preventDefault();
            $(this).val($(this).val().replace(/[^a-zA-Z0-9\/\.,\- \n]/g, ''));
            limit_char(this, 255);
        });

        $('#keterangan textarea').on('input', function(e) {
            e.preventDefault();
            limit_char(this, 255);
        });

        $('input[name="flag_jenis"]').on('change', function() {
            $("#message").html("");
            $("#select_pelanggan select").html("");

            if (this.checked) {
                $('input[name="flag_jenis"]').not(this).prop('checked', false);
            } else {
                $(this).prop('checked', true);
            }

            if (this.value == "perusahaan") {
                $("#form_kanban h6:eq(1)").html("Data Perusahaan");
                $("#select_pelanggan label").html('Nama Perusahaan<i class="text-danger">*</i>');
                $("#jenis_perusahaan label").html('Jenis Perusahaan<i class="text-danger">*</i>');
                $("#jenis_perusahaan select").val(null).trigger("change");
                $("#form_kanban h6:eq(3)").html("Data PIC");
                $("#nama_pic").removeClass("hidden");
                $("#email_pic").removeClass("col-6");
                $("#telp_pic").removeClass("col-6");
            } else {
                $("#form_kanban h6:eq(1)").html("Data Personal");
                $("#select_pelanggan label").html('Nama<i class="text-danger">*</i>');
                // $("#select_pelanggan select").val(null).trigger("change");
                $("#jenis_perusahaan label").html('Jenis Perorangan<i class="text-danger">*</i>');
                $("#jenis_perusahaan select").val(null).trigger("change");
                $("#form_kanban h6:eq(3)").html("Kontak");
                $("#nama_pic").addClass("hidden");
                $("#email_pic").addClass("col-6");
                $("#telp_pic").addClass("col-6");
            }

            // remove alert error
            error_form("select", $("#select_pelanggan"), "", false);
            error_form("select", $("#jenis_perusahaan"), "", false);
            error_form("input", $("#nama_pic"), "", false);

            // reset
            list_pelanggan(this.value);
            list_jenis_perusahaan(this.value);
            list_lead_source();
            dropdown_provinsi();
            dropdown_kota();
            dropdown_kecamatan();
            dropdown_kelurahan();
        });

        $("#btn_submit").on("click", function(e) {
            e.preventDefault();
            $("#message").html("");
            var loading = Ladda.create(this);

            var valid = form_validation_perusahaan();
            if (!valid) {
                return false;
            }

            loading.start();

            var param = {};
            param.id = "<?= $id ?>";
            param.jenis_pelanggan = $("#form_kanban input[type='checkbox']:checked").val();
            param.pelanggan = $("#select_pelanggan select").val();
            param.jenis_perusahaan = $("#jenis_perusahaan select").val();
            param.lead_source = $("#lead_source select").val();
            param.alamat_perusahaan = $("#alamat_perusahaan textarea").val();
            param.provinsi_perusahaan = $("#provinsi_perusahaan select").val();
            param.kota_perusahaan = $("#kota_perusahaan select").val();
            param.kecamatan_perusahaan = $("#kecamatan_perusahaan select").val();
            param.kelurahan_perusahaan = $("#kelurahan_perusahaan select").val();
            param.nama_pic = $("#nama_pic input").val();
            param.email_pic = $("#email_pic input").val();
            param.telp_pic = $("#telp_pic input").val();
            param.title = $("#title input").val();
            param.keterangan = $("#keterangan textarea").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('sales_activity.kanban.detail.update_perusahaan') ?>",
                data: param,
                dataType: 'JSON',
                beforeSend: function() {
                    disable_form("#form_kanban", ["input", "textarea", "select", "button"], true);
                },
                success: function(result) {
                    disable_form("#form_kanban", ["input", "textarea", "select", "button"], false);
                    if (result.success == true) {
                        var periode = get_periode();
                        $("#detail-perusahaan").load("<?= route('sales_activity.kanban.detail.perusahaan', ['id' => $id, 'periode' => '" + periode + "']) ?>");
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    disable_form("#form_kanban", ["input", "textarea", "select", "button"], false);
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
    });

    function limit_char(e, limit = 255) {
        var maxLength = limit;
        var text = $(e).val();
        if (text.length > maxLength) {
            $(e).val(text.substring(0, maxLength));
        }
    }

    function find_perusahaan(arr, searchId) {
        for (const item of arr) {
            if (item.id === searchId) {
                return item.perusahaan;
            }
        }
        return null;
    }

    function format_input(e, regex, max = null) {
        var value = e.value;
        if (!regex.test(value)) {
            e.value = value.slice(0, -1);
        }
        if (max != null) {
            if (value.length > max) {
                e.value = value.slice(0, -1);
            }
        }
    }

    function dropdown_provinsi() {
        $('#provinsi_perusahaan select').select2({
            placeholder: "<?= $this->lang->line('pilih_provinsi') ?>",
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("dropdown.provinsi")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('change', function() {
            $('#kota_perusahaan select').val(null).trigger("change");
            $('#kecamatan_perusahaan select').val(null).trigger("change");
            $('#kelurahan_perusahaan select').val(null).trigger("change");
            dropdown_kota();
        });
    }

    function dropdown_kota() {
        var prov = $("#provinsi_perusahaan select").val();

        $('#kota_perusahaan select').select2({
            placeholder: "<?= $this->lang->line('pilih_kota') ?>",
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("dropdown.kota", ["id_prov" => "'+ prov +'"]) ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('change', function() {
            $('#kecamatan_perusahaan select').val(null).trigger("change");
            $('#kelurahan_perusahaan select').val(null).trigger("change");
            dropdown_kecamatan();
        });
    }

    function dropdown_kecamatan() {
        var kota = $("#kota_perusahaan select").val();

        $('#kecamatan_perusahaan select').select2({
            placeholder: "<?= $this->lang->line('pilih_kecamatan') ?>",
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("dropdown.kecamatan", ["id_kota" => "'+ kota +'"]) ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('change', function() {
            $('#kelurahan_perusahaan select').val(null).trigger("change");
            dropdown_kelurahan();
        });
    }

    function dropdown_kelurahan(kecamatan = '-') {
        var kecamatan = $("#kecamatan_perusahaan select").val();

        $('#kelurahan_perusahaan select').select2({
            placeholder: "<?= $this->lang->line('pilih_kelurahan') ?>",
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("dropdown.kelurahan", ["id_kecamatan" => "'+ kecamatan +'"]) ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('change', function() {
            //
        });
    }

    function list_pelanggan(kategori = "perusahaan") {
        var list_pelanggan = [];
        $('#select_pelanggan select').select2({
            placeholder: (kategori == "perusahaan") ? "Pilih Perusahaan" : "Pilih",
            tags: true,
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("sales_activity.kanban.list_pelanggan", ["kategori" => "'+ kategori +'"]) ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    list_pelanggan = data;
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('change', function(e) {
            const perusahaan = find_perusahaan(list_pelanggan, e.target.value);

            // assign value
            if (perusahaan) {
                var $option = "";

                var optionExists = $("#jenis_perusahaan select option[value='" + perusahaan.id_jenis_perusahaan + "']").length > 0;
                if (optionExists) {
                    $("#jenis_perusahaan select").val(perusahaan.id_jenis_perusahaan).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.jenis_perusahaan + "</option>").val(perusahaan.id_jenis_perusahaan);
                    $("#jenis_perusahaan select").append($option).trigger("change");
                }

                var optionExists = $("#lead_source select option[value='" + perusahaan.id_lead_source + "']").length > 0;
                if (optionExists) {
                    $("#lead_source select").val(perusahaan.id_lead_source).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.lead_source + "</option>").val(perusahaan.id_lead_source);
                    $("#lead_source select").append($option).trigger("change");
                }

                $("#alamat_perusahaan textarea").val(perusahaan.alamat);

                var optionExists = $("#provinsi_perusahaan select option[value='" + perusahaan.id_provinsi + "']").length > 0;
                if (optionExists) {
                    $("#provinsi_perusahaan select").val(perusahaan.id_provinsi).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.provinsi + "</option>").val(perusahaan.id_provinsi);
                    $("#provinsi_perusahaan select").append($option).trigger("change");
                }

                var optionExists = $("#kota_perusahaan select option[value='" + perusahaan.id_kota + "']").length > 0;
                if (optionExists) {
                    $("#kota_perusahaan select").val(perusahaan.id_kota).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.kota + "</option>").val(perusahaan.id_kota);
                    $("#kota_perusahaan select").append($option).trigger("change");
                }

                var optionExists = $("#kecamatan_perusahaan select option[value='" + perusahaan.id_kecamatan + "']").length > 0;
                if (optionExists) {
                    $("#kecamatan_perusahaan select").val(perusahaan.id_kecamatan).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.kecamatan + "</option>").val(perusahaan.id_kecamatan);
                    $("#kecamatan_perusahaan select").append($option).trigger("change");
                }

                var optionExists = $("#kelurahan_perusahaan select option[value='" + perusahaan.id_kelurahan + "']").length > 0;
                if (optionExists) {
                    $("#kelurahan_perusahaan select").val(perusahaan.id_kelurahan).trigger("change");
                } else {
                    $option = $("<option>" + perusahaan.kelurahan + "</option>").val(perusahaan.id_kelurahan);
                    $("#kelurahan_perusahaan select").append($option).trigger("change");
                }

                $("#nama_pic input").val(perusahaan.pic_nama);
                $("#email_pic input").val(perusahaan.pic_email);
                $("#telp_pic input").val(perusahaan.pic_telp);
            }
        })
    }

    function list_jenis_perusahaan(flag_jenis="perusahaan") {
        $('#jenis_perusahaan select').select2({
            placeholder: 'Pilih Jenis' + (flag_jenis == "perusahaan" ? " Perusahaan" : " Perorangan"),
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("sales_activity.kanban.list_jenis_perusahaan") ?>' + '?flag_jenis=' + flag_jenis,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('select2:select', function() {
            $('#lead_source select').val(null).trigger("change");
        });
    }

    function list_lead_source() {
        $('#lead_source select').select2({
            placeholder: 'Pilih Lead Source',
            allowClear: true,
            dropdownParent: $("#form_kanban"),
            ajax: {
                url: '<?= route("sales_activity.kanban.list_lead_source") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).on('select2:select', function() {
            $("#alamat_perusahaan input").focus();
        });
    }


    function form_validation_perusahaan() {
        let result = true;
        let selector_scroll = "";

        const jenis_pelanggan = $("#form_kanban input[type='checkbox']:checked").val();
        if (!jenis_pelanggan) {
            $("#message").html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jenis_pelanggan_kosong') ?></font>");
            result = false;
        }

        if (jenis_pelanggan == "perusahaan") {
            if (!$("#select_pelanggan select").val()) {
                let target = $("#select_pelanggan");
                error_form("select", target, "<?= $this->lang->line('error_pilih_perusahaan_kosong') ?>", true);
                if (selector_scroll === "") {
                    selector_scroll = "#select_pelanggan select";
                }
                result = false;
            } else {
                let target = $("#select_pelanggan");
                error_form("select", target, "", false);
            }

            if (!$("#jenis_perusahaan select").val()) {
                let target = $("#jenis_perusahaan");
                error_form("select", target, "<?= $this->lang->line('error_pilih_jenis_perusahaan_kosong') ?>", true);
                if (selector_scroll === "") {
                    selector_scroll = "#jenis_perusahaan select";
                }
                result = false;
            } else {
                let target = $("#jenis_perusahaan");
                error_form("select", target, "", false);
            }

            if ($("#nama_pic input").val() == "") {
                let target = $("#nama_pic");
                error_form("input", target, "<?= $this->lang->line('error_nama_kosong') ?>", true);
                if (selector_scroll === "") {
                    selector_scroll = "#nama_pic input";
                }
                result = false;
            } else {
                let target = $("#nama_pic");
                error_form("input", target, "", false);
            }
        } else {
            if (!$("#select_pelanggan select").val()) {
                let target = $("#select_pelanggan");
                error_form("select", target, "<?= $this->lang->line('error_nama_kosong') ?>", true);
                if (selector_scroll === "") {
                    selector_scroll = "#select_pelanggan select";
                }
                result = false;
            } else {
                let target = $("#select_pelanggan");
                error_form("select", target, "", false);
            }
        }

        if (!$("#lead_source select").val()) {
            let target = $("#lead_source");
            error_form("select", target, "<?= $this->lang->line('error_pilih_lead_source_kosong') ?>", true);
            if (selector_scroll === "") {
                selector_scroll = "#lead_source select";
            }
            result = false;
        } else {
            let target = $("#lead_source");
            error_form("select", target, "", false);
        }

        if ($("#alamat_perusahaan input").val() == "") {
            let target = $("#alamat_perusahaan");
            error_form("input", target, "<?= $this->lang->line('error_alamat_kosong') ?>", true);
            if (selector_scroll === "") {
                selector_scroll = "#alamat_perusahaan input";
            }
            result = false;
        } else {
            let target = $("#alamat_perusahaan");
            error_form("input", target, "", false);
        }

        if (!$("#provinsi_perusahaan select").val()) {
            let target = $("#provinsi_perusahaan");
            error_form("select", target, "<?= $this->lang->line('error_provinsi') ?>", true);
            if (selector_scroll === "") {
                selector_scroll = "#provinsi_perusahaan select";
            }
            result = false;
        } else {
            let target = $("#provinsi_perusahaan");
            error_form("select", target, "", false);
        }

        if (!$("#kota_perusahaan select").val()) {
            let target = $("#kota_perusahaan");
            error_form("select", target, "<?= $this->lang->line('error_kota') ?>", true);
            if (selector_scroll === "") {
                selector_scroll = "#kota_perusahaan select";
            }
            result = false;
        } else {
            let target = $("#kota_perusahaan");
            error_form("select", target, "", false);
        }

        if ($("#telp_pic input").val() == "") {
            let target = $("#telp_pic");
            error_form("input", target, "<?= $this->lang->line('error_telp_kosong') ?>", true);
            if (selector_scroll === "") {
                selector_scroll = "#telp_pic input";
            }
            result = false;
        } else {
            let target = $("#telp_pic");
            error_form("input", target, "", false);
        }

        if ($("#title input").val() == "") {
            let target = $("#title");
            error_form("input", target, "<?= $this->lang->line('error_judul') ?>", true);
            if (selector_scroll === "") {
                selector_scroll = "#title input";
            }
            result = false;
        } else {
            let target = $("#title");
            error_form("input", target, "", false);
        }

        if (selector_scroll !== "") {
            scrollToElementWithOffset(selector_scroll, -30);
        }
        return result;
    }

    function error_form(form, element, message = '', error) {
        let target = element;
        if (form === "input") {
            if (error === true) {
                target.find(form).css("border", "1px solid red");
                target.find("p").html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> " + message + "</font>");
                target.find("p").show();
            } else {
                target.find(form).removeAttr("style");
                target.find("p").html("").hide();
            }
            return false;
        }
        if (form === "select") {
            if (error === true) {
                target.find(".select2-selection").css("border", "1px solid red");
                target.find("p").html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> " + message + "</font>");
                target.find("p").show();
            } else {
                target.find(".select2-selection").removeAttr("style");
                target.find("p").html("").hide();
            }
            return false;
        }
    }

    function scrollToElementWithOffset(selector, offset) {
        const element = document.querySelector(selector);
        if (element) {
            element.scrollIntoView();
            setTimeout(() => {
                const modalContent = document.querySelector('#modal_form');
                const newScrollPosition = modalContent.scrollTop + offset;
                modalContent.scrollTo({
                    top: newScrollPosition,
                    behavior: 'smooth'
                });
            }, 250);
        }
    }
</script>
<style>
    #form_kanban.card-body {
        color: grey;
        font-size: 12px;
    }

    #form_kanban .text-biru {
        color: #1c77d4;
    }

    .select2-hidden-accessible {
        position: fixed !important;
    }
</style>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="form_kanban" class="card-body" disabled>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold text-biru">Data Calon Customer</h6>
        <hr>
        <label>Jenis Pelanggan</label>
        <div class="row">
            <div class="form-check">
                <input id="kategori_perusahaan" class="form-check-input" type="checkbox" style="border-radius: 50%;" name="flag_jenis" value="perusahaan" <?= ($pipeline->kategori_pelanggan == 'perusahaan') ? 'checked' : '' ?>>
                <label class="form-check-label text-secondary" for="kategori_perusahaan" style="font-size: 12px;">
                    Perusahaan
                </label>
            </div>
            <div class="form-check">
                <input id="kategori_perorangan" class="form-check-input" type="checkbox" style="border-radius: 50%;" name="flag_jenis" value="perorangan" <?= ($pipeline->kategori_pelanggan == 'perorangan') ? 'checked' : '' ?>>
                <label class="form-check-label text-secondary" for="kategori_perorangan" style="font-size: 12px;">
                    Perorangan
                </label>
            </div>
        </div>
    </div>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold text-biru">Data Perusahaan</h6>
        <hr>
        <div class="row">
            <div id="select_pelanggan" class="col-12 mb-1">
                <label for="select_pelanggan">Nama Perusahaan<i class="text-danger">*</i></label>
                <select class="select2 form-control" style="width: 100%">
                    <option value="<?= $pipeline->id_pelanggan ?>"><?= $pipeline->nama_perusahaan ?></option>
                </select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="jenis_perusahaan" class="col-6">
                <label for="jenis_perusahaan">Jenis Perusahaan<i class="text-danger">*</i></label>
                <select class="select2 form-control" style="width: 100%">
                    <option value="<?= $pipeline->id_jenis_perusahaan ?>"><?= $pipeline->jenis_perusahaan ?></option>
                </select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="lead_source" class="col-6">
                <label for="lead_source">Lead Source<i class="text-danger">*</i></label>
                <select class="select2 form-control" style="width: 100%">
                    <option value="<?= $pipeline->id_lead_source ?>"><?= $pipeline->lead_source ?></option>
                </select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
        </div>
    </div>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold text-biru"><?= $this->lang->line('alamat') ?></h6>
        <hr>
        <div class="row">
            <div id="alamat_perusahaan" class="col-12 mb-1">
                <label for="alamat_perusahaan"><?= $this->lang->line('alamat') ?><i class="text-danger">*</i></label>
                <textarea class="form-control" rows="3" placeholder="<?= $this->lang->line('alamat') ?>" autocomplete="off"><?= $pipeline->alamat ?></textarea>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="provinsi_perusahaan" class="col-6 mb-1">
                <label for="provinsi_perusahaan"><?= $this->lang->line('provinsi') ?><i class="text-danger">*</i></label>
                <select class="select2 form-control" style="width: 100%">
                    <option value="<?= $pipeline->id_provinsi ?>"><?= $pipeline->provinsi ?></option>
                </select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="kota_perusahaan" class="col-6 mb-1">
                <label for="kota_perusahaan"><?= $this->lang->line('kota') ?><i class="text-danger">*</i></label>
                <select class="select2 form-control" style="width: 100%">
                    <option value="<?= $pipeline->id_kota ?>"><?= $pipeline->kota ?></option>
                </select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="kecamatan_perusahaan" class="col-6">
                <label for="kecamatan_perusahaan"><?= $this->lang->line('kecamatan') ?></label>
                <select class="select2 form-control" style="width: 100%">
                    <option value="<?= $pipeline->id_kecamatan ?>"><?= $pipeline->kecamatan ?></option>
                </select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="kelurahan_perusahaan" class="col-6">
                <label for="kelurahan_perusahaan"><?= $this->lang->line('kelurahan') ?></label>
                <select class="select2 form-control" style="width: 100%">
                    <option value="<?= $pipeline->id_kelurahan ?>"><?= $pipeline->kelurahan ?></option>
                </select>
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
        </div>
    </div>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold text-biru">Data PIC</h6>
        <hr>
        <div class="row">
            <div id="nama_pic" class="col-4">
                <label for="nama_pic"><?= $this->lang->line('nama') ?><i class="text-danger">*</i></label>
                <input type="text" value="<?= $pipeline->pic_nama ?>" oninput="format_input(this, /^[a-zA-Z0-9\.\,\-\' ]*$/)" class="form-control" placeholder="<?= $this->lang->line('nama') ?>" autocomplete="off">
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="email_pic" class="col-4">
                <label for="email_pic"><?= $this->lang->line('email') ?></label>
                <input type="email" value="<?= $pipeline->pic_email ?>" class="form-control" placeholder="<?= $this->lang->line('email') ?>" autocomplete="off">
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
            <div id="telp_pic" class="col-4">
                <label for="telp_pic"><?= $this->lang->line('no_telp') ?><i class="text-danger">*</i></label>
                <input type="tel" value="<?= $pipeline->pic_telp ?>" class="form-control" placeholder="<?= $this->lang->line('no_telp') ?>" autocomplete="off">
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
        </div>
    </div>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold text-biru">Deskripsi</h6>
        <hr>
        <div class="row mb-1">
            <div id="title" class="col-12">
                <label for="title">Judul<i class="text-danger">*</i></label>
                <input type="text" value="<?= $pipeline->title ?>" class="form-control" autocomplete="off">
                <p class="mt-1 mb-0 text-left" style="display: none;font-size: 11px;"></p>
            </div>
        </div>
        <div class="row">
            <div id="keterangan" class="col-12">
                <label for="keterangan"><?= $this->lang->line('keterangan') ?></label>
                <textarea class="form-control" rows="5"><?= $pipeline->keterangan ?></textarea>
            </div>
        </div>
    </div>
</div>

<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_submit" class="btn btn-warning ladda-button" data-style="expand-left">
                <i class='fa fa-edit'></i> <?= $this->lang->line('button_form_perbarui') ?>
            </button>
        </div>
    </div>
</div>
