<script type="text/javascript">
    $(function() {
        view_data($("#filter #bulan").val());

        $("#filter #bulan").inputmask({
            'alias': 'datetime',
            'inputFormat': 'mm-yyyy'
        });
        $("#filter #bulan").datepicker({
            format: "mm-yyyy",
            viewMode: "months",
            orientation: 'bottom',
            minViewMode: "months",
            autoclose: true,
            endDate: "today"
        });

        $('#modal-nominal').on('show.bs.modal', function(event) {
            $('#message').hide();

            let button = $(event.relatedTarget);
            let item = button.data('item');
            let komponen = button.data('komponen');
            let nm_komponen = button.data('nm_komponen');
            let nominal = button.data('nominal');
            let modal = $(this);

            modal.find(".modal-title").text('Ubah nominal ' + komponen);
            modal.find('.card-body label').text(nm_komponen);
            modal.find('#item').val(item);
            modal.find('#komponen').val(komponen);
            modal.find('#nominal_pendapatan').val(nominal);
            modal.find('#nominal_pendapatan').focus();

            $("#nominal_pendapatan").keydown(function(event) {
                if (event.which == 13) {
                    event.preventDefault();
                    $('.btn_save').click();
                }
            });
        })

        $(document).on('click', '.btn_save', function(e) {
            e.preventDefault();

            var loading = Ladda.create(this);
            loading.start();

            var param = {};
            param.item = $("#item").val();
            param.komponen = $("#komponen").val();
            param.nominal = ($("#nominal_pendapatan").val() != "") ? $("#nominal_pendapatan").val() : 0;

            $.ajax({
                type: 'POST',
                url: "<?= route('payroll.data.komponen.tdk.tetap.update') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
    });

    function formatangka(objek) {
        a = objek.value;
        b = a.replace(/[^\d]/g, "");
        c = "";
        panjang = b.length;
        j = 0;
        for (i = panjang; i > 0; i--) {
            j = j + 1;
            if (((j % 3) == 1) && (j != 1)) {
                c = b.substr(i - 1, 1) + "." + c;
            } else {
                c = b.substr(i - 1, 1) + c;
            }
        }
        objek.value = c;
    }

    function view_data(bulan) {
        $("#listdata").load("<?= route('payroll.data.komponen.tdk.tetap.viewdata', ['bulan' => '"+bulan+"', 'id_karyawan' => 'all', 'id_cabang' => 'all', 'id_departemen' => 'all']) ?>");
    }
</script>

<!-- BEGIN FILTER DATA -->
<script type="text/javascript">
    $(document).ready(function() {
        dropdown_cabang();

        $('#filter #id_karyawan').select2({
            placeholder: 'Semua Karyawan',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.karyawan.encrypt") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $('#filter #btn_cari').click(function() {
            let loading = Ladda.create(this);
            loading.start();
            let bulan = ($("#filter #bulan").val()) ? $("#filter #bulan").val() : "<?= date('m-Y') ?>";
            let id_cabang = "all";
            let id_departemen = "all";
            let id_karyawan = ($("#filter #id_karyawan").val()) ? $("#filter #id_karyawan").val() : "all";
            $("#listdata").load("<?= route('payroll.data.komponen.tdk.tetap.viewdata', ['bulan' => '"+bulan+"', 'id_karyawan' => '"+id_karyawan+"', 'id_cabang' => '"+id_cabang+"', 'id_departemen' => '"+id_departemen+"']) ?>");
            loading.stop();
        });

        $('#filter #btn_filter').click(function() {
            let loading = Ladda.create(this);
            loading.start();

            let bulan = ($("#filter #bulan").val()) ? $("#filter #bulan").val() : "<?= date('m-Y') ?>";
            let id_cabang = (!$("#filter #cabang").val()) ? "all" : $("#filter #cabang").val();
            let id_departemen = (!$("#filter #departemen").val()) ? "all" : $("#filter #departemen").val();
            let id_karyawan = "all";
            $("#listdata").load("<?= route('payroll.data.komponen.tdk.tetap.viewdata', ['bulan' => '"+bulan+"', 'id_karyawan' => '"+id_karyawan+"', 'id_cabang' => '"+encodeURIComponent(id_cabang)+"', 'id_departemen' => '"+encodeURIComponent(id_departemen)+"']) ?>");
            loading.stop();
        });
    });

    function dropdown_cabang() {
        $('#filter #cabang').select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                url: '<?= route("payroll.data.komponen.tdk.tetap.dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        }).change(function() {
            $("#filter #departemen").val('').trigger('change');
            dropdown_departemen();
        });
    }

    function dropdown_departemen() {

        var id_cabang = ($("#filter #cabang").val() == null) ? "all" : $("#filter #cabang").val();

        $("#filter #departemen").select2({
            placeholder: "Semua Departemen",
            allowClear: true,
            ajax: {
                url: '<?= route("payroll.data.komponen.tdk.tetap.dropdown.departemen") ?>/' + encodeURIComponent(id_cabang),
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }
</script>
<!-- END FILTER DATA -->

<div class="content-header mt-4">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Payroll</a></li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= route('payroll.data.komponen.tdk.tetap.import.home') ?>" class="btn-import btn btn-success">
                    <i class="fa fa-upload"></i> Import Data Komponen
                </a>
            </div>
        </div>
    </div>
    <hr>
    <div id="filter">
        <div class="row">
            <div class="col-md-8">
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="align-self-center">BULAN</label>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <input type="text" id="bulan" class="form-control" autocomplete="off" placeholder="mm-yyyy" spellcheck="false" value="<?= date('m-Y') ?>">
                        </div>
                    </div>
                </div>
                <div class="row mt-1">
                    <div class="col-md-2">
                        <label>NAMA KARYAWAN</label>
                    </div>
                    <div class="col-md-8">
                        <select id="id_karyawan" class="form-control"></select>
                    </div>
                    <div class="col-md-2">
                        <button type="button" id="btn_cari" class="ladda-button btn btn-primary col-md-12" data-style="expand-left">CARI</button>
                    </div>
                </div>

                <div class="row mt-1">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>CABANG</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select id="cabang" class="form-control">
                            <option></option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label>DEPARTEMEN</label>
                    </div>
                    <div class="col-md-3">
                        <select class="form-control" id="departemen"></select>
                    </div>
                    <div class="col-md-2">
                        <button type="button" id="btn_filter" class="ladda-button btn btn-primary col-md-12" data-style="expand-left">FILTER</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div id="listdata" class="table-responsive">
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div class="modal fade" id="modal-nominal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-body">
                <input id="item" type="hidden" disabled>
                <input id="komponen" type="hidden" disabled>
                <div class="form-group">
                    <label>Nominal</label>
                    <input type="text" id="nominal_pendapatan" class="form-control" onkeyup="formatangka(this);">
                </div>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_save ladda-button btn btn-primary" data-style="expand-left"><i class="fa fa-save"></i> SIMPAN</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
