<style>
    .error {
        color: red;
        font-size: 11px;
    }
</style>
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-10">
                <h4 class="text-primary">KPI Saya</h4>
            </div>
            <div class="col-md-2 text-right">
                <a href="#" class="btn btn-secondary btn_kembali_saya" style="font-family: Poppins Medium; padding: 10px 30px;"><i class="fa fa-arrow-left"></i>&nbsp;&nbsp;Kembail</a>
            </div>
        </div>
        <hr>
        <div class="row mb-3">
            <div class="col-md-2">
                <span>Periode</span>
                <h6 style="font-family: 'Poppins Bold';"><?= $data['periode'] ?></h6>
            </div>
            <div class="col-md-2">
                <h6 style="font-family: 'Poppins Bold';"><?= $data['data_karyawan']->nama_lengkap ?></h6>
                <span><?= $data['data_karyawan']->nik ?></span>
            </div>
            <div class="col-md-2">
                <span>Jabatan</span>
                <h6 style="font-family: 'Poppins Bold';"><?= $data['data_karyawan']->nama_jabatan ?></h6>
            </div>
            <?php if(!$data['terima']) : ?>
            <div id="div_ajukan" class="col-md-6 text-right"></div>
            <?php endif; ?>
        </div>
        <input type="hidden" id="karyawan" name="karyawan" value="<?= $data['data_karyawan']->id_karyawan ?>">
        <input type="hidden" id="tahun" name="tahun" value="<?= $data['tahun'] ?>">
        <input type="hidden" id="bulan" name="bulan" value="<?= $data['bulan'] ?>">
        <?php if($data['terima']) { ?>
            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a class="nav-link px-2 text-dark" id="aspek_kinerja" onclick="aspek_kinerja()" href="#">Aspek Kinerja</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link px-2 text-dark" id="aspek_kepribadian" onclick="aspek_kepribadian()" href="#">Kompetensi</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link px-2 text-dark" id="aspek_kedisiplinan" onclick="aspek_kedisiplinan()" href="#">Aspek Kedisiplinan</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link px-2 text-dark" id="nilai_individu" onclick="nilai_individu()" href="#">Nilai Individu</a>
                </li>
            </ul>
            <div id="div_table" class="pt-2"></div>
        <?php } else { ?>
        <form>
        <table class="table table-striped table-bordered">
            <thead style="font-family: Poppins SemiBold;">
                <tr>
                    <th class="align-middle" rowspan=2>Obyektif</th>
                    <th class="align-middle" rowspan=2>Performa Indikator</th>
                    <th width=75 rowspan=2 class="_center align-middle">Target</th>
                    <th width=75 rowspan=2 class="_center align-middle">Bobot</th>
                    <th class="align-middle" colspan=5>Skoring</th>
                    <th class="_center align-middle" width=100 rowspan=2>Aktual</th>
                    <th class="align-middle" width=100 rowspan=2>Keterangan</th>
                </tr>
                <tr>
                    <th width=100 class="_center">1</th>
                    <th width=100 class="_center">2</th>
                    <th width=100 class="_center">3</th>
                    <th width=100 class="_center">4</th>
                    <th width=100 class="_center">5</th>
                </tr>
            </thead>
            <tbody></tbody>
            <tfoot>
                <tr height=50>
                    <th class="align-middle text-center" colspan=3 style="font-family: 'Poppins Bold';">Total</th>
                    <th class="align-middle" style="font-family: 'Poppins Bold';">0%</th>
                    <th colspan=7></th>
                </tr>
            </tfoot>
        </table>
        <div class="row mt-2">
            <div id="message" class="col-md-9"></div>
            <div id="div_draft" class="col-md-3 text-right"></div>
        </div>
        </form>
        <?php } ?>
    </div>
</div>
<script>
    function aspek_kinerja() {
        $('#myTabContent .nav-link').removeClass("active text-primary");
        $('#myTabContent #aspek_kinerja').addClass("active text-primary");
        $('#div_table').load("<?= route('kpi.approval.detail.aspek-kinerja') ?>");
    }
    
    function aspek_kepribadian() {
        $('#myTabContent .nav-link').removeClass("active text-primary");
        $('#myTabContent #aspek_kepribadian').addClass("active text-primary");
        $('#div_table').load("<?= route('kpi.approval.detail.aspek-kepribadian') ?>");
    }

    function aspek_kedisiplinan() {
        $('#myTabContent .nav-link').removeClass("active text-primary");
        $('#myTabContent #aspek_kedisiplinan').addClass("active text-primary");
        $('#div_table').load("<?= route('kpi.approval.detail.aspek-kedisiplinan') ?>");
    }

    function nilai_individu() {
        $('#myTabContent .nav-link').removeClass("active text-primary");
        $('#myTabContent #nilai_individu').addClass("active text-primary");
        $('#div_table').load("<?= route('kpi.approval.detail.nilai-individu') ?>", () => {
            <?php if($data['terima']) : ?>
            $('div#div_setujui').attr('id', 'div_ajukan');
            button('ajukan');
            <?php endif; ?>
        });
    }

    $(function() {
        <?php if($data['terima']) { ?>
            aspek_kinerja();
        <?php } else { ?>
        list_data = $('table').DataTable({
            searching: false,
            ordering : false,
            paging   : false,
            info     : false,
            scrollX  : true,
            scrollY  : true,
            language : {
                url: '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>'
            },
            columnDefs: [
                { targets: '_center', className: "text-center" },
            ],
            processing: true,
            serverSide: true,
            ajax      : {
                url : '<?= route("kpi.saya.detail.list-data") ?>',
                data: function(d) {
                    delete d.columns;
                    delete d.search;
                    
                    d.karyawan = $('#karyawan').val();
                    d.tahun    = $('#tahun').val();
                    d.bulan    = $('#bulan').val();
                }
            },
            footerCallback: function(row, data) {
                var total = 0;
                data.forEach((item) => total = total + parseInt(item[3].replace("%", "")));
                this.api().column(3).footer().innerHTML = total+"%";
            }
        });
        <?php } ?>
        button('ajukan');
        button('draft');

        $.validator.addMethod("selectKpi", function(value) {
            return value != "0";
        }, "aktual KPI belum dipilih");
    });

    // save draft
    $('form').submit(function(event) {
        $('#message').html('');
        event.preventDefault();

        const l = Ladda.create(document.querySelector('#simpan'));
        const data = $('form').serialize()+"&karyawan="+$('#karyawan').val()+"&tahun="+$('#tahun').val()+"&bulan="+$('#bulan').val();
        l.start();
        $.post('<?= route("kpi.saya.detail.save") ?>', data, function(result) {
            l.stop();
            $('.card-body #message').html(result.message);
            button('draft');
        }, 'json');
    });

    function ajukan() {
        $('#tampil_form').load('<?= route("kpi.saya.detail.form") ?>', function() {
            $('.title').text("Apakah anda ingin mengajukan KPI tersebut?");
            $('#tampil_form button.btn-primary').addClass("btn_ajukan");
            $('#modal_form').modal('show');
        });
    }

    $(document).on('click', '.btn_ajukan', function() {
        $('#tampil_form #message, .card-body #message').html('');
        const l = Ladda.create(this);
        l.start();

        const data = $('form').serialize()+"&karyawan="+$('#karyawan').val()+"&tahun="+$('#tahun').val()+"&bulan="+$('#bulan').val();

        var   rules = {};
        const total = $("select[name^='actual']").length;
        for(i = 0; i < total; i++) {
            rules["actual["+i+"]"] = {selectKpi: true};
        }
        
        $('form').validate({
            rules: rules
        });

        if($('form').valid()) {
            $.post('<?= route("kpi.saya.detail.ajukan") ?>', data, function(result) {
            l.stop();
            if(result.success) {
                $('.title').html(result.message);
                $(this).prop('disabled', true);
                $('#tampil_form div.card-footer').hide();
                $('#tampil_form .title font').attr('color', '#ffffff');

                button('draft');
                button('ajukan');
            } else {
                $('#tampil_form #message').html(result.message);
            }
        }, 'json');
        } else {
            l.stop();
            $('#tampil_form #message').html('<span class="text-danger"><i class="fa fa-exclamation-triangle"></i> actual KPI belum diisi</span>');
        }
    });

    function button(jenis)
    {
        const karyawan = $('#karyawan').val();
        const tahun    = $('#tahun').val();
        const bulan    = $('#bulan').val();
        $('#div_'+jenis).load('<?= route("kpi.saya.detail.button", ['tahun' => "'+tahun+'", 'bulan' => "'+bulan+'", 'karyawan' => "'+karyawan+'", 'jenis' => "'+jenis+'"]) ?>');
    }

    function terimaKpi() {
        $('#tampil_form').load('<?= route("kpi.saya.detail.form-terima") ?>', function() {
            $('#modal_form').modal('show');
        });
    }

    $(document).on('click', '#terima', function() {
        $('#tampil_form #message').html('');

        const keterangan = $('#keterangan').val();
        if(keterangan == '') {
            $('#tampil_form #message').html('<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i> keterangan belum diisi</font>');
            return false;
        }

        const l = Ladda.create(document.querySelector('#terima'));
        l.start();

        const data = "keterangan="+$('#keterangan').val()+"&karyawan="+$('#karyawan').val()+"&tahun="+$('#tahun').val()+"&bulan="+$('#bulan').val();
        $.post('<?= route("kpi.saya.detail.terima") ?>', data, function(result) {
            l.stop();
            $('#tampil_form #message').html(result.message);
            if(result.success) {
                button('ajukan');
                $('#keterangan, #terima').prop('disabled', true);
            }
        }, 'json');
    })
</script>