<style>
    /* Required Drawer CSS */
    .js-menu__context {
        /* background: rgba(0, 0, 0, 0.5); */
        left: 0;
        opacity: 0;
        position: absolute;
        top: 0;
        transition: opacity 0.5s, visibility 0.5s;
        visibility: hidden;
        width: 100%;
        height: 100%;
        border-radius: 0 15px 15px 0;
        z-index: 99;
    }

    .js-menu {
        color: #000;
        height: 100%;
        width: 100%;
        padding: 20px;
        margin: 0;
        background: #fff;
        overflow-y: auto;
        border-radius: 0 15px 15px 0;

        -webkit-overflow-scrolling: touch;
        -ms-overflow-style: -ms-autohiding-scrollbar;
        transition: background 0.5s, transform 0.5s;
    }

    .js-menu--left {
        -webkit-transform: translateX(-100%);
        transform: translateX(-100%);
    }

    .js-menu--right {
        -webkit-transform: translateX(100%);
        transform: translateX(100%);
        position: absolute;
        right: 0;
    }

    .js-menu__open {
        cursor: pointer;
    }

    .js-menu__close {
        cursor: pointer;
    }

    .js-menu__expanded {
        -webkit-transform: translateX(0);
        transform: translateX(0);
        visibility: visible;
        opacity: 1;
    }
</style>

<script>
    $(function () {
        dropdown_periode();
        dropdown_karyawan();

        // START FILTER
        $("#btn_filter").on("click", function () {
            var loading = Ladda.create(this);
            loading.start();
            list_data_home.ajax.reload(function () {
                loading.stop();
            });
        });

        // START DATATABLE
        list_data_home = $('#list_data').DataTable({
            ordering: true,
            searching: false,
            scrollX: true,
            language: {
                url: '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>'
            },
            order: [],
            layout: {
                topEnd: [
                    $("#data-actions")
                ]
            },
            columnDefs: [
                { targets: 'no_sort', orderable: false },
                { targets: '_center', className: 'text-center' }
            ],
            ajax: {
                url: '<?= route("kpi.laporan.list-data") ?>',
                data: function (d) {
                    delete d.columns;
                    delete d.search;

                    const waktu = $('#periode').datepicker('getDate');

                    d.karyawan = $('#id_karyawan').val();
                    d.tahun = waktu.getFullYear();
                    d.bulan = waktu.getMonth() + 1;
                }
            }
        });

        // START JS DRAWER
        $('.js-menu__open').on('touchend click', function () {
            var menu = $(this).attr('data-menu');

            $(menu).toggleClass('js-menu__expanded');
            $(menu).parent().toggleClass('js-menu__expanded');
        });

        $('.js-menu__context, .js-menu__close').on('touchend click', function (event) {
            if ($(event.target).hasClass('js-menu__context') || $(event.target).hasClass('js-menu__close')) {
                $('.js-menu__expanded').removeClass('js-menu__expanded');
                $(".div_pembungkus_js_menu_context").css('height', "0px");
            }
        });
    });

    function test_slide(e) {
        var menu = $(e).attr('data-menu');
        $(menu).toggleClass('js-menu__expanded');
        $(menu).parent().toggleClass('js-menu__expanded');

        var id_laporan = $(e).attr('id');
        set_detail_active("laporan", id_laporan);
        load_url = "<?= route('kpi.laporan.detail.view.detail') ?>" + "/" + id_laporan;
        return $.get(load_url, function (data) {
            $("#drawer-content").html(data);
        });
    }

    function dropdown_periode() {
        $('#periode').datepicker({
            format: "MM yyyy",
            minViewMode: 1,
            autoclose: true,
            orientation: "bottom",
            language: "id"
        });
        $('#periode').datepicker('setDate', new Date());
    }

    function dropdown_karyawan() {
        var waktu = $('#periode').datepicker('getDate');
        var tahun = waktu.getFullYear();
        var bulan = waktu.getMonth() + 1;
        if (bulan.toString().length == 1) {
            bulan = "0" + bulan.toString();
        }

        $('#id_karyawan').select2({
            placeholder: 'Pilih Karyawan',
            allowClear: true,
            ajax: {
                url: '<?= route("kpi.laporan.dropdown.karyawan") ?>' + '?tahun=' + tahun + '&bulan=' + bulan,
                dataType: 'json',
                processResults: function (data) {
                    return {
                        results: data
                    };
                }
            }
        });
    }

    function download_semua() {
        var waktu = $('#periode').datepicker('getDate');
        var tahun = waktu.getFullYear();
        var bulan = waktu.getMonth() + 1;
        if (bulan.toString().length == 1) {
            bulan = "0" + bulan.toString();
        }
        window.open('<?= route("kpi.laporan.download-all", ["periode" => "'+tahun+'-'+bulan+'"]) ?>', '_blank').focus();
    }
</script>

<div class="div_pembungkus_js_menu_context">
    <div class="js-menu__context">
        <div id="drawer" class="js-menu js-menu--right">
            <div id="drawer-content"></div>
        </div>
    </div>
</div>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Laporan Data KPI</h5>
    </div>
</div>
<hr>

<div class="filter mt-2">
    <div class="row">
        <div class="col-md-1 align-self-center">
            <label class="font-weight-bold">Periode</label>
        </div>
        <div class="col-md-4">
            <input type="text" name="periode" id="periode" class="form-control">
        </div>
    </div>

    <div class="row mt-2">
        <div class="col-md-1 align-self-center">
            <label class="font-weight-bold">Karyawan</label>
        </div>
        <div class="col-md-4">
            <select class="form-control" id="id_karyawan" style="width: 100%"></select>
        </div>
        <div class="col-md-1">
            <button type="button" id="btn_filter" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
        </div>
    </div>
</div>

<div class="table-responsive mt-2">
    <div id="data-actions" class="pull-right">
        <button id="download" type="button" class="btn btn-primary ladda-button" data-style="expand-left" onclick="download_semua();">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh_all') ?>
        </button>
    </div>

    <table id="list_data" class="table table-striped table-bordered mt-2" width=100%>
        <thead>
            <tr style="font-family: Poppins SemiBold;">
                <th class="no_sort align-middle">No.</th>
                <th class="align-middle">Karyawan</th>
                <th class="align-middle">Jabatan</th>
                <th class="no_sort _center align-middle">Tanggal Pengajuan</th>
                <th class="no_sort _center align-middle">Status</th>
                <th class="_center align-middle">Skor</th>
                <th class="no_sort _center align-middle">Aksi</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
</div>