<?php
defined('BASEPATH') OR exit('No direct script access allowed');
	use Endroid\QrCode\Builder\Builder;
	use Endroid\QrCode\Encoding\Encoding;
	use Endroid\QrCode\ErrorCorrectionLevel\ErrorCorrectionLevelLow;
	use Endroid\QrCode\Label\Label;
	use Endroid\QrCode\QrCode;
	use Endroid\QrCode\Writer\PngWriter;
	use Endroid\QrCode\Color\Color;
	use Endroid\QrCode\Logo\Logo;

class Master_qrcode extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('patroli/Master_qrcode_m');
    }

	public function index(){
		$data['judul']   = 'Master QR Code';
		$this->load->view('patroli/masterqrcode/home', $data);
	}

	public function list_data(){
		$list = $this->Master_qrcode_m->get_datatables();
		$data = array();
		$no = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();

			$foto = $this->config->item('base_image').'image?_t=photo&_d='.$field->path;

			$row[] = $no;
			$row[] = $field->kode_cabang. ' - '.$field->nama_cabang;
			$row[] = $field->nm_lokasi;
			$row[] = '	<a data-toggle="modal" data-target="#exampleModal" data-urlimg="'.$foto.'" href="javascript:;">
                            <img class="media-object img-fit-cover" src="'.$foto.'" alt="QRCODE" >
                        </a>';

            if(in_array($this->level_user, array("1"))) {

				$row[] = '
						<a href="#" class="text-danger" title="HAPUS">
							<i id="'.md5($field->id).'" class="btn_delete fa fa-trash" onclick="delete_masterqr(this)"></i>
						</a>';
			}
	
			$data[] = $row;
		}
	
			$output = array("draw"            => $_GET['draw'],
							"recordsTotal"    => $this->Master_qrcode_m->count_all(),
							"recordsFiltered" => $this->Master_qrcode_m->count_filtered(),
							"data"            => $data);
	
		$output = __response($this->MY_response, $output);
				
		echo json_encode($output);
	}

	public function form($id=null){
		if($id==null){
			$this->load->view('patroli/masterqrcode/form');
		}else{
			$data['data'] = $this->Master_qrcode_m->getDataById($id);
			$this->load->view('patroli/masterqrcode/form',$data);
		}
		
	}

	public function save(){

		$id        = $this->input->post('id_master_cp');
		$id_cabang = $this->input->post('id_cabang');
		$lokasi    = $this->input->post('nm_lokasi');

		$data_qrcode = array('key' => $this->id_company.$id_cabang,
							'nm_lokasi' => $lokasi);

		$json = json_encode($data_qrcode);
		// echo "<pre>" . $json . "<pre/>"; 
		// exit;

	    // start QR Code
		$qrCode = Builder::create()
		    ->writer(new PngWriter()) // Format output (PNG, SVG, dll)
		    ->data($json) // Data QR Code
		    ->encoding(new Encoding('UTF-8')) // Encoding
		    ->errorCorrectionLevel(new ErrorCorrectionLevelLow()) // Koreksi error
		    ->size(300) // Ukuran QR Code
		    ->margin(10) // Margin QR Code
			->labelText(strtoupper($lokasi))
			->labelTextColor(new Color(28, 119, 212))
		    ->build();

		// Simpan ke file
		$filename = date("Ymdhis").'.png';
		$folder   = $this->config->item('base_upload').'/'.$this->id_company.'/patroli/qrcode';
		if(!file_exists($folder)) {
			mkdir($folder, 0755, true);
		}
		$qrCode->saveToFile($folder.'/'.$filename);
		//end qrcode
	
		$data = array(
					'id_cabang'  => $id_cabang,
					'nm_lokasi'  => $lokasi,
					'path'       => $this->id_company.'/patroli/qrcode/'.$filename,
					'id_company' => $this->id_company
				);

		// dd($data);

		$this->Master_qrcode_m->save($data,$id); 
	}

	public function delete(){
		$id = $this->input->post("id_master_cp");
		$data = $this->Master_qrcode_m->getDataById($id);
		// hapus qrcode
		if(file_exists($data->path)) {
			unlink($data->path);
		}
		$this->Master_qrcode_m->delete($id);
	}

}