<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Laporan_sos extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Laporan_sos_m');
    }

	public function index(){
        $data['judul']            = $this->lang->line('laporan_sos');
        $data['aktif']            = 'laporan_sos';
        $data['tgl_mulai']        = "01-".date("m-Y");
        $data['tgl_selesai']      = date("d-m-Y");
        $data['level_user']       = $this->level_user;
        $data['multi_cabang']     = $this->multi_cabang;
        $data['multi_departemen'] = $this->multi_departemen;
        $data['menu']             = $this->load->view('main_menu', $data, true);
        $data['content']          = $this->load->view('laporan_sos/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

    public function data_tabel($tgl_mulai=0, $tgl_selesai=0, $id_karyawan=0, $id_cabang=0, $id_departemen=0){
        $data['tgl_mulai']      = $tgl_mulai;
        $data['tgl_selesai']    = $tgl_selesai;
        $data['id_karyawan']    = $id_karyawan;
        $data['id_cabang']      = $id_cabang;
        $data['id_departemen']  = $id_departemen;
        $this->load->view('laporan_sos/data_tabel', $data, false);
    }

	public function list_data($tgl_mulai=0, $tgl_selesai=0, $id_karyawan=0, $id_cabang=0, $id_departemen=0){

        $tgl_mulai = date_format(date_create($tgl_mulai),"Y-m-d");
        $tgl_selesai = date_format(date_create($tgl_selesai),"Y-m-d");

		$list = $this->Laporan_sos_m->get_datatables($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen);
		$data = array();
		$no = $_GET['start'];

		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
            $row[] = date_format(date_create($field->tanggal),"d-m-Y");
            $row[] = $field->nama_lengkap."<br><span class='font-size-xsmall font-weight-bold'>".$field->nik."</span>";
			$row[] = $field->keterangan;

            if ($this->level_user == '1') {
                $row[] = '<a href="javascript:;" id="'.md5($field->id).'" class="btn_detail" title="DETAIL"><i class="fa fa-info-circle text-primary"></i></a>&nbsp;
                    <a href="#" class="text-danger" title="HAPUS">
                            <i id="'.md5($field->id).'" class="btn_delete fa fa-trash"></i>
                    </a>';
            }else{
                $row[] = '<a href="javascript:;" id="'.md5($field->id).'" class="btn_detail" title="DETAIL"><i class="fa fa-info-circle text-primary"></i></a>';
            }

			$data[] = $row;
		}

			$output = array("draw"            => $_GET['draw'],
							"recordsTotal"    => $this->Laporan_sos_m->count_all($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen),
							"recordsFiltered" => $this->Laporan_sos_m->count_filtered($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen),
							"data"            => $data);

        $output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function detail($id){
        $data['judul'] = 'Detail';
        $data['aktif'] = 'laporan_sos';

        $where = array('id_company' => $this->session->userdata('id_company'));
        $query = $this->db->select('id_company, nama')->get_where('master_company', $where)->row();
        $data['company'] = $query->nama;
        $data['id_company'] = $query->id_company;

        $coords = $this->db->select("sos_data.tanggal,
                                    sos_data.keterangan,
                                    data_karyawan.nik,
                                    data_karyawan.nama_lengkap,
                                    master_jabatan.nama AS nama_jabatan,
                                    master_cabang.nama AS nama_cabang,
                                    master_departemen.nama AS nama_departemen")
                            ->from("sos_data")
                            ->join("data_karyawan", "data_karyawan.id_karyawan = sos_data.id_karyawan", "left")
                            ->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan")
                            ->join("master_cabang", "master_cabang.id_cabang = data_karyawan.id_cabang")
                            ->join("master_departemen", "master_departemen.id_departemen = data_karyawan.id_departemen","left")
                            ->where("md5(id)", $id)
                            ->get()
                            ->row();
        $data['nama_karyawan'] = $coords->nik." - ".$coords->nama_lengkap;
        $data['jabatan']       = $coords->nama_jabatan.", ".$coords->nama_cabang.", ".$coords->nama_departemen;
        $data['tanggal']       = date_format(date_create($coords->tanggal),"d-m-Y");
        $data['keterangan']    = $coords->keterangan;
        echo json_encode($data);
    }

	function detail_foto($id) {
		$data_foto = $this->db->where('md5(id_sos)', $id)->get('sos_file')->result();
		foreach($data_foto as $row) {
			$data[] = $this->config->item('base_image').'/image?_t=image&_d='.$row->file;
		}
		echo json_encode($data);
	}


    public function download_excel($tgl_mulai=0, $tgl_selesai=0, $id_karyawan=0, $id_cabang=0, $id_departemen=0){

        $data["tgl_mulai"] = $tgl_mulai;
        $data["tgl_selesai"] = $tgl_selesai;

        if($id_karyawan == "0" && $id_cabang == "0" && $id_departemen == "0"){
            $filename = $this->lang->line('laporan_sos') . " " . $this->lang->line('semua_cabang');
        }else{
            $filename = $this->lang->line('laporan_sos');
        }

        if($id_karyawan != "0"){
            $nama_karyawan = $this->db->select("nama_lengkap")
                                    ->from("data_karyawan")
                                    ->where("id_karyawan",$id_karyawan)
                                    ->where("id_company",$this->id_company)
                                    ->get()
                                    ->row("nama_lengkap");
            $filename .= " ".$nama_karyawan;
        }

        if($id_cabang != "0"){
            $nama_cabang = $this->db->select("nama")
                                    ->from("master_cabang")
                                    ->where("id_cabang",$id_cabang)
                                    ->where("id_company",$this->id_company)
                                    ->get()
                                    ->row("nama");

            $filename .= $this->lang->line('cabang')." ".$nama_cabang;
        }

        if($id_departemen != "0"){
            $nama_departemen = $this->db->select("nama")
                                    ->from("master_departemen")
                                    ->where("id_departemen",$id_departemen)
                                    ->where("id_company",$this->id_company)
                                    ->get()
                                    ->row("nama");

            $filename .= $this->lang->line('departemen')." ".$nama_departemen;
        }
        $data['is_excel'] = true;
        $data["title"] = strtoupper($filename);
        $data['tanggal_mulai'] 		= $tgl_mulai;
		$data['tanggal_selesai'] 	= $tgl_selesai;

        $tgl_mulai      = date('Y-m-d', strtotime($tgl_mulai));
		$tgl_selesai   = date('Y-m-d', strtotime($tgl_selesai));
        $data["data"] = $this->Laporan_sos_m->download($tgl_mulai, $tgl_selesai, $id_karyawan, $id_cabang, $id_departemen);

        $sb_view = $this->load->view('laporan_sos/download_excel', $data, true);

        // echo $sb_view;
        // die();

        $c_length = 6;
        $param = [
            'download'    => true,
            'cLength'     => $c_length,
            'file_name'   => strtoupper($filename),
            'paper_size'  => 'A4',
            'font-size'   => 9,
            'pagebreak'   => true,
            'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation' => 'potrait',
            'header'      => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],

                '4' => ['weight' => 'bold'],
                '5' => ['weight' => 'bold'],
                '6' => ['weight' => 'bold'],
            ],
            'thead' => ['7'],
            'tbody' => [
                'start'        => '7',
                'height'       => 15,
                'jarak_footer' => 2,
                'wrap'         => ['B','C', 'D','E','F','G'],
                'column'       => [
                    'A'    => ['width' => 3, 'align' => 'center', 'valign' => 'middle'],
                    'B'    => ['width' => 21, 'align' => 'center', 'valign' => 'middle'],
                    'C'    => ['width' => 20, 'align' => 'center', 'valign' => 'middle'],
                    'D'    => ['width' => 20,'align' => 'left', 'valign' => 'top'],
                    'E'    => ['width' => 20,'align' => 'left', 'valign' => 'top'],
                    'F'    => ['width' => 11,'align' => 'left', 'valign' => 'top'],
                    'G'    => ['width' => 11,'align' => 'left', 'valign' => 'top'],
                ],
            ],
        ];

        $this->load->library('PHPExcel/Excel');
        $this->excel->generateExcel($sb_view, $param);
    }

    public function delete(){
        $id = $this->input->post("id");
        $this->Laporan_sos_m->delete($id);
    }
}
