<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Kepegawaian extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Db_model', 'db_model');
        $this->load->model('Kepegawaian_m', 'kepegawaian');
    }

    public function index()
    {
        $data['judul']             = $this->lang->line('menu_kepegawaian');
        $data['aktif']             = 'kepegawaian';
        $data['status_karyawan']   = $this->kepegawaian->getStatusKaryawan();
        $data['pendidikan']        = $this->kepegawaian->getDataPendidikan();
        $data['data_karyawan']     = $this->kepegawaian->get_datatables();
        if ($this->level_user == '1') {
            $data['notif_kepegawaian'] = $this->notif_kepegawaian();
        }
        $data['menu']              = $this->load->view('main_menu', $data, true);
        $data['content']           = $this->load->view('kepegawaian/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    private function notif_kepegawaian()
    {
        $data = $this->kepegawaian->getDataNotifKepegawaian();
        foreach ($data as $row) {
            $temp = explode(',', $row->menu);
            $value_menu_baru = [];
            foreach ($temp as $menu) {
                $value_menu_baru[$menu] = $this->url_pengajuan($menu, $row->id_karyawan_pengajuan);
            }
            $row->menu = $value_menu_baru;
        }
        return $data;
    }

    function kepegawaian_count()
    {
        $total_kontrak_habis = $this->kepegawaian->count_kontrak_habis();
        if ($this->level_user == 1) {
            $total_pengajuan_approval = $this->kepegawaian->totalNotifKepegawaian();
            echo $total_kontrak_habis + $total_pengajuan_approval;
        } elseif ($this->level_user == 4) {
            echo $total_kontrak_habis;
        }
    }

    function data_kepegawaian($id_cabang = 0)
    {
        $status_karyawan =  $this->kepegawaian->getStatusKaryawan($id_cabang);
        echo json_encode($status_karyawan);
    }

    public function data_pendidikan($id_cabang = 0)
    {
        $data_pendidikan =  $this->kepegawaian->getDataPendidikan($id_cabang);
        echo json_encode($data_pendidikan);
    }

    public function daftar_kontrak()
    {
        $data['judul']   = $this->lang->line('daftar_karyawan_kontrak');
        $data['aktif']   = 'kepegawaian';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('kepegawaian/daftar_kontrak', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data()
    {
        $list = $this->kepegawaian->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap . '<br>' . $field->nik;
            $row[] = $field->kode_cabang . ' - ' . $field->nama_cabang;
            $row[] = $field->kode_departemen . ' - ' . $field->nama_departemen;
            $row[] = $field->kode_jabatan . ' - ' . $field->nama_jabatan;
            $row[] = $this->fungsi->format_date_strip($field->tgl_aktif_bekerja);
            $row[] = $this->fungsi->format_date_strip($field->tgl_berhenti_bekerja);
            if ($field->jml_hari < 0) {
                $row[] = '<div class="badge badge-danger" style="color: white;">' . $this->lang->line('kontrak_sudah_berakhir') . '</div>';
            } else {
                $row[] = $field->jml_hari . ' ' . $this->lang->line('hari_lagi');
            }
            $row[] = '<a href="' . site_url('master/karyawan/detail') . '/' . md5($field->id_karyawan) . '" class="text-info" title="DETAIL">
                            <i id="' . md5($field->id_karyawan) . '" class="fa fa-info-circle"> </i></a>';

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->kepegawaian->count_all(),
            "recordsFiltered" => $this->kepegawaian->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    function download()
    {
        $file_name      = $this->lang->line('filename_pegawai_kontrak');
        $data['title']  = $file_name;
        $data['data']   = $this->kepegawaian->get_datatables();
        $output         = true;
        $sb_view        = $this->load->view('kepegawaian/download', $data, $output);

        $param = [
            'download'      => true,
            'cLength'       => 8,
            'file_name'     => $file_name,
            'paper_size'    => 'LEGAL',
            'font-size'        => 9,
            // 'pagebreak'		=> true,
            'page_margin'    => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'    => 'landscape',
            'header'        => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
            ],
            // 'freezecolumn'  => ['O6'],
            'thead'         => ['3'],
            'tbody'         => [
                'start' => '3',
                'height'    => 13,
                'wrap' => ['B', 'C'],
                'column' => [
                    'A'    => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
                    'B'    => ['width' => 10, 'align' => 'center', 'valign' => 'middle'],
                    'C'    => ['width' => 40],
                    'G'    => ['align' => 'center'],
                    'H'    => ['align' => 'center'],
                    'I'    => ['align' => 'center'],
                ],
            ],
        ];

        if ($output) {
            $this->load->library('PHPExcel/Excel');
            $this->excel->generateExcel($sb_view, $param);
        }
    }

    private function url_pengajuan($menu, $id_karyawan)
    {
        if ($menu == 'data_keluarga') {
            return route('master.karyawan.keluarga.pengajuan.home', ['id_karyawan_md5' => md5($id_karyawan)]);
        } elseif ($menu == 'data_diri') {
            return route('master.karyawan.datadiri.pengajuan.home', ['id_karyawan_md5' => md5($id_karyawan)]);
        } elseif ($menu == 'data_pendidikan') {
            return route('master.karyawan.pendidikan.pengajuan.home', ['id_karyawan_md5' => md5($id_karyawan)]);
        } elseif ($menu == 'pengalaman_kerja') {
            return route('master.karyawan.pengalamankerja.pengajuan.home', ['id_karyawan_md5' => md5($id_karyawan)]);
        } elseif ($menu == 'sertifikat') {
            return route('master.karyawan.sertifikat.pengajuan.home', ['id_karyawan_md5' => md5($id_karyawan)]);
        } elseif ($menu == 'kelengkapan') {
            return route('master.karyawan.kelengkapanfile.pengajuan.home', ['id_karyawan_md5' => md5($id_karyawan)]);
        } else {
            return '';
        }
    }

    public function main_data_status_pegawai($jenis = "", $id_cabang = "all")
    {
        $title = "Karyawan Status " . $this->lang->line($jenis);

        if($jenis == 'kontrak'){
            $status = '1';
        }else{
            $status = '2';
        }

        $data["title"]  = $title;
        $data["url"]  = route('dashboard.kepegawaian.detail.list.data.status.pegawai') . "/" . $status . "/". $id_cabang;
        $this->load->view('kepegawaian/form_detail_status_pegawai', $data);
    }

    public function list_data_status_pegawai($jenis = "", $id_cabang = "")
    { 
        $list = $this->kepegawaian->get_datatables_tabs_pengguna_aktif($jenis, $id_cabang);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $foto = $this->config->item('base_image') . 'image?_t=photo&_d=' . $field->foto;
            $row[] = $no;
            $row[] = '<a href="'.$foto.'" data-lightbox="mulai-'.$no.'"><img src="'.$foto.'" width="100px" height="100px"></a>';
            $row[] = $field->nama_lengkap. "<br><b>" .$field->nik."</b>";
            $row[] = $field->kode_cabang . "<br><b>" . $field->nama_cabang."</b>";
            $row[] = isset($field->nama_departemen) ? $field->kode_departemen . "<br><b>" . $field->nama_departemen."</b>" : "-";
            $row[] = $field->kode_jabatan . "<br><b>" . $field->nama_jabatan."</b>";
            $row[] = $this->jenis_kelamin($field->jenis_kelamin);

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->kepegawaian->count_all_tabs_pengguna_aktif($jenis, $id_cabang),
            "recordsFiltered" => $this->kepegawaian->count_filtered_tabs_pengguna_aktif($jenis, $id_cabang),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function main_data_pendidikan($pendidikan, $id_cabang = "all")
    {

        if($pendidikan == "sd"){
            $jenis = 'SD/MI';
        }else if($pendidikan == "smp"){
            $jenis = 'SMP/MTS';
        }else if($pendidikan == "sma"){
            $jenis = 'SMA/SMK';
        }else if($pendidikan == "d3"){
            $jenis = 'D3';
        }else if($pendidikan == "d4"){
            $jenis = 'D4';
        }else if($pendidikan == "s1"){
            $jenis = 'S1';
        }else if($pendidikan == "s2"){
            $jenis = 'S2';
        }else if($pendidikan == "s3"){
            $jenis = 'S3';
        }else{
            $jenis = 'Tidak Diketahui';
        }

        if ($pendidikan == '' || $pendidikan == 'tidak_diketahui') {
            $title = "Pendidikan Belum Diatur";
        }else{
            $title = "Pendidikan " . $jenis;
        }


        $data["title"]  = $title;
        $data["url"]  = route('dashboard.kepegawaian.detail.list.data.pendidikan') . "/" . $pendidikan . "/". $id_cabang;
        $this->load->view('kepegawaian/form_detail_pendidikan', $data);
    }

    public function list_data_pendidikan($pendidikan, $id_cabang)
    {
        if($pendidikan == "sd"){
            $jenis = 'SD';
        }else if($pendidikan == "smp"){
            $jenis = 'SMP';
        }else if($pendidikan == "sma"){
            $jenis = 'SMA';
        }else if($pendidikan == "d3"){
            $jenis = 'D3';
        }else if($pendidikan == "d4"){
            $jenis = 'D4';
        }else if($pendidikan == "s1"){
            $jenis = 'S1';
        }else if($pendidikan == "s2"){
            $jenis = 'S2';
        }else if($pendidikan == "s3"){
            $jenis = 'S3';
        }else{
            $jenis = '';
        }

        $list = $this->kepegawaian->get_datatables_tabs_pendidikan($jenis, $id_cabang);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $foto = $this->config->item('base_image') . 'image?_t=photo&_d=' . $field->foto;
            $row[] = $no;
            $row[] = '<a href="'.$foto.'" data-lightbox="mulai-'.$no.'"><img src="'.$foto.'" width="100px" height="100px"></a>';
            $row[] = $field->nama_lengkap. "<br><b>" .$field->nik."</b>";
            $row[] = $field->kode_cabang . "<br><b>" . $field->nama_cabang."</b>";
            $row[] = isset($field->nama_departemen) ? $field->kode_departemen . "<br><b>" . $field->nama_departemen."</b>" : "-";
            $row[] = $field->kode_jabatan . "<br><b>" . $field->nama_jabatan."</b>";
            $row[] = $this->jenis_kelamin($field->jenis_kelamin);
            $row[] = $field->pendidikan_terakhir;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->kepegawaian->count_all_tabs_pendidikan($jenis, $id_cabang),
            "recordsFiltered" => $this->kepegawaian->count_filtered_tabs_pendidikan($jenis, $id_cabang),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    private function jenis_kelamin($jenis)
    {
        if ($jenis == 'L') {
            return $this->lang->line('laki_laki');
        } elseif ($jenis == 'P') {
            return $this->lang->line('perempuan');
        } else {
            return $this->lang->line('belum_diatur');
        }
    }
}
