<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="form_input_m_product" class="card-body" disabled>
    <input type="hidden" id="id_product_m" class="form-control" value="<?= ((isset($data)) ? md5($data->id_product_m) : '') ?>">

    <div class="form-group">
        <label><?= $this->lang->line('pilih_group_product'); ?> <span class="text-danger">*</span></label>
        <select class="form-control" id="id_product_group_m" style="width: 100%">
            <?php echo '<option value="' . $data->id_product_group_m . '" selected>' . $data->kode_g_product . ' - ' . $data->nama_g_product . '</option>' ?>;
        </select>
    </div>

    <div class="form-group">
        <label><?= $this->lang->line('kode_product') ?> <span class="text-danger">*</span></label>
        <input type="text" id="kode_product" class="form-control" value="<?= ((isset($data->kode_product)) ? $data->kode_product : '') ?>">
    </div>

    <div class="form-group">
        <label><?= $this->lang->line('nama_product') ?> <span class="text-danger">*</span></label>
        <input type="text" id="nama_product" class="form-control" value="<?= ((isset($data->nama_product)) ? $data->nama_product : '') ?>">
    </div>

    <div class="form-group">
        <label><?= $this->lang->line('harga_product') ?> <span class="text-danger">*</span></label>
        <input type="text" id="harga_product" class="form-control text-left" oninput="format_amount($(this))" value="<?= ((isset($data->harga_product)) ? number_format($data->harga_product,0,",",".") : '') ?>">
    </div>
</div>

<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input_m_product" class="btn" style="display:none"><?= $this->lang->line('button_form_tambah_baru') ?></button>
            <button class="btn_save_m_product ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>

<script>
    $(document).ready(function() {
        dropdown_group_product();
    });

    function dropdown_group_product(){
        $("#id_product_group_m").select2({
            placeholder: "<?= $this->lang->line('group_product'); ?>",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.master.dropdown.group.product") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }
</script>
