<script type="text/javascript">
    $(function() {
        list_data_m_aktivitas = $('#list_data_m_aktivitas').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama Kategori/Poin'
                <?php else : ?> 'searchPlaceholder': 'Category Name/Poin'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('sales_activity.master.aktivitas.list.data') ?>",
                "type": "GET",
                "data"  : function (d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({'text-align': 'center', 'width': '30px'});
                $('td:eq(2)', nRow).css({'text-align': 'center', 'width': '100px'});
                $('td:eq(3)', nRow).css({'text-align': 'center', 'width': '100px'});
                $('td:eq(4)', nRow).css({'text-align': 'center', 'width': '100px'});
                $('td:eq(5)', nRow).css({'text-align': 'center', 'width': '10px'});
            }
        });

        $('#list_data_m_aktivitas').sortable({
            items: "tr",
            cursor: "move",
            handle: "span.sort",
            placeholder: "ui-state-highlight",
            update: function() {
                var order = [];
                $('#list_data_m_aktivitas tbody tr').each(function(index, element) {
                    order.push({
                        id_activity_m: $(this).find("td:eq(0) span").data("key"),
                        no_urut: index + 1
                    });
                });
                // console.log(order);
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "<?= route("sales_activity.master.aktivitas.order") ?>",
                    data: {
                        order: order,
                    },
                    success: function(response) {
                        if (response.status == "success") {
                            console.log(response);
                        } else {
                            console.log(response);
                        }
                    }
                });
            }
        });
    });
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Master <?= $this->lang->line('aktivitas') ?></h5>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <button type="button" class="btn btn_tambah_m_aktivitas btn-success pull-right">
            <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
        </button>
    </div>
</div> 
<hr>

<div class="table-responsive mt-2">
    <table id="list_data_m_aktivitas" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle">NO</th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('nama_aktivitas') ?></th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('poin') ?></th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('lokasi') ?></th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('foto') ?></th>
                <th class="text-center align-middle text-uppercase" width="50"><?= $this->lang->line('aksi') ?></th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
