<?php
foreach ($keluarga as $key) {
    $data_sebelumnya = $this->data_keluarga_m->getDataById(md5($key->id_keluarga));
?>
    <div class="card card-rounded card-abu">
        <div class="card-header">
            <h4 class="card-title" id="heading-labels">
                <i class="fa fa-user-o"></i> <?= ucwords(keterangan_action($this->lang->line('data_keluarga'), $key->action)) . ' ' . $key->hub_keluarga ?>
            </h4>
        </div>
        <div class="card-body">
            <?= pengajuan($key->status_pengajuan, $key->ket_revisi) ?>
            <div class="row form-detail-karyawan">
                <div class="col-md-12">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('nama_lengkap') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->nama ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->nama, $key->nama, $key->action) ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('ttl') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->tempat_lahir ?>, <?= $this->fungsi->tgl_indo($key->tanggal_lahir) ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->tanggal_lahir, $key->tanggal_lahir, $key->action, 'tgl_indo') ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('nik') ?>
                        </label>
                        <p class="form-control-static">
                            <?= isset($key->nik) ? $key->nik : '-' ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->nik, $key->nik, $key->action, 'tgl_indo') ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('no_bpjs_kes') ?>
                        </label>
                        <p class="form-control-static">
                            <?= isset($key->no_bpjs) ? $key->no_bpjs : '-' ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->no_bpjs, $key->no_bpjs, $key->action) ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('no_telp') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->telepon ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->telepon, $key->telepon, $key->action) ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('jenis_kelamin') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $this->fungsi->jkel($key->jenis_kelamin) ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->jenis_kelamin, $key->jenis_kelamin, $key->action, 'jkel') ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('agama') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->agama ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->agama, $key->agama, $key->action) ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('pekerjaan') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->pekerjaan ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->pekerjaan, $key->pekerjaan, $key->action) ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('hubungan_keluarga') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->hub_keluarga ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->hub_keluarga, $key->hub_keluarga, $key->action) ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('tgl_perkawinan') ?>
                        </label>
                        <p class="form-control-static">
                            <?php
                            if ($key->tanggal_perkawinan != '0000-00-00') {
                                if ($this->code_lang == 'id') {
                                    $periode = $this->fungsi->tgl_indo($key->tanggal_perkawinan);
                                } else {
                                    $periode = date('d F Y', $key->tanggal_perkawinan);
                                }
                            } else {
                                $periode = "-";
                            }

                            echo $periode;
                            ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->tanggal_perkawinan, $key->tanggal_perkawinan, $key->action, 'tgl_indo') ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('pendidikan_terakhir') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->pendidikan_terakhir ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->pendidikan_terakhir, $key->pendidikan_terakhir, $key->action) ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            <?= $this->lang->line('status_perkawinan') ?>
                        </label>
                        <p class="form-control-static">
                            <?= $key->status_perkawinan ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->status_perkawinan, $key->status_perkawinan, $key->action) ?>
                    </fieldset>
                </div>
                <div class="col-md-4">
                    <fieldset class="form-group">
                        <label>
                            Status
                        </label>
                        <p class="form-control-static">
                            <?= $key->status ?>
                        </p>
                        <?= data_sebelumnya_update($data_sebelumnya->status, $key->status, $key->action) ?>
                    </fieldset>
                </div>
            </div>
        </div>
        <?php if (in_array($key->status_pengajuan, array('1', '4'))) { ?>
            <div class="card-footer">
                <div class="col-12">
                    <div class="row">
                        <div class="col-md-7 text-left">
                        </div>
                        <div class="col-md-5 text-right">
                            <?php if ($key->status_pengajuan == '1') { ?>
                                <button class="btn btn-success btn-min-width" onclick="form_approve('<?= $key->id_keluarga ?>');"><i class="fa fa-check"></i> <?= $this->lang->line('button_form_approve') ?></button>
                                <button class="btn btn-secondary btn-min-width" onclick="form_revisi('<?= $key->id_keluarga ?>');"><i class="fa fa-undo"></i> <?= $this->lang->line('button_form_revisi') ?></button>
                            <?php } else { ?>
                                <button class="btn btn-danger btn-min-width" onclick="form_hapus('<?= $key->id_keluarga ?>')" title="hapus"><i class="fa fa-trash"></i> <?= $this->lang->line('button_form_hapus') ?></button>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
<?php } ?>
