<?php

class Home_m extends CI_Model {

    function get_datatables($periode){
        $this->_get_datatables_query($periode);
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($periode){
        $this->_get_datatables_query($periode);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($periode){
        $tahun    = htmlentities($this->input->get('tahun'));
        $bulan    = htmlentities($this->input->get('bulan'));
        $karyawan = htmlentities($this->input->get('karyawan'));

        $this->db->select("kry.id_karyawan");
        $this->db->from('data_karyawan kry');
        if($periode['isPeriodeInput']) {
            $this->db->join('kpi_approver_p apv', "apv.id_karyawan = kry.id_karyawan and apv.id_atasan = '".$this->id_karyawan."'");
            $this->db->join('kpi_trx trx', "trx.id_karyawan = kry.id_karyawan and trx.tahun = $tahun and trx.bulan = $bulan", 'left');
        } else {
            $this->db->join('kpi_trx trx', "trx.id_karyawan = kry.id_karyawan and trx.id_atasan = '".$this->id_karyawan."'");
            $this->db->where('trx.tahun', $tahun);
            $this->db->where('trx.bulan', $bulan);
        }
        $this->db->where_in('kry.status', ['1', '2', '3', '4']);
        $this->db->where("kry.id_company",$this->id_company);
        return $this->db->count_all_results();
    }
    
    private function _get_datatables_query($periode) {
        $tahun    = htmlentities($this->input->get('tahun'));
        $bulan    = htmlentities($this->input->get('bulan'));
        $karyawan = htmlentities($this->input->get('karyawan'));

        $this->db->select("kry.nama_lengkap, kry.nik, jab.nama as jabatan, trx.tahun, trx.bulan, trx.status, kry.id_karyawan, bobot.bobot_aspek_kinerja");
        $this->db->from('data_karyawan kry');
        $this->db->join('master_jabatan jab', 'kry.id_jabatan = jab.id_jabatan');
        $this->db->join('kpi_aspek_bobot_p bobot', 'bobot.id_jabatan = kry.id_jabatan', 'left');
        if($periode['isPeriodeInput']) {
            $this->db->join('kpi_approver_p apv', "apv.id_karyawan = kry.id_karyawan and apv.id_atasan = '".$this->id_karyawan."'");
            $this->db->join('kpi_trx trx', "trx.id_karyawan = kry.id_karyawan and trx.tahun = $tahun and trx.bulan = $bulan", 'left');
        } else {
            $this->db->join('kpi_trx trx', "trx.id_karyawan = kry.id_karyawan and trx.id_atasan = '".$this->id_karyawan."'");
            $this->db->where('trx.tahun', $tahun);
            $this->db->where('trx.bulan', $bulan);
        }
        $this->db->where_in('kry.status', ['1', '2', '3', '4']);
        $this->db->where("kry.id_company",$this->id_company);
        if($karyawan != "") {
            $this->db->where('kry.id_karyawan', $karyawan);
        }

        $column_order = array(null,'kry.nama_lengkap','jab.nama');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            $order_by = array("trx.tgl_input"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    function periodeTarget($tahun = null, $bulan = null) {
        if($tahun == null) {
            $bulan = htmlentities($this->input->get('bulan'));
            $tahun = htmlentities($this->input->get('tahun'));
        }

        $this->db->select('tahun, bulan, periode_mulai, periode_selesai');
        $this->db->from('kpi_periode_target_p');
        $this->db->where('bulan', $bulan);
        $this->db->where('tahun', $tahun);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get();
    }

}