<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class History_cuti_m extends CI_Model
{
    protected $table = 'cuti_history';

    function get_datatables($tahun, $jenis, $id_karyawan = '')
    {
        $this->_get_datatables_query($tahun, $jenis, $id_karyawan);

        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get_compiled_select();
        $query = $this->db->from('(' . $query . ') as tabel')->order_by('tabel.tgl_trx ASC')->get();
        // echo $this->db->last_query();
        return $query->result();
    }

    function count_filtered($tahun, $jenis, $id_karyawan = '')
    {
        $this->_get_datatables_query($tahun, $jenis, $id_karyawan);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($tahun, $jenis, $id_karyawan = '')
    {
        $this->_get_datatables_query($tahun, $id_karyawan);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($tahun, $jenis, $id_karyawan = '')
    {
        $this->db->select('
            ch.id_cuti_history,
            dk.nama_lengkap as nm_karyawan,
            dk.nik,
            ch.tgl_trx,
            ch.keterangan,
            ch.tambah,
            ch.kurang,
            ch.tgl_input
        ')
        ->from($this->table . ' as ch')
        ->join('data_karyawan as dk', 'dk.id_karyawan = ch.id_karyawan')
        ->where('ch.id_company', $this->id_company)
        ->where('date_format(ch.tgl_trx,"%Y")', $tahun)
        ->where('md5(ch.id_karyawan)', $id_karyawan);

        if ($jenis == 'tambah') {
            $this->db->where('tambah >', 0);
        }else{
            $this->db->where('kurang >', 0);
            $this->db->where('tambah < kurang', NULL, FALSE); // NULL sebagai nilai, FALSE untuk mencegah escaping
        }


        $column_search = array('');
        $i = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode GET

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('');

        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("ch.tgl_trx" => "ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function save($data)
    {
        $nextId = $this->fungsi->getNextId($this->table, 'id_cuti_history', $this->id_company, 3);
        $data['id_cuti_history'] = $nextId;

        $saldoSekarang = $this->db->select('jatah_cuti')
            ->from('data_karyawan')
            ->where('id_karyawan', $data['id_karyawan'])
            ->where('id_company', $this->id_company)
            ->get()
            ->row()
            ->jatah_cuti;

        if ($data['tambah'] > 0) {
            $saldo = $saldoSekarang + $data['tambah'];
        } else if ($data['kurang'] > 0) {
            $saldo = $saldoSekarang - $data['kurang'];
        }

        $data['saldo'] = $saldo;

        $this->db->trans_start();
        // insert data pada table cuti_history
        $this->db->insert($this->table, $data);
        // update data jatah_cuti pada table data_karyawan
        $data_saldo_karyawan = array(
            'jatah_cuti'  => $saldo,
            'user_update' => $data['user_input'],
            'tgl_update'  => date('Y-m-d H:i:s')
        );
        $this->db->update('data_karyawan', $data_saldo_karyawan, array(
            'id_karyawan' => $data['id_karyawan'],
            'id_company'  => $this->id_company
        ));
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_save(false);
        } else {
            $this->db->trans_commit();
            return __response_save(true);
        }
    }

    public function getKaryawanByIdMd5($id_karyawan)
    {
        $select = $this->db->select('
                dk.id_karyawan,
                dk.nik,
                dk.nama_lengkap,
                dk.jatah_cuti,
                dk.carry_forward,
                mc.kode as kode_cabang,
                mc.nama as nama_cabang,
                md.kode as kode_departemen,
                md.nama as nama_departemen,
                mj.kode_jabatan as kode_jabatan,
                mj.nama as nama_jabatan,
            ')
            ->from('data_karyawan as dk')
            ->join('master_jabatan as mj', 'mj.id_jabatan = dk.id_jabatan')
            ->join('master_cabang as mc', 'mc.id_cabang = dk.id_cabang')
            ->join('master_departemen as md', 'md.id_departemen = dk.id_departemen', 'left')
            ->where('dk.id_company', $this->id_company)
            ->where('md5(dk.id_karyawan)', $id_karyawan)
            ->get();

        if ($select->num_rows() > 0) {
            return $select->row();
        }
        return null;
    }

    public function max_tgl_cuti_karyawan($id_karyawan)
    {
        $select = $this->db->select('
                MAX(tgl_trx) as max_tgl_cuti
            ')
            ->from('cuti_history')
            ->where('id_company', $this->id_company)
            ->where('md5(id_karyawan)', $id_karyawan)
            ->get();

        if ($select->num_rows() > 0) {
            return $select->row();
        }
        return null;
    }
}
