<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Data_reimburse_m extends CI_Model {
    function get_datatables($tipe, $saya = null){
        $this->_get_datatables_query($tipe, $saya);
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($tipe, $saya = null){
        $this->_get_datatables_query($tipe, $saya);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($tipe, $saya = null){
        $this->_get_datatables_query($tipe, $saya);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query($tipe, $saya = null){
        $this->db->where("rp.id_company",$this->id_company);

        if ($tipe != 0) {
            if ($saya == 1) {
                $this->db->where("rp.id_karyawan",$this->id_karyawan);
                $this->db->where("rp.status",$tipe);
            }else{
                if($this->adm_reimbursement == false){
                    if ($this->level_user == 7) {
                        $this->db->where("rp.id_cabang", $this->id_cabang);
                        $this->db->where("rp.id_departemen", $this->id_departemen);
                        $this->db->where("dk.supervisi", $this->id_karyawan);
                        $this->db->where("rp.apv_spv",$tipe);
                    }elseif ($this->level_user == 2) {
                        $this->db->where("rp.id_cabang", $this->id_cabang);
                        $this->db->where("rp.id_departemen", $this->id_departemen);
                        $this->db->where("rp.apv_kedep",$tipe);
                    }elseif ($this->level_user == 5) {
                        $this->db->where("rp.id_cabang", $this->id_cabang);
                        $this->db->where("rp.apv_kacab",$tipe);
                    }elseif ($this->level_user == 4) {
                        $this->db->where("rp.apv_direksi",$tipe);
                    }
                }else{
                    if($this->id_cabang_reimbursement_arr != "all"){
                        $this->db->where_in("dk.id_cabang", $this->id_cabang_reimbursement_arr);
                    }
                    $this->db->where("rp.status",$tipe);
                    $this->db->group_start();
                    $this->db->where("rp.apv_finance", '6');
                    $this->db->or_where("rp.apv_finance", $tipe);
                    $this->db->group_end();

                }
            }
        }

        $this->db->select("rp.id,
                            rp.tgl_pengajuan,
                            rp.no_pengajuan,
                            rp.keterangan,
                            dk.nama_lengkap AS nama_karyawan,
                            dk.nik,
                            mc.kode AS kode_cabang,
                            mc.nama AS nama_cabang,
                            md.kode AS kode_departemen,
                            md.nama AS nama_departemen,
                            rp.status,
                            rp.apv_spv,
                            rp.apv_kedep,
                            rp.apv_kacab,
                            rp.apv_direksi,
                            rp.apv_finance,
                            SUM(rd.nominal) AS total_reimburse");
        $this->db->join("reimbursement_data AS rd","rd.id_pengajuan_reimbursement = rp.id");
        $this->db->join("master_cabang AS mc","mc.id_cabang = rp.id_cabang");
        $this->db->join("master_departemen AS md","md.id_departemen = rp.id_departemen","LEFT");
        $this->db->join("data_karyawan AS dk","dk.id_karyawan = rp.id_karyawan");
        $this->db->from("reimbursement_pengajuan AS rp");
        $this->db->group_by("rp.id");

        $column_search = array('rp.no_pengajuan','dk.nama_lengkap','dk.nik');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('',
                            'rp.no_pengajuan',
                            'rp.tgl_pengajuan',
                            'dk.nama_lengkap',
                            'mc.nama',
                            'md.nama');

        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else{
            $order_by = array("rp.tgl_pengajuan"=>"DESC","rp.no_pengajuan"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getNoPengajuan($id_pengajuan = null){
        $this->db->select("rp.id,
                            rp.status,
                            rp.no_pengajuan,
                            rp.tgl_pengajuan,
                            rp.apv_spv,
                            rp.apv_kedep,
                            rp.apv_kacab,
                            rp.apv_direksi,
                            rp.apv_finance,
                            rp.keterangan,
                            data_karyawan.nik,
                            data_karyawan.nama_lengkap AS nama_karyawan,
                            master_jabatan.kode_jabatan,
                            master_jabatan.nama AS nama_jabatan,
                            master_cabang.kode AS kode_cabang,
                            master_cabang.nama AS nama_cabang,
                            master_departemen.kode AS kode_departemen,
                            master_departemen.nama AS departemen_karyawan");
        $this->db->from("reimbursement_pengajuan AS rp");
        $this->db->join("data_karyawan","data_karyawan.id_karyawan = rp.id_karyawan");
        $this->db->join("master_jabatan","master_jabatan.id_jabatan = data_karyawan.id_jabatan");
        $this->db->join("master_cabang","master_cabang.id_cabang = rp.id_cabang");
        $this->db->join("master_departemen","master_departemen.id_departemen = rp.id_departemen", "LEFT");
        $this->db->where("md5(rp.id)",$id_pengajuan);
        $this->db->limit("1");
        $query = $this->db->get();
        return $query->row();
    }


    public function list_pengajuan($id_pengajuan_reimburse=null){
        $this->db->select("rd.id,
                            rj.jenis_plafon,
                            rj.max_nominal_plafon,
                            rd.nominal,
                            rd.nominal_disetujui,
                            rd.keterangan AS ket_reimburse,
                            rd.tgl_bukti,
                            rd.file,
                            rd.kode_akun,
                            rd.apv_spv,
                            rd.apv_kedep,
                            rd.apv_kacab,
                            rd.apv_direksi,
                            rd.apv_finance,
                            rd.ket_apv_spv,
                            rd.ket_apv_kedep,
                            rd.ket_apv_kacab,
                            rd.ket_apv_direksi,
                            rd.ket_apv_finance,
                            rd.ket_rev_spv,
                            rd.ket_rev_kedep,
                            rd.ket_rev_kacab,
                            rd.ket_rev_direksi,
                            rd.ket_rev_finance,
                            rd.ket_tolak_spv,
                            rd.ket_tolak_kedep,
                            rd.ket_tolak_kacab,
                            rd.ket_tolak_direksi,
                            rd.ket_tolak_finance,
                            rd.tgl_apv_spv,
                            rd.tgl_apv_kedep,
                            rd.tgl_apv_kacab,
                            rd.tgl_apv_direksi,
                            rd.tgl_apv_finance");
        $this->db->from("reimbursement_data AS rd");
        $this->db->join("reimbursement_jenis AS rj","rj.id_jenis_reimbursement = rd.id_jenis_reimbursement");
        $this->db->where("md5(rd.id_pengajuan_reimbursement)",$id_pengajuan_reimburse);
        $this->db->where("rd.id_company",$this->id_company);
        $query = $this->db->get();
        return $query->result();
    }

    public function list_akun(){
        $this->db->select("id_akun,
                        kode_akun,
                        nama_akun");
        $this->db->from("reimbursement_akun");
        $this->db->where("id_company",$this->id_company);
        $query = $this->db->get();
        return $query->result();
    }

    public function submit($id_pengajuan_reimburse=null, $flag=null){

        $this->db->where(array('id'=>$id_pengajuan_reimburse));
        $this->db->where("id_company",$this->id_company);

        if($this->adm_reimbursement == true){
            $update = $this->db->update('reimbursement_pengajuan',array('apv_finance'=>$flag, 'status'=>$flag, 'tgl_apv_finance' => date("Y-m-d H:i:s"), 'user_finance' => $this->id_karyawan));
        }else{
            $level = $this->level_user;
            if($level == '7') {
                $update = $this->db->update('reimbursement_pengajuan',array('apv_spv'=>$flag, 'tgl_apv_spv' => date("Y-m-d H:i:s"), 'user_spv' => $this->id_karyawan));
            }else if($level == '2') {
                $update = $this->db->update('reimbursement_pengajuan',array('apv_kedep'=>$flag, 'tgl_apv_kedep' => date("Y-m-d H:i:s"), 'user_kedep' => $this->id_karyawan));
            }else if($level == '5') {
                $update = $this->db->update('reimbursement_pengajuan',array('apv_kacab'=>$flag, 'tgl_apv_kacab' => date("Y-m-d H:i:s"), 'user_kacab' => $this->id_karyawan));
            }else if($level == '4') {
                $update = $this->db->update('reimbursement_pengajuan',array('apv_direksi'=>$flag, 'tgl_apv_direksi' => date("Y-m-d H:i:s"), 'user_direksi' => $this->id_karyawan));
            }
        }

        if($update){
            $token_fcm = "";
            $route = $request->get('route');
            $title = $request->get('title');
            $body = $request->get('body');
            $id_ref = $request->get('id_ref');
            $url_notif = $this->config->item('url_api').'/notifikasi/send?token_fcm='.$token_fcm.'&route='.$route.'&title&body&$id_ref';
            return  __response_update_reimburse(true,$flag);
        }else{
            return  __response_update_reimburse(false,$flag);
        }

    }
}
