<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Poin_mingguan extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('sales_activity/report/realisasi_poin/Poin_mingguan_m', 'model');
    }

    public function view_data()
    {
        $periode     = $this->input->get('periode');
        $id_group    = $this->input->get('id_group');
        $id_karyawan = $this->input->get('id_karyawan');

        $data['periode']     = $periode;
        $data['id_group']    = $id_group;
        $data['id_karyawan'] = $id_karyawan;

        $periode_arr = explode('-', $periode);
        $data['list_week'] = $this->model->getWeeksInMonth($periode_arr[0], $periode_arr[1]);
        $this->load->view('sales_activity/report/realisasi_poin/poin_mingguan/table', $data);
    }

    public function list_data()
    {
        $periode     = $this->input->get('periode');
        $id_group    = $this->input->get('id_group');
        $id_karyawan = $this->input->get('id_karyawan');

        $periode_arr = explode('-', $periode);
        $list_week = $this->model->getWeeksInMonth($periode_arr[0], $periode_arr[1]);

        $poin_realisasi = $this->model->get_poin_realisasi($periode, $id_group, $id_karyawan);
        $target_poin    = $this->model->poin_target_trx($periode, $id_group, $id_karyawan);

        $list = $this->model->get_datatables($periode, $id_group, $id_karyawan);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = $field->nama_karyawan . "<br><b>" . $field->nik . "</b>";

            $total_target_poin = 0;
            $total_realisasi_poin = 0;
            for ($x = 1; $x <= (COUNT($list_week)); $x++) {
                $target_poin_mingguan  = $target_poin[$field->id_karyawan][$x]['total_poin'];
                $row[]                 = !empty($target_poin_mingguan) ? $target_poin_mingguan : 0;
                $total_target_poin    += $target_poin_mingguan;

                $total_poin_mingguan   = $poin_realisasi[$field->id_karyawan][$x]['total_poin'];
                $row[]                 = !empty($total_poin_mingguan) ? $total_poin_mingguan : 0;
                $total_realisasi_poin += $total_poin_mingguan;
            }

            $row[] = '<B>' . $total_target_poin . '</B>';
            $row[] = '<B>' . $total_realisasi_poin . '</B>';

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($periode, $id_group, $id_karyawan),
            "recordsFiltered" => $this->model->count_filtered($periode, $id_group, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function view_data_diagram()
    {
        $periode     = $this->input->get('periode');
        $id_group    = $this->input->get('id_group');
        $id_karyawan = $this->input->get('id_karyawan');
        $bulan       = implode('-', array_reverse(explode('-', ('01-' . $periode))));

        $data['periode']     = $periode;
        $data['id_group']    = $id_group;
        $data['id_karyawan'] = $id_karyawan;
        $data['bulan']       = ($this->code_lang == 'id') ? indo_date(strtotime($bulan), 'F Y') : date('F Y ', strtotime($bulan));
        $this->load->view('sales_activity/report/realisasi_poin/poin_mingguan/diagram', $data);
    }

    public function list_data_diagram()
    {
        $periode     = $this->input->get('periode');
        $id_group    = $this->input->get('id_group');
        $id_karyawan = $this->input->get('id_karyawan');

        $periode_arr        = explode('-', $periode);
        $list_week          = $this->model->getWeeksInMonth($periode_arr[0], $periode_arr[1]);
        $arr_target_poin    = $this->model->poin_target_trx($periode, $id_group, $id_karyawan);
        $arr_poin_realisasi = $this->model->get_poin_realisasi($periode, $id_group, $id_karyawan);

        // Array Data
        $data = array();
        for ($x = 1; $x <= (COUNT($list_week)); $x++) {
            $data['minggu_ke'][] = 'Minggu ke-' . $x;

            $target_poin           = $arr_target_poin[$id_karyawan][$x]['total_poin'];
            $data["target_poin"][] = !empty($target_poin) ? $target_poin : 0;

            $realisasi           = $arr_poin_realisasi[$id_karyawan][$x]['total_poin'];
            $data["realisasi"][] = !empty($realisasi) ? $realisasi : 0;
        }

        // Skala Maksimal
        $maxNominal = [
            max($data['target_poin']),
            max($data['realisasi']),
        ];

        $skala_maximal = max($maxNominal) * 110 / 100;
        $data['max']   = ceil($skala_maximal / 100) * 100;

        echo json_encode($data);
    }

    private function getColumnName($index)
    {
        $letters = '';
        while ($index >= 0) {
            $letters = chr($index % 26 + 65) . $letters;
            $index = intdiv($index, 26) - 1;
        }
        return $letters;
    }

    public function download()
    {
        $periode     = $this->input->get('periode');
        $id_group    = $this->input->get('id_group');
        $nm_group    = $this->input->get('nm_group');
        $id_karyawan = $this->input->get('id_karyawan');
        $nm_karyawan = $this->input->get('nm_karyawan');

        $title       = "Sales Monitoring - Laporan Poin Mingguan ".$nm_group." ".$nm_karyawan;
        $periode_arr = explode('-', $periode);

        $data['list_week']      = $this->model->getWeeksInMonth($periode_arr[0], $periode_arr[1]);
        $data['poin_realisasi'] = $this->model->get_poin_realisasi($periode, $id_group, $id_karyawan);
        $data['target_poin']    = $this->model->poin_target_trx($periode, $id_group, $id_karyawan);

        $data['periode']  = $this->fungsi->get_bulan($periode) . ' ' . $this->fungsi->get_tahun($periode);
        $data['title']    = "Sales Monitoring - Laporan Poin Mingguan Bulan ".$data['periode']." ".$nm_group." ".$nm_karyawan;
        $data['filename'] = $title;
        $data['list']     = $this->model->get_datatables($periode, $id_group, $id_karyawan);

        $output  = true;
        $sb_view = $this->load->view('sales_activity/report/realisasi_poin/poin_mingguan/download', $data, $output);

        $column = 3 + ((count($data['list_week']) + 1) * 2);
        // START FORMAT COLUMN
        $format_columns = [
            'A'  => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
            'B'  => ['width' => 20, 'align' => 'left', 'valign' => 'middle', 'format' => 'text'],
            'C'  => ['width' => 30, 'align' => 'left', 'valign' => 'middle'],
        ];
        for ($i = 3; $i < $column; $i++) {
            $columnName = $this->getColumnName($i);
            $format_columns[$columnName] = ['width' => 12, 'align' => 'center', 'valign' => 'middle'];
        }
        // END FORMAT COLUMN

        $param = [
            'download'    => true,
            'cLength'     => ($column - 1),
            'file_name'   => strtoupper($filename),
            'paper_size'  => 'LEGAL',
            'font-size'   => 11,
            'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation' => 'landscape',
            'header'      => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
            ],
            'freezecolumn' => ['D6'],
            'thead'        => ['4', '5'],
            'tbody'        => [
                'start'  => '4',
                'height' => 15,
                'wrap'   => ['B', 'C'],
                'column' => $format_columns,
            ],
            'align_column_unit' => [
                ['align' => 'center', 'column' => ['A4:C4']]
            ]
        ];

        $this->load->library('PHPExcel/Excel');

        if ($output) {
            $this->excel->generateExcel($sb_view, $param);
        }
        exit;
    }

    public function dropdown_group()
    {
        $periode = $this->input->get("periode");
        $search  = $this->input->get("q");
        return $this->model->dropdown_group($periode, $search);
    }

    public function dropdown_karyawan()
    {
        $periode  = $this->input->get("periode");
        $id_group = $this->input->get("id_group");
        $search   = $this->input->get("q");
        return $this->model->dropdown_karyawan($periode, $id_group, $search);
    }
}
