<div class="position-relative pull-right" style="top: -2.5em;">
    <button id="view-table" type="button" class="ml-1 btn btn-biru ladda-button" data-style="expand-left">
        <i class="fa fa-table"></i> View Table
    </button>
</div>

<div class="pt-2">
    <div class="position-absolute pt-1 w-100 text-right" style="right: 15px;">
        <button id="download-diagram" type="button" class="btn btn-primary ladda-button" data-style="expand-left">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
        </button>
    </div>
    <div class="w-100 mt-1" style="overflow-x: auto;">
        <div style="height: 60vh;">
            <canvas id="grafik_poin_bulanan"></canvas>
        </div>
    </div>
</div>

<script>
    $(function() {
        initChart();

        $("#view-table").click(function() {
            list_datatable("table", this);
        });

        $("#download-diagram").click(function() {
            downloadChartImage("Report Poin Bulanan", ctxGrafikPoinBulanan, this);
        });

        let periode     = $(".filter #periode").val();
        let id_group    = !$(".filter #id_group").val()?'all':$(".filter #id_group").val();
        let id_karyawan = !$(".filter #id_karyawan").val()?'all':$(".filter #id_karyawan").val();

        view_diagram(periode, id_group, id_karyawan);
    });

    var ctxGrafikPoinBulanan = document.getElementById('grafik_poin_bulanan').getContext('2d');
    var grafikPoinBulanan;

    function initChart() {
        grafikPoinBulanan = new Chart(ctxGrafikPoinBulanan, {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                        label: "Target Poin",
                        borderColor: "#007aff",
                        backgroundColor: "rgba(0, 122, 255, 0.03)",
                        fill: true,
                        tension: 0.1,
                        data: [],
                    },
                    {
                        label: "Realisasi",
                        borderColor: "#ff9500",
                        backgroundColor: "rgba(255, 149, 0, 0.03)",
                        fill: true,
                        tension: 0.1,
                        data: [],
                    },
                ],
            },
            options: {
                maintainAspectRatio: false,
                responsive: true,
                layout: {
                    padding: {
                        left: 20,
                        right: 20,
                        top: 20,
                        bottom: 10
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                    },
                    x: {
                        grid: {
                            display: false
                        },
                    }
                },
                plugins: {
                    title: {
                        display: true,
                        align: 'start',
                        text: '',
                        color: '#1c77d4',
                        font: {
                            size: 16,
                            weight: 'bold'
                        },
                        padding: {
                            bottom: 10
                        }
                    },
                    subtitle: {
                        display: true,
                        align: 'start',
                        text: '',
                        font: {
                            size: 14,
                            weight: 'bold'
                        },
                        padding: {
                            bottom: 20
                        }
                    },
                    legend: {
                        labels: {
                            boxWidth: 40,
                        },
                        display: true,
                        position: 'bottom',
                    },
                }
            }
        });
    }

    function view_diagram(periode="0000", id_group="all", id_karyawan="all") {
        return $.get("<?= route('sales_activity.report.poin.bulanan.diagram.data.list') ?>"+
                                    '?periode='+periode+
                                    '&id_group='+id_group+
                                    '&id_karyawan='+id_karyawan, function(data) {
            var result = JSON.parse(data);

            grafikPoinBulanan.data.labels = result.bulan;
            grafikPoinBulanan.data.datasets[0].data = result.target_poin;
            grafikPoinBulanan.data.datasets[1].data = result.realisasi;

            grafikPoinBulanan.options.scales.y.steps = 0
            grafikPoinBulanan.options.scales.y.max = result.max;
            grafikPoinBulanan.options.scales.y.ticks.stepSize = result.max / 10;

            if (id_karyawan == 'all') {
                if(id_group == 'all'){
                    grafikPoinBulanan.options.plugins.title.text = 'Report Poin Bulanan Semua Sales';
                }else{
                    let nama_group = $('#id_group').select2('data')[0].text;
                    grafikPoinMingguan.options.plugins.title.text = 'Report Poin Bulanan '+ucwords(nama_group.split('-')[1].trim().toLocaleLowerCase());
                }
            }else{
                var nama_sales = $('#id_karyawan').select2('data')[0].text;
                grafikPoinBulanan.options.plugins.title.text = 'Report Poin Bulanan ' + ucwords(nama_sales.split('-')[1].trim().toLocaleLowerCase());
            }
            grafikPoinBulanan.options.plugins.subtitle.text = 'Tahun '+periode;


            grafikPoinBulanan.update();
        });
    }
</script>
