<?php 
class Bpjs_config_m extends CI_Model {

	public function __construct(){
		parent::__construct();

        $this->id_company  = $this->session->userdata('id_company');
        $this->id_karyawan = $this->session->userdata('id_karyawan');
        $this->nama_user   = $this->session->userdata('nama_user');
	}

	public function initial_config() {
		$cek_bpjs_kes = $this->check_config_bpjs_kes();
		$cek_bpjs_tk  = $this->cek_bpjs_tk();
		if($cek_bpjs_kes == 0) {
			//jika belum ada settingan bpjs kesehatan
			$this->create_config_bpjs_kes();
		}

		if($cek_bpjs_tk == 0) {
			//jika belum ada settingan bpjs ketenagakerjaan
			$this->create_config_bpjs_tk();
		}
	}

	private function check_config_bpjs_kes() {
		//mengecek sudah ada atau belum config bpjs kes
		$this->db->from('payroll_bpjs_kes_comp_p');
		$this->db->where('id_company', $this->id_company);
		return $this->db->count_all_results();
	}

	private function cek_bpjs_tk() {
		//mengecek sudah ada atau belum config bpjs tk
		$this->db->from('payroll_bpjs_tk_comp_p');
		$this->db->where('id_company', $this->id_company);
		return $this->db->count_all_results();
	}

	private function create_config_bpjs_kes() {
		//insert config bpjs kes
		$this->db->query("INSERT INTO payroll_bpjs_kes_comp_p(
				id_company,
				tunj_perus,
				pot_kry, 
				pot_tambahan_kry,
				user_input
			) SELECT ?, 
				tunj_perus, 
				pot_kry, 
				pot_tambahan_kry, 
				? 
			FROM payroll_bpjs_kes_config", array(
				$this->id_company, 
				$this->id_karyawan.'-'.$this->nama_user
			)
		);
	}

	private function create_config_bpjs_tk() {
		//insert config bpjs tk
		$this->db->query("INSERT INTO payroll_bpjs_tk_comp_p(
				id_company,
				tunj_jht_perus,
				pot_jht_kry, 
				tunj_jkk,
				tunj_jp_perus, 
				pot_jp_kry, 
				tunj_jkm, 
				user_input
			) SELECT ?, 
				tunj_jht_perus,
				pot_jht_kry, 
				tunj_jkk,
				tunj_jp_perus, 
				pot_jp_kry, 
				tunj_jkm, 
				?
			FROM payroll_bpjs_tk_config", array(
				$this->id_company, 
				$this->id_karyawan.'-'.$this->nama_user
			)
		);
	}

}
