<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Predikat_m extends CI_Model
{
    var $table = 'kpi_predikat_p';
    public function __construct()
    {
        parent::__construct();
    }

    function get_datatables()
    {
        $this->_get_datatables_query();
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->db->select("grade")
            ->from($this->table);
        $this->db->where("id_company", $this->id_company);

        return $this->db->count_all_results();
    }

    private function _get_datatables_query()
    {

        $this->db->select("grade,
                        keterangan,
                        batas_bawah,
                        batas_atas,
                        id_company
                        ")
            ->from($this->table)
            ->where("id_company", $this->id_company);

        $column_search = array('');

        $i = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('', '', '', '');

        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("grade" => "ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id = null)
    {
        $select = $this->db->query("SELECT grade,
                                        keterangan,
                                        batas_bawah,
                                        batas_atas,
                                        id_company
                                    FROM $this->table
                                    WHERE MD5(concat(grade,id_company)) = '$id'
                                    AND id_company = '" . $this->id_company . "'")->row();
        return $select;
    }

    public function save($data, $id_predikat)
    {
        $this->db->where(array('md5(concat(grade,id_company))' => $id_predikat, 'id_company' => $this->id_company));
        $update = $this->db->update($this->table, $data);
        $this->logger->create_log('kpi_predikat', 'edit', $this->db->last_query());
        return  __response_update($update);
    }

    public function check_data_predikat(){
        $cek_predikat = $this->db->select('grade')
                        ->from($this->table)
                        ->where('id_company', $this->id_company)
                        ->get()
                        ->row()
                        ->grade;

        if(empty($cek_predikat)){
            $data = array();

            # Grade A
            $data[] = array(
                'grade'       => 'A',
                'keterangan'  => 'Exceed Expectation',
                'batas_bawah' => 4.26,
                'batas_atas'  => 5.00,
                'id_company'  => $this->id_company,
                'tgl_input'   => date("Y-m-d H:i:s"),
                'user_input'  => $this->nik_karyawan. " - ". $this->nm_karyawan
            );

            # Grade B
            $data[] = array(
                'grade'       => 'B',
                'keterangan'  => 'Meet Expectation',
                'batas_bawah' => 3.26,
                'batas_atas'  => 4.25,
                'id_company'  => $this->id_company,
                'tgl_input'   => date("Y-m-d H:i:s"),
                'user_input'  => $this->nik_karyawan. " - ". $this->nm_karyawan
            );

            # Grade C
            $data[] = array(
                'grade'       => 'C',
                'keterangan'  => 'Bellow Expectation',
                'batas_bawah' => 2.26,
                'batas_atas'  => 3.25,
                'id_company'  => $this->id_company,
                'tgl_input'   => date("Y-m-d H:i:s"),
                'user_input'  => $this->nik_karyawan. " - ". $this->nm_karyawan
            );

            # Grade D
            $data[] = array(
                'grade'       => 'D',
                'keterangan'  => 'Unacceptable',
                'batas_bawah' => 0,
                'batas_atas'  => 2.25,
                'id_company'  => $this->id_company,
                'tgl_input'   => date("Y-m-d H:i:s"),
                'user_input'  => $this->nik_karyawan. " - ". $this->nm_karyawan
            );

            $this->db->trans_start();
            $this->db->insert_batch($this->table, $data);
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        }  
    }
}
