<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Data_diri_histori_m extends CI_Model {
  public $table = 'data_karyawan_h';

  function get_datatables(){
      $this->_get_datatables_query();
      if($_POST['length'] != -1){
          $this->db->limit($_POST['length'], $_POST['start']);
      }
      $query = $this->db->get();
      return $query->result();
  }

  function count_filtered(){
      $this->_get_datatables_query();
      $query = $this->db->get();
      return $query->num_rows();
  }

  public function count_all(){
      $this->db->select("id")->from($this->table);
      $this->db->where("id_company",$this->session->userdata('id_company'));
      $this->db->where('md5(id_karyawan)', $this->input->get('id_karyawan'));
      return $this->db->count_all_results();
  }
  private function _get_datatables_query(){
      $this->db->select("id, tgl_input")->from($this->table);
      $this->db->where("id_company",$this->session->userdata('id_company'));
      $this->db->where('md5(id_karyawan)', $this->input->get('id_karyawan'));
      $column_search = array('tgl_input');
      $i = 0;

      foreach ($column_search as $item){  // looping awal
          if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

              if($i===0){ // looping awal
                  $this->db->group_start();
                  $this->db->like($item, $_POST['search']['value']);
              }else{
                  $this->db->or_like($item, $_POST['search']['value']);
              }

              if(count($column_search) - 1 == $i){
                  $this->db->group_end();
              }
          }
          $i++;
      }

      $column_order = array('','action','tgl_input','id');

      if(isset($_POST['order'])){
          $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
      }
      else{
          $order_by = array("tgl_input"=>"DESC");
          $this->db->order_by(key($order_by), $order_by[key($order_by)]);
      }
  }

  function get_data($id_md5) {
    $this->db->select('data_karyawan_h.id_karyawan,
      data_karyawan_h.nik,
      data_karyawan_h.nama_lengkap,
      data_karyawan_h.gelar_depan,
      data_karyawan_h.gelar_belakang,
      data_karyawan_h.jenis_kelamin,
      data_karyawan_h.golongan_darah,
      data_karyawan_h.agama,
      data_karyawan_h.tempat_lahir,
      data_karyawan_h.tgl_lahir,
      data_karyawan_h.alamat_domisili,
      data_karyawan_h.rt,
      data_karyawan_h.rw,
      data_karyawan_h.id_kel,
      data_karyawan_h.id_kec,
      data_karyawan_h.id_kab,
      data_karyawan_h.id_prov,
      data_karyawan_h.kode_pos,
      data_karyawan_h.no_ktp,
      data_karyawan_h.no_bpjs_kes,
      data_karyawan_h.no_bpjs_tk,
      data_karyawan_h.telepon,
      data_karyawan_h.email,
      data_karyawan_h.pendidikan_terakhir,
      data_karyawan_h.action,
      data_karyawan_h.id_company,
      master_kota.id_kota,
      master_kota.nama as nama_kota,
      master_kecamatan.id_kecamatan,
      master_kecamatan.nama as nama_kec,
      master_kelurahan.id_kelurahan,
      master_kelurahan.nama as nama_kel,
      master_provinsi.id_prov,
      master_provinsi.nama as nama_prov');
    $this->db->join("master_provinsi","master_provinsi.id_prov = data_karyawan_h.id_prov","LEFT");
    $this->db->join("master_kota","master_kota.id_kota = data_karyawan_h.id_kab","LEFT");
    $this->db->join("master_kecamatan","master_kecamatan.id_kecamatan = data_karyawan_h.id_kec","LEFT");
    $this->db->join("master_kelurahan","master_kelurahan.id_kelurahan = data_karyawan_h.id_kel","LEFT");
    $this->db->where('md5(id)', $id_md5);
    return $this->db->get($this->table)->row();
  }
}
