<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Notif_status {

  protected $CI;

  // We'll use a constructor, as you can't directly call a function
  // from a property definition.
  public function __construct()
  {
    // Assign the CodeIgniter super-object
    $this->CI =& get_instance();
  }

  function data_diri($id_karyawan_md5) {
    $this->CI->load->model('karyawan/Data_diri_pengajuan_m', 'data_diri_pengajuan_m');

		$data = $this->CI->data_diri_pengajuan_m->get_data($id_karyawan_md5);
		if($data->num_rows() > 0) {
			return notif_status($data->row()->status);
		} else {
			return '';
		}
	}
  function keluarga($id_karyawan_md5) {
    $this->CI->load->model('karyawan/Data_keluarga_pengajuan_m', 'keluarga_pengajuan_m');

		$data = $this->CI->keluarga_pengajuan_m->get_data_pengajuan($id_karyawan_md5);
		if($data->num_rows() > 0) {
			return notif_status($data->row()->status_pengajuan);
		} else {
			return '';
		}
	}
  function pendidikan($id_karyawan_md5) {
    $this->CI->load->model('karyawan/Riwayat_pendidikan_pengajuan_m', 'pendidikan_pengajuan_m');

		$data = $this->CI->pendidikan_pengajuan_m->get_data_pengajuan($id_karyawan_md5);
		if($data->num_rows() > 0) {
			return notif_status($data->row()->status_pengajuan);
		} else {
			return '';
		}
	}
  function pengalaman($id_karyawan_md5) {
    $this->CI->load->model('karyawan/pengalaman_kerja_pengajuan_m', 'pengalaman_pengajuan_m');

		$data = $this->CI->pengalaman_pengajuan_m->get_data_pengajuan($id_karyawan_md5);
		if($data->num_rows() > 0) {
			return notif_status($data->row()->status_pengajuan);
		} else {
			return '';
		}
	}
  function sertifikat($id_karyawan_md5) {
    $this->CI->load->model('karyawan/Data_sertifikat_pengajuan_m', 'sertifikat_pengajuan_m');

		$data = $this->CI->sertifikat_pengajuan_m->get_data_pengajuan($id_karyawan_md5);
		if($data->num_rows() > 0) {
			return notif_status($data->row()->status_pengajuan);
		} else {
			return '';
		}
	}
  function file($id_karyawan_md5) {
    $this->CI->load->model('karyawan/Data_kelengkapan_file_pengajuan_m', 'file_pengajuan_m');

		$data = $this->CI->file_pengajuan_m->get_data_pengajuan($id_karyawan_md5);
		if($data->num_rows() > 0) {
			return notif_status($data->row()->status_pengajuan);
		} else {
			return '';
		}
	}

  function karyawan() {
    $this->CI->load->model('karyawan/Data_diri_pengajuan_m', 'data_diri_pengajuan_m');
    $this->CI->load->model('karyawan/Data_keluarga_pengajuan_m', 'keluarga_pengajuan_m');
    $this->CI->load->model('karyawan/Riwayat_pendidikan_pengajuan_m', 'pendidikan_pengajuan_m');
    $this->CI->load->model('karyawan/pengalaman_kerja_pengajuan_m', 'pengalaman_pengajuan_m');
    $this->CI->load->model('karyawan/Data_sertifikat_pengajuan_m', 'sertifikat_pengajuan_m');
    $this->CI->load->model('karyawan/Data_kelengkapan_file_pengajuan_m', 'file_pengajuan_m');

    $data_diri_pengajuan  = $this->CI->data_diri_pengajuan_m->total_pengajuan();
    $keluarga_pengajuan   = $this->CI->keluarga_pengajuan_m->total_pengajuan();
    $pendidikan_pengajuan = $this->CI->pendidikan_pengajuan_m->total_pengajuan();
    $pengalaman_pengajuan = $this->CI->pengalaman_pengajuan_m->total_pengajuan();
    $sertifikat_pengajuan = $this->CI->sertifikat_pengajuan_m->total_pengajuan();
    $file_pengajuan       = $this->CI->file_pengajuan_m->total_pengajuan();
    if($data_diri_pengajuan->num_rows() > 0) {
      return notif_status($data_diri_pengajuan->row()->status);
    } elseif($keluarga_pengajuan->num_rows() > 0) {
      return notif_status($keluarga_pengajuan->row()->status_pengajuan);
    } elseif($pendidikan_pengajuan->num_rows() > 0) {
      return notif_status($pendidikan_pengajuan->row()->status_pengajuan);
    } elseif($pengalaman_pengajuan->num_rows() > 0) {
      return notif_status($pengalaman_pengajuan->row()->status_pengajuan);
    } elseif($sertifikat_pengajuan->num_rows() > 0) {
      return notif_status($sertifikat_pengajuan->row()->status_pengajuan);
    } elseif($file_pengajuan->num_rows() > 0) {
      return notif_status($file_pengajuan->row()->status_pengajuan);
    } else {
      return '';
    }
  }

  function per_karyawan($id_karyawan_md5) {
    $this->CI->load->model('karyawan/Data_diri_pengajuan_m', 'data_diri_pengajuan_m');
    $this->CI->load->model('karyawan/Data_keluarga_pengajuan_m', 'keluarga_pengajuan_m');
    $this->CI->load->model('karyawan/Riwayat_pendidikan_pengajuan_m', 'pendidikan_pengajuan_m');
    $this->CI->load->model('karyawan/pengalaman_kerja_pengajuan_m', 'pengalaman_pengajuan_m');
    $this->CI->load->model('karyawan/Data_sertifikat_pengajuan_m', 'sertifikat_pengajuan_m');
    $this->CI->load->model('karyawan/Data_kelengkapan_file_pengajuan_m', 'file_pengajuan_m');

    $data_diri_pengajuan  = $this->CI->data_diri_pengajuan_m->get_data_pengajuan($id_karyawan_md5);
    $keluarga_pengajuan   = $this->CI->keluarga_pengajuan_m->get_data_pengajuan($id_karyawan_md5);
    $pendidikan_pengajuan = $this->CI->pendidikan_pengajuan_m->get_data_pengajuan($id_karyawan_md5);
    $pengalaman_pengajuan = $this->CI->pengalaman_pengajuan_m->get_data_pengajuan($id_karyawan_md5);
    $sertifikat_pengajuan = $this->CI->sertifikat_pengajuan_m->get_data_pengajuan($id_karyawan_md5);
    $file_pengajuan       = $this->CI->file_pengajuan_m->get_data_pengajuan($id_karyawan_md5);
    if($data_diri_pengajuan->num_rows() > 0) {
      return notif_status($data_diri_pengajuan->row()->status);
    } elseif($keluarga_pengajuan->num_rows() > 0) {
      return notif_status($keluarga_pengajuan->row()->status_pengajuan);
    } elseif($pendidikan_pengajuan->num_rows() > 0) {
      return notif_status($pendidikan_pengajuan->row()->status_pengajuan);
    } elseif($pengalaman_pengajuan->num_rows() > 0) {
      return notif_status($pengalaman_pengajuan->row()->status_pengajuan);
    } elseif($sertifikat_pengajuan->num_rows() > 0) {
      return notif_status($sertifikat_pengajuan->row()->status_pengajuan);
    } elseif($file_pengajuan->num_rows() > 0) {
      return notif_status($file_pengajuan->row()->status_pengajuan);
    } else {
      return '';
    }
  }
}
