<style>
    #btn_filter_pencarian {
        background-color: Transparent;
        background-repeat:no-repeat;
        border: none;
        cursor:pointer;
        overflow: hidden;
        outline:none;
    }
    .form-control.select2-hidden-accessible {
        top: 40px;
        left: 17px;
    }
</style>

<script src="<?=base_url()?>assets/js/datepicker-id.js"></script>
<script type="text/javascript">
    $(function() {
        dropdown_cabang();
        dropdown_departemen();

        tanggal();
        hide_table();
        btn_filter_pencarian();
        pickrange();
        list_data(loading_enable = false);

        $('#btn_filter').click(function(){
            list_data(loading_enable = true);

        });
    });

    function list_data(loading_enable = false) {
        if(loading_enable == true){
            // alert("ojk");
            var loading = Ladda.create(document.getElementById("btn_filter"));
            loading.start();
        }
        var level_user          = '<?= $level_user ?>';
        var multi_departemen    = '<?= $multi_departemen ?>';
        var multi_cabang        = '<?= $multi_cabang ?>';

        var tanggal_mulai   = $("#tanggal_mulai").val();
        var tanggal_selesai = $("#tanggal_selesai").val();

        if(level_user == "1" || level_user == "4"){ // ADMIN HR DAN DIREKSI
            var id_cabang     = (!$("#cabang").val())?"0":$("#cabang").val();
            var id_departemen = (!$("#departemen").val())?"0":$("#departemen").val();
        }else if(level_user == "5"){ // KEPALA CABANG
            if(multi_cabang == '1'){
                var id_cabang   = (!$("#cabang").val())?"0":$("#cabang").val();
            }else{
                var id_cabang   = '<?= $this->session->userdata("id_cabang") ?>';
            }
            var id_departemen   = (!$("#departemen").val())?"0":$("#departemen").val();
        }else if(level_user == "2"){ // KEPALA DEPARTEMEN
            var id_cabang     = '<?= $this->session->userdata("id_cabang") ?>';
            if(multi_departemen == '1'){
                var id_departemen   = (!$("#departemen").val())?"0":$("#departemen").val();
            }else{
                var id_departemen   = '<?= $this->session->userdata("id_departemen") ?>';
            }
        }else if(level_user == "7"){ // SUPERVISI
            var id_cabang       = '0';
            var id_departemen   = '0';
        }else{
            var id_cabang       = '<?= $this->session->userdata("id_cabang") ?>';
            var id_departemen   = '<?= $this->session->userdata("id_departemen") ?>';
        }
        $("#content").show();
        $('#view_data').load("<?= route('rekap.absensi.data.view') ?>"+"/"+tanggal_mulai+'/'+tanggal_selesai+'/'+id_cabang+'/'+id_departemen, function(){
            if(loading_enable == true){
                loading.stop();
            }
        });
    }

    var date_diff_indays = function(date1, date2) {
        dt1 = new Date(date1);
        dt2 = new Date(date2);
        return Math.floor((Date.UTC(dt2.getFullYear(), dt2.getMonth(), dt2.getDate()) - Date.UTC(dt1.getFullYear(), dt1.getMonth(), dt1.getDate()) ) /(1000 * 60 * 60 * 24));
    }

    function convert(tanggal) {
        var res = tanggal.split("/");
        return res[1]+"/"+res[0]+"/"+res[2];
    }


    function btn_filter_pencarian() {
        $("#btn_filter_pencarian").click(function() {
            if($("#kolom_filter").is(":visible") == true) {
                $("#caret").removeClass("fa-caret-down");
                $("#caret").addClass("fa-caret-up");
                $("#kolom_filter").hide();
            } else {
                $("#caret").addClass("fa-caret-down");
                $("#caret").removeClass("fa-caret-up");
                $("#kolom_filter").show();
            }
        });
    }

    function tanggal() {
        var d = new Date();
        d.setDate(d.getDate()); // - 1
        $('.input-daterange input').each(function() {
            $(this).datepicker({
                orientation: "bottom",
                format: "dd-mm-yyyy",
                endDate: d,
                autoclose: true,
            });
        });
    }

    function hide_table() {
        // fungsi untuk menyembunyikan tabel
        $("#content").hide();
    }


    function dropdown_cabang(){
        $('#cabang').select2({
            placeholder: "<?= $this->lang->line('semua_cabang') ?>",
            allowClear: true,
            ajax: {
                url: '<?= route("laporan.absensi.dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function onchange_dropdown_cabang(){
        $("#departemen").val('').trigger('change');
        dropdown_departemen();
    }

    function dropdown_departemen(){

        var level_user          = '<?= $level_user ?>';
        var multi_cabang        = '<?= $multi_cabang ?>';

        if(level_user == "1" || level_user == "4"){ // ADMIN HR DAN DIREKSI
            var id_cabang     = ($("#cabang").val() == null)?"0":$("#cabang").val();
        }else{ // KEPALA CABANG
            if(multi_cabang == '1'){
                var id_cabang   = ($("#cabang").val() == null)?"0":$("#cabang").val();
            }else{
                var id_cabang   = '<?= $this->session->userdata("id_cabang") ?>';
            }
        }

        $("#departemen").select2({
            placeholder: "<?= $this->lang->line('semua_departemen') ?>",
            allowClear: true,
            ajax: {
                url: '<?= route("laporan.absensi.dropdown.departemen") ?>/'+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                            results: data
                        };
                },
                cache: false
            }
        });
    }

</script>
<div class="row">
    <div class="col-md-12">
        <div class="content-header">
            <div class="row align-items-center">
                <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
                    <h3 class="content-header-title"><?= $judul ?></h3>
                    <div class="row breadcrumbs-top">
                        <div class="breadcrumb-wrapper col-12">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_kelola_absensi'); ?></a>
                                </li>
                                <li class="breadcrumb-item active"><?= $judul ?>
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="content-header-right col-md-6 col-12">
                    <div class="float-md-right">
                        <button type="button" id="btn_filter_pencarian">
                            <i class="fa fa-filter"></i> <?= $this->lang->line('button_filter_pencarian') ?> <i id="caret" class="fa fa-caret-down"></i>
                        </button>
                    </div>
                </div>
            </div>
            <hr>
            <div id="kolom_filter" class="row">
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="text-uppercase"><?= $this->lang->line('periode'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <div class="input-group input-daterange">
                                    <input type="text" class="form-control masktanggal" value="<?= $periode_awal; ?>" id="tanggal_mulai" required>
                                    <div class="align-self-center">&nbsp;<?= $this->lang->line('s/d'); ?>&nbsp;</div>
                                    <input type="text" class="form-control masktanggal" value="<?= $periode_akhir; ?>" id="tanggal_selesai" required>
                                </div>
                            </div>
                        </div>
                        <?php
                            if (in_array($this->session->userdata('level_user'), array("2","7","3")) && $multi_departemen == false) {
                        ?>
                                <div class="col-md-1">
                                    <button type="button" id="btn_filter" class="btn btn-primary ladda-button" data-style="expand-left">FILTER</button>
                                </div>
                        <?php } ?>
                    </div>
                    <div class="row">
                        <?php
                            if(in_array($level_user, array("1", "4")) || $multi_cabang == true) {
                        ?>
                        <div class="col-md-1">
                            <label class="text-uppercase"><?= $this->lang->line('cabang'); ?></label>
                        </div>
                        <div class="col-md-2">
                            <select id="cabang" class="form-control" onchange="onchange_dropdown_cabang()"></select>
                        </div>
                        <?php } ?>

                        <?php
                            if (in_array($level_user, array("1", "4", "5")) || $multi_departemen == true) {

                                if(in_array($level_user, array("1", "4"))){
                                    $class = "col-md-2";
                                }else if($level_user == "5"){
                                    if($multi_cabang == true){
                                        $class = "col-md-2";
                                    }else{
                                        $class = "col-md-5";
                                    }
                                }else{
                                    $class = "col-md-5";
                                }
                        ?>
                        <div class="col-lg-1">
                            <label class="text-uppercase"><?= $this->lang->line('departemen'); ?></label>
                        </div>
                        <div class="<?= $class ?>">
                            <select id="departemen" class="form-control"></select>
                        </div>
                        <div class="col-md-1">
                            <button type="button" id="btn_filter" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row mt-2">
                <div class="col-md-12 text-secondary">
                    <b>H</b> : <?= $this->lang->line('hadir'); ?>
                    <b class="ml-1">T</b> : <?= $this->lang->line('terlambat'); ?>
                    <b class="ml-1">PC</b> : <?= $this->lang->line('pulang_cepat'); ?>
                    <b class="ml-1">TAP</b> : <?= $this->lang->line('tidak_absen_pulang'); ?>
                    <?php
                        if ($this->paket_arr['flexible_jam_kerja'] == false) { ?>
                            <b class="ml-1">A</b> : <?= $this->lang->line('alpa'); ?>
                    <?php } ?>
                    <b class="ml-1">S</b> : <?= $this->lang->line('sakit'); ?>
                    <b class="ml-1">I</b> : <?= $this->lang->line('izin'); ?>
                    <b class="ml-1">C</b> : <?= $this->lang->line('cuti'); ?>
                </div>
            </div>

        </div>
    </div>
</div>

<div id="content" class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div id="view_data"></div> <!-- class="col-md-12 bbna" -->
        </div>
    </div>
</div>