<script type="text/javascript">
    $(function() {
        $('.btn_destroy').on('click', function(e) {
            e.preventDefault();
            var loading = Ladda.create(this);
            $("#message").html("");

            loading.start();

            var param = {};
            param.id = $("#encrypt_id").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('payroll.master.lembur.pengaturan.delete') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    loading.stop();
                    if (result.success == true) {
                        showMsg(result.message);
                    } else {
                        showMsg(result.message, false);
                    }
                },
                error: function() {
                    loading.stop();
                    showMsg('error', false);
                }
            });
        });
    });
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="form_input" class="card-body" disabled>
    <input id="encrypt_id" type="text" value="<?= $data->id_lembur_p ? md5($data->id_lembur_p) : '' ?>" class="hidden" disabled>
    <div class="alert alert-warning" role="alert">
        <i class="fa fa-exclamation-triangle"></i> Data yang sudah melekat pada karyawan juga akan ikut terhapus
    </div>
    <div class="mb-2">
        <span>Kode:</span>
        <p class="font-weight-bold"><?= $data->kode ?: '' ?></p>
    </div>

    <div class="mb-2">
        <span>Keterangan:</span>
        <p class="font-weight-bold"><?= $data->keterangan ?: '' ?></p>
    </div>

    <div class="mb-2">
        <label>Pembulatan Waktu:</label>
        <?php if (count($data->pembulatan) == 0) : ?>
            <p class="font-weight-bold">-</p>
        <?php endif; ?>
        <?php foreach ($data->pembulatan as $value) { ?>
            <div class="border-left border-2 border-light pl-1 mb-1">
                <div class="row">
                    <div class="col-2">
                        <div class="row">
                            <div class="col-1">
                                <label class="font-weight-bold"><?= $value->menit_mulai ?></label>
                            </div>
                            <div class=" col-1 text-center">
                                <span class="badge badge-light">menit</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-1 ml-1 font-weight-bold">
                        <span style="font-size: 11px;">-</span>
                    </div>
                    <div class="col-2">
                        <div class="row">
                            <div class="col-1">
                                <label class="font-weight-bold"><?= $value->menit_selesai ?></label>
                            </div>
                            <div class=" col-1 text-center">
                                <span class="badge badge-light">menit</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-1 ml-1 font-weight-bold">
                        <span>=</span>
                    </div>
                    <div class="col-2">
                        <div class="row">
                            <div class="col-1">
                                <label class="font-weight-bold"><?= $value->menit_dihitung ?></label>
                            </div>
                            <div class=" col-1 text-center">
                                <span class="badge badge-light">menit</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>

    <div class="mb-2">
        <label>Kompensasi Rate:</label>
        <?php if (count($data->perkalian) == 0) : ?>
            <p class="font-weight-bold">-</p>
        <?php endif; ?>
        <?php foreach ($data->perkalian as $value) { ?>
            <div class="border-left border-2 border-light pl-1 mb-1">
                <div class="row">
                    <div class="col-2">
                        <div class="row">
                            <div class="col-1">
                                <label class="font-weight-bold"><?= $value->jam_mulai ?></label>
                            </div>
                            <div class=" col-1 text-center">
                                <span class="badge badge-light">jam</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-1 ml-1 font-weight-bold">
                        <span style="font-size: 11px;">-</span>
                    </div>
                    <div class="col-2">
                        <div class="row">
                            <div class="col-1">
                                <label class="font-weight-bold"><?= $value->jam_selesai ?></label>
                            </div>
                            <div class=" col-1 text-center">
                                <span class="badge badge-light">jam</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-1 ml-1 font-weight-bold">
                        <span>=</span>
                    </div>
                    <div class="col-2">
                        <label class="font-weight-bold"><?= $value->perkalian ?></label>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>

    <div>
        <label>Jenis Upah Lembur(Per Jam):</label>
        <?php if ($data->jenis_upah_lembur == 'flat') : ?>
            <p class="font-weight-bold"><span class="badge badge-secondary">Flat</span> Rp <?= number_format($data->nominal_flat, 0, ',', '.') ?></p>
        <?php else : ?>
            <p class="font-weight-bold"><span class="badge badge-secondary">Prorate</span> Salary / <?= $data->divide_prorate ?: '' ?></p>
        <?php endif; ?>
    </div>

    <div class="form-group mt-3">
        <h6 class="font-weight-bold" style="color: #1c77d4;">Diikutsertakan Hitungan</h6>
        <hr>
        <div class="row">
            <div class="col-md-5 my-auto">
                <label>PPH21</label>
            </div>
            <div class="col-md-3">
                <label>
                    <input type="radio" name="flag_pph21" value="0" <?= ((isset($data) && $data->flag_pph21 == "0") ? "checked" : ((!isset($data)) ? "checked" : "")) ?>>
                    <span class="text">Tidak</span>
                </label>
            </div>
            <div class="col-md-4">
                <label>
                    <input type="radio" name="flag_pph21" value="1" <?= ((isset($data) && $data->flag_pph21 == "1") ? "checked" : "") ?>>
                    <span class="text">Ya</span>
                </label>
            </div>
        </div>
        <div class="row">
            <div class="col-md-5 my-auto">
                <label>Potongan Absensi</label>
            </div>
            <div class="col-md-3">
                <label>
                    <input type="radio" name="flag_pot_absensi" value="0" <?= ((isset($data) && $data->flag_pot_absensi == "0") ? "checked" : ((!isset($data)) ? "checked" : "")) ?>>
                    <span class="text">Tidak</span>
                </label>
            </div>
            <div class="col-md-4">
                <label>
                    <input type="radio" name="flag_pot_absensi" value="1" <?= ((isset($data) && $data->flag_pot_absensi == "1") ? "checked" : "") ?>>
                    <span class="text">Ya</span>
                </label>
            </div>
        </div>
    </div>
</div>

<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button id="btn_submit" class="ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>
