<script type="text/javascript">
    var level_user = '<?= $this->level_user ?>';
    var multi_cabang = '<?= $this->multi_cabang ?>';

    $(function() {
        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            cabang();
        }

        tanggal();
        pickrange();

        filter();
        filter_onchange();
        diagram_pie();
        layanan();

        if (level_user == "1" || level_user == "4") {
            dropdown_karyawan_cabang();
            change_dropdown_karyawan_cabang();
            dropdown_keterlambatan_cabang();
        }
    });

    function tanggal() {
        var d = new Date();
        d.setDate(d.getDate());
        $('.input-daterange input').each(function() {
            $(this).datepicker({
                orientation: "bottom",
                format: "dd-mm-yyyy",
                endDate: d,
                autoclose: true,
            });
        });
    }

    function diagram_pie() {
        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            var id_cabang = (!$("#ra #cabang").val()) ? "all" : $("#ra #cabang").val();
        } else {
            var id_cabang = "<?= $this->id_cabang ?>";
        }

        var jam_kerja = (!$("#ra #jam_kerja").val()) ? "all" : $("#ra #jam_kerja").val();
        $.ajax({
            type: 'GET',
            dataType: 'json',
            url: '<?= route("dashboard.absensi.data.diagram.pie") ?>' + '/' + id_cabang + '/' + jam_kerja,
            complete: function(data) {
                reconfigure(data);
            },
        }).then(function(data) {
            $("#ra #hadir").html(data.absen);
            $("#ra #terlambat").html(data.terlambat);
            $("#ra #belum_absen").html(data.belum_absen);
            $("#ra #izin").html(data.izin);
            $("#ra #cuti").html(data.cuti);
            $("#ra #sakit").html(data.sakit);
            document.getElementById("chart-dashboard").innerHTML = "";
            new Morris.Donut({
                // ID of the element in which to draw the chart.
                element: 'chart-dashboard',
                // Chart data records -- each entry in this array corresponds to a point on
                // the chart.
                data: [{
                        label: "<?= $this->lang->line('hadir') ?>",
                        value: data.absen
                    },
                    {
                        label: "<?= $this->lang->line('terlambat') ?>",
                        value: data.terlambat
                    },
                    {
                        label: "<?= $this->lang->line('belum_absen') ?>",
                        value: data.belum_absen
                    },
                    {
                        label: "<?= $this->lang->line('cuti') ?>",
                        value: data.cuti
                    },
                    {
                        label: "<?= $this->lang->line('izin') ?>",
                        value: data.izin
                    },
                    {
                        label: "<?= $this->lang->line('sakit') ?>",
                        value: data.sakit
                    }
                ],
                colors: [
                    "#2883FA", //hadir
                    "#FFD700", //hadir
                    "#F63939", //Belum absen
                    "#07CF72", //Cuti
                    "#FF9900", //Izin
                    "#BA47E4" //sakit
                ]
            });
        });
    }

    function cabang() {
        $("#ra #cabang").select2({
            placeholder: '<?= $this->lang->line('semua_cabang') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function filter() {
        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            var id_cabang = (!$("#ra #cabang").val()) ? "all" : $("#ra #cabang").val();
        } else {
            var id_cabang = "<?= $this->id_cabang ?>";
        }
        $("#ra #jam_kerja").select2({
            // dropdownParent: $("#pilihan"),
            placeholder: '<?= $this->lang->line('semua') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.jamkerja") ?>/' + id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });
    }

    function filter_onchange() {
        $("#ra #jam_kerja").change(function() {
            if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
                var id_cabang = (!$("#ra #cabang").val()) ? "all" : $("#ra #cabang").val();
            } else {
                var id_cabang = "<?= $this->id_cabang ?>";
            }
            var jam_kerja = (!$("#ra #jam_kerja").val()) ? "all" : $("#ra #jam_kerja").val();

            dropdownParent: $("#ra #pilihan"),
                $.ajax({
                    type: 'GET',
                    dataType: 'json',
                    url: '<?= route("dashboard.absensi.data.diagram.pie") ?>' + '/' + id_cabang + '/' + jam_kerja,
                    complete: function(data) {
                        reconfigure(data);
                    },
                }).then(function(data) {
                    $("#ra #hadir").html(data.absen);
                    $("#ra #terlambat").html(data.terlambat);
                    $("#ra #belum_absen").html(data.belum_absen);
                    $("#ra #izin").html(data.izin);
                    $("#ra #cuti").html(data.cuti);
                    $("#ra #sakit").html(data.sakit);
                    document.getElementById("chart-dashboard").innerHTML = "";
                    new Morris.Donut({
                        // ID of the element in which to draw the chart.
                        element: 'chart-dashboard',
                        // Chart data records -- each entry in this array corresponds to a point on
                        // the chart.
                        data: [{
                                label: "<?= $this->lang->line('hadir') ?>",
                                value: data.absen
                            },
                            {
                                label: "<?= $this->lang->line('terlambat') ?>",
                                value: data.terlambat
                            },
                            {
                                label: "<?= $this->lang->line('belum_absen') ?>",
                                value: data.belum_absen
                            },
                            {
                                label: "<?= $this->lang->line('cuti') ?>",
                                value: data.cuti
                            },
                            {
                                label: "<?= $this->lang->line('izin') ?>",
                                value: data.izin
                            },
                            {
                                label: "<?= $this->lang->line('sakit') ?>",
                                value: data.sakit
                            }
                        ],
                        colors: [
                            "#2883FA", //hadir
                            "#FFD700", //Terlambat
                            "#F63939", //Belum absen
                            "#07CF72", //Cuti
                            "#FF9900", //Izin
                            "#BA47E4" //sakit
                        ]
                    });
                });
        });
    }

    function filter_list() {
        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            var id_cabang = (!$("#ra #cabang").val()) ? "all" : $("#ra #cabang").val();
        } else {
            var id_cabang = "<?= $this->id_cabang ?>";
        }

        $("#ra #jam_kerja").val("");

        $("#ra #jam_kerja").select2({
            // dropdownParent: $("#pilihan"),
            placeholder: '<?= $this->lang->line('semua') ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.jamkerja") ?>/' + id_cabang,
                dataType: 'json',
                delay: 250,
                complete: function(data) {
                    reconfigure(data);
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });

        var jam_kerja = (!$("#ra #jam_kerja").val()) ? "all" : $("#ra #jam_kerja").val();
        $.ajax({
            type: 'GET',
            dataType: 'json',
            url: '<?= route("dashboard.absensi.data.diagram.pie") ?>' + '/' + id_cabang + '/' + jam_kerja,
            complete: function(data) {
                reconfigure(data);
            },
        }).then(function(data) {
            $("#ra #hadir").html(data.absen);
            $("#ra #terlambat").html(data.terlambat);
            $("#ra #belum_absen").html(data.belum_absen);
            $("#ra #izin").html(data.izin);
            $("#ra #cuti").html(data.cuti);
            $("#ra #sakit").html(data.sakit);
            document.getElementById("chart-dashboard").innerHTML = "";
            new Morris.Donut({
                // ID of the element in which to draw the chart.
                element: 'chart-dashboard',
                // Chart data records -- each entry in this array corresponds to a point on
                // the chart.
                data: [{
                        label: "<?= $this->lang->line('hadir') ?>",
                        value: data.absen
                    },
                    {
                        label: "<?= $this->lang->line('terlambat') ?>",
                        value: data.terlambat
                    },
                    {
                        label: "<?= $this->lang->line('belum_absen') ?>",
                        value: data.belum_absen
                    },
                    {
                        label: "<?= $this->lang->line('cuti') ?>",
                        value: data.cuti
                    },
                    {
                        label: "<?= $this->lang->line('izin') ?>",
                        value: data.izin
                    },
                    {
                        label: "<?= $this->lang->line('sakit') ?>",
                        value: data.sakit
                    }
                ],
                colors: [
                    "#2883FA", //hadir
                    "#FFD700", //Terlambat
                    "#F63939", //Belum absen
                    "#07CF72", //Cuti
                    "#FF9900", //Izin
                    "#BA47E4" //sakit
                ]
            });
        });
    }

    function detail() {
        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            var id_cabang = (!$("#ra #cabang").val()) ? "all" : $("#ra #cabang").val();
        } else {
            var id_cabang = "<?= $this->id_cabang ?>";
        }
        var jam_kerja = (!$("#ra #jam_kerja").val()) ? "all" : $("#ra #jam_kerja").val();
        window.location.href = "<?= route('dashboard.absensi.detail.data') ?>" + '/' + id_cabang + '/' + jam_kerja;
    }

    function detailRekap(jenis = "") {
        if (level_user == "1" || level_user == "4" || multi_cabang == "1") {
            var id_cabang = (!$("#ra #cabang").val()) ? "all" : $("#ra #cabang").val();
        } else {
            var id_cabang = "<?= $this->id_cabang ?>";
        }
        var jam_kerja = (!$("#ra #jam_kerja").val()) ? "all" : $("#ra #jam_kerja").val();
        var url = "<?= route('dashboard.absensi.data.diagram.pie.detail') ?>" + "/" + jenis + "/" + id_cabang + "/" + jam_kerja;
        $('#modal_chart #tampil_form').load(url, function() {
            $('#modal_chart').modal('show');
        });
    }

    if (level_user == "1" ||level_user == "4") {

        function layanan() {
            $.getJSON("<?= route('dashboard.layanan') ?>", function(result) {
                $("#layanan #nm_layanan").text(result.data.nm_paket)
                $("#layanan #ttl_karyawan").text(result.data.ttl_karyawan_aktif + " <?= $this->lang->line('dari_maksimal') ?> " + result.data.max_karyawan + " <?= $this->lang->line('karyawan') ?>")
                $("#layanan #ms_layanan").text(result.data.masa_layanan)
            });
        }

        function ttlKaryawan() {
            var id_cabang = (!$("#karyawan #cabang").val()) ? "all" : $("#karyawan #cabang").val();
            var id_departemen = (!$("#karyawan #departemen").val()) ? "all" : $("#karyawan #departemen").val();

            $.getJSON("<?= route('dashboard.absensi.ttl.karyawan.genre') ?>" + "/" + id_cabang + "/" + id_departemen, function(result) {
                $("#karyawan #persentase_pria").html(result.data.persentase_pria)
                $("#karyawan #ttl_pria").html(result.data.ttl_pria)
                $("#karyawan #persentase_wanita").html(result.data.persentase_wanita)
                $("#karyawan #ttl_wanita").html(result.data.ttl_wanita)
                $("#karyawan #persentase_uknown").html(result.data.persentase_uknown)
                $("#karyawan #ttl_uknown").html(result.data.ttl_uknown)
                $("#karyawan #ttl_karyawan").html(result.data.ttl_karyawan)
            });
        }

        // BEGIN DROPDOWN JUMLAH KARYAWAN
        function dropdown_karyawan_cabang() {
            $("#karyawan #cabang").select2({
                placeholder: '<?= $this->lang->line('semua_cabang') ?>',
                allowClear: true,
                ajax: {
                    url: '<?= route("dashboard.absensi.ttl.karyawan.dropdown.cabang") ?>',
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: false
                }
            });
        }

        function change_dropdown_karyawan_cabang() {
            $("#karyawan #departemen").val("");
            var id_cabang = (!$("#karyawan #cabang").val()) ? "all" : $("#karyawan #cabang").val();
            $("#karyawan #departemen").select2({
                placeholder: '<?= $this->lang->line('semua_departemen') ?>',
                allowClear: true,
                ajax: {
                    url: '<?= route("dashboard.absensi.ttl.karyawan.dropdown.departemen") ?>' + '/' + id_cabang,
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: false
                }
            });
            ttlKaryawan();
        }
        // END DROPDOWN JUMLAH KARYAWAN


        // BEGIN DROPDOWN KETERLAMBATAN
        function dropdown_keterlambatan_cabang() {
            $("#keterlambatan #cabang").select2({
                placeholder: '<?= $this->lang->line('semua_cabang') ?>',
                allowClear: true,
                ajax: {
                    url: '<?= route("dashboard.absensi.grafik.keterlambatan.dropdown.cabang") ?>',
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: false
                }
            });
        }

        function modalChart(url = "") {
            $('#modal_chart #tampil_form').load(url, function() {
                $('#modal_chart').modal('show');
            });
        }
    }
</script>

<?php
if (in_array($this->level_user, ["1"])) {
?>
    <div class="row f-12">
        <div class="col-md-4">
            <div class="card card-rounded">
                <div class="card-absenku card-header card-info-absenku">
                    <h4 class="card-title"><?= $this->lang->line('paket_aktif') ?></h4>
                    <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                    <div class="heading-elements">
                        <ul class="list-inline mb-0">
                            <li>
                                <span></span>
                            </li>
                        </ul>
                    </div>
                </div>
                <div id="layanan" class="card-content collpase show">
                    <div class="card-body min-h-157">
                        <div class="row">
                            <div class="col-md-6">
                                <h6><img style="height:25px" src="<?= base_url('assets/images/icon/absenku.png') ?>"> <?= $this->lang->line('layanan') ?></h6>
                                <label id="nm_layanan"></label>
                            </div>
                            <div class="col-md-6">
                                <h6><img style="height:25px" src="<?= base_url('assets/images/icon/user.png') ?>"> <?= $this->lang->line('karyawan') ?></h6>
                                <label id="ttl_karyawan"></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <h6> <img style="height:25px" src="<?= base_url('assets/images/icon/24h.png') ?>" alt=""> <?= $this->lang->line('masa_aktif') ?> </h6>
                                <label id="ms_layanan"></label>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </div>

        <div id="karyawan" class="col-md-3">
            <div class="card card-rounded">
                <div class="card-absenku card-header card-info-absenku">
                    <h4 class="card-title">
                        <?= $this->lang->line('karyawan') ?>
                        <button type="button" class="navbar-toggler pull-right" data-toggle="collapse" data-target="#navbarToggleExternalContent">
                            <i class="fa fa-bars text-dark"></i>
                        </button>
                    </h4>
                    <div class="collapse mt-2" id="navbarToggleExternalContent">
                        <div class="row">
                            <div class="col-md-12">
                                <select id="cabang" class="form-control" onchange="change_dropdown_karyawan_cabang()" style="width:100%"></select>
                            </div>
                        </div>
                        <div class="row mt-1">
                            <div class="col-md-12">
                                <select id="departemen" class="form-control" onchange="ttlKaryawan()" style="width:100%"></select>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="card-content collpase show">
                    <div class="card-body min-h-157">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-2 col-2 p-0">
                                        <img style="height:25px" src="<?= base_url('assets/images/icon/karyawan-pria.png') ?>" class="img-responsive" style="max-height: 35px; object-fit: contain;">
                                    </div>
                                    <div class="col-md-10 col-10">
                                        <label id="persentase_pria" class="d-block"></label>
                                        <label id="ttl_pria"></label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-2 col-2 p-0">
                                        <img style="height:25px" src="<?= base_url('assets/images/icon/karyawan-wanita.png') ?>" class="img-responsive" style="max-height: 35px; object-fit: contain;">
                                    </div>
                                    <div class="col-md-10 col-10">
                                        <label id="persentase_wanita" class="d-block"></label>
                                        <label id="ttl_wanita"></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-1">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-2 col-2 p-0">
                                        <img style="height:25px" src="<?= base_url('assets/images/icon/unknown_gender.png') ?>" class="img-responsive" style="max-height: 35px; object-fit: contain;">
                                    </div>
                                    <div class="col-md-10 col-10">
                                        <label id="persentase_uknown" class="d-block"></label>
                                        <label id="ttl_uknown"></label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-2 col-2 p-0">
                                        <img style="height:25px" src="<?= base_url('assets/images/icon/total-karyawan.png') ?>" class="img-responsive" style="max-height: 35px; object-fit: contain;">
                                    </div>
                                    <div class="col-md-10 col-10">
                                        <label class="d-block"><b><?= $this->lang->line('total_karyawan') ?></b></label>
                                        <label id="ttl_karyawan"></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-5">
            <div class="card card-rounded">
                <div class="card-absenku card-header card-info-absenku">
                    <h4 class="card-title"><?= $this->lang->line('menu_pengaturan') ?></h4>
                    <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                    <div class="heading-elements">
                        <ul class="list-inline mb-0">
                            <li>
                                <span></span>
                            </li>
                        </ul>
                    </div>
                </div>
                <div id="layanan" class="card-content collpase show">
                    <div class="card-body min-h-157">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="row">
                                    <div class="col-md-12">
                                        <a href="<?= route('master.lokasi.tambah') ?>">
                                            <h6 class="mb-2"><img src="<?= base_url('assets/images/icon/lokasi-absensi.png') ?>" width="20"> <?= $this->lang->line('lokasi_absensi') ?></h6>
                                        </a>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <a href="<?= route('pengaturan.jamkerja.home') ?>">
                                            <h6 class="mb-2"><img src="<?= base_url('assets/images/icon/pengaturan-jam-kerja.png') ?>" width="20"> <?= $this->lang->line('jam_kerja') ?></h6>
                                        </a>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <a href="<?= route('master.karyawan.tambah') ?>">
                                            <h6 class=""><img src="<?= base_url('assets/images/icon/tambah-karyawan.png') ?>" width="20"> <?= $this->lang->line('tambah_karyawan') ?></h6>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="row">
                                    <div class="col-md-12">
                                        <a href="<?= route('pengaturan.izin.home') ?>">
                                            <h6 class="mb-2"><img src="<?= base_url('assets/images/icon/approval-izin.png') ?>" width="20"> <?= $this->lang->line('approval_izin') ?></h6>
                                        </a>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <a href="<?= route('pengaturan.lembur.home') ?>">
                                            <h6 class="mb-2"><img src="<?= base_url('assets/images/icon/approval-lembur.png') ?>" width="20"> <?= $this->lang->line('approval_lembur') ?></h6>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="row">
                                    <div class="col-md-12">
                                        <h6 class="font-weight-bold">Download App Mobile</h6>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <a href="https://play.google.com/store/apps/details?id=com.absenku.professional" target="_blank">
                                            <img src="<?= base_url('assets/images/icon/playstore.png') ?>" class="img-responsive" style="max-height: 35px; object-fit: contain;">
                                        </a>
                                    </div>
                                </div>
                                <div class="row mt-1">
                                    <div class="col-md-12">
                                        <a href="https://apps.apple.com/us/app/absenku-professional/id6502589919" target="_blank">
                                            <img src="<?= base_url('assets/images/icon/appstore.png') ?>" class="img-responsive" style="max-height: 35px; object-fit: contain;">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
}
?>

<div class="row">
    <div id="ra" class="col-md-7">
        <div class="card card-rounded">
            <div class="card-absenku card-header card-info-absenku">
                <h4 class="card-title"><?= $this->lang->line('rekap_absensi_hari_ini') ?></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements" id="pilihan">
                    <ul class="list-inline mb-0">
                        <li><span class="tgls"></span></li>
                        <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collpase show">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <a href="<?= site_url('pengaturan/hari-libur') ?>">
                                <button type="button" class="btn btn-outline-primary btn-min-width mr-1 mb-1">
                                    <i class="fa fa-calendar"></i> <?= $this->lang->line('kalender_absensi') ?>
                                </button>
                            </a>
                            <a href="#">
                                <button type="button" class="btn btn-outline-primary btn-min-width mr-1 mb-1" onclick="detail()">
                                    <i class="fa fa-eye"></i> <?= $this->lang->line('lihat_semua') ?>
                                </button>
                            </a>
                        </div>
                        <div class="col-md-6">
                            <?php
                            if (in_array($this->level_user, ["1", "4"]) || $this->multi_cabang == true) {
                            ?>
                                <div class="row">
                                    <div class="col-md-4 align-self-center">
                                        <label><?= $this->lang->line('cabang') ?></label>
                                        <label class="pull-right">:</label>
                                    </div>
                                    <div class="col-md-8">
                                        <select id="cabang" class="form-control" onchange="filter_list()"></select>
                                    </div>
                                </div>
                            <?php
                            }
                            ?>
                            <div class="row mt-1">
                                <div class="col-md-4 align-self-center">
                                    <label><?= $this->lang->line('jam_kerja') ?></label>
                                    <label class="pull-right">:</label>
                                </div>
                                <div class="col-md-8 align-self-center">
                                    <select id="jam_kerja" class="form-control">
                                        <option value="all" selected="true"><?= $this->lang->line('semua') ?></option>
                                        <option value="0"><?= $this->lang->line('reguler') ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row mt-1">
                        <div class="col-md-6">
                            <div id="chart-dashboard" style="height: 250px;"></div>
                        </div>
                        <div class="col-md-6">
                            <div>
                                <table class="table table-striped">
                                    <tbody>
                                        <tr>
                                            <td><?= $this->lang->line('hadir') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="hadir" onclick="detailRekap('hadir')"></td>
                                            <td class="text-right"> <?= $this->lang->line('karyawan') ?></td>
                                        </tr>
                                        <tr>
                                            <td><?= $this->lang->line('terlambat') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="terlambat" onclick="detailRekap('terlambat')"></td>
                                            <td class="text-right"> <?= $this->lang->line('karyawan') ?></td>
                                        </tr>
                                        <tr>
                                            <td><?= $this->lang->line('belum_absen') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="belum_absen" onclick="detailRekap('belum_absen')"></td>
                                            <td class="text-right"> <?= $this->lang->line('karyawan') ?></td>
                                        </tr>
                                        <tr>
                                            <td><?= $this->lang->line('cuti') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="cuti" onclick="detailRekap('cuti')"></td>
                                            <td class="text-right"> <?= $this->lang->line('karyawan') ?></td>
                                        </tr>
                                        <tr>
                                            <td><?= $this->lang->line('izin') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="izin" onclick="detailRekap('izin')"></td>
                                            <td class="text-right"> <?= $this->lang->line('karyawan') ?></td>
                                        </tr>
                                        <tr>
                                            <td><?= $this->lang->line('sakit') ?></td>
                                            <td class="text-center text-primary cursor-pointer" id="sakit" onclick="detailRekap('sakit')"></td>
                                            <td class="text-right"> <?= $this->lang->line('karyawan') ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-2" style="font-family: 'Poppins Medium';">
                        <div class="col-6 col-md-3">
                            <i class="fa fa-stop" style="color: #2883FA"></i> <?= $this->lang->line('hadir') ?>
                            <br>
                            <i class="fa fa-stop" style="color: #FFD700"></i> <?= $this->lang->line('terlambat') ?>
                            <br>
                            <i class="fa fa-stop" style="color: #F63939"></i> <?= $this->lang->line('belum_absen') ?>
                        </div>
                        <div class="col-6 col-md-3">
                            <i class="fa fa-stop" style="color: #07CF72"></i> <?= $this->lang->line('cuti') ?>
                            <br>
                            <i class="fa fa-stop" style="color: #FF9900"></i> <?= $this->lang->line('izin') ?>
                            <br>
                            <i class="fa fa-stop" style="color: #BA47E4"></i> <?= $this->lang->line('sakit') ?>
                            <br>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-5">
        <div class="card card-rounded">
            <div class="card-absenku card-header">
                <h4 class="card-title"><?= $this->lang->line('daftar_pengajuan') ?></h4>
            </div>
            <div class="card-content collpase show">
                <div class="card-body">
                    <ul class="nav nav-tabs">
                        <li class="nav-item">
                            <a onclick="loadlst('izin')" class="nav-link active" id="base-tab1" data-toggle="tab" aria-controls="tab1" href="#tab1" aria-expanded="true"><?= $this->lang->line('izin') ?>/<?= $this->lang->line('cuti') ?>/<?= $this->lang->line('sakit') ?></a>
                        </li>
                        <li class="nav-item">
                            <a onclick="loadlst('lembur')" class="nav-link" id="base-tab2" data-toggle="tab" aria-controls="tab2" href="#tab2" aria-expanded="false"><?= $this->lang->line('lembur') ?></a>
                        </li>
                    </ul>

                    <div class="tab-content daftar-pengajuan">
                        <div role="tabpanel" class="tab-pane active" id="tab1" aria-expanded="true" aria-labelledby="base-tab1">
                            <div class="row">
                                <div class="col-md-12 col-sm-12" id="lstizin" style="height: 355px; overflow-y: auto;">

                                </div>
                                <div class="col-md-12 col-sm-12 text-center">
                                    <a href="<?= route('pengajuan.izin.home'); ?>">
                                        <button type="button" class="btn btn-outline-biru round btn-min-width">
                                            <?= $this->lang->line('lihat_semua') ?>
                                        </button>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane" id="tab2" aria-labelledby="base-tab2">
                            <div class="row">
                                <div class="col-md-12 col-sm-12" id="lstlembur" style="height: 355px; overflow-y: auto;">

                                </div>
                                <div class="col-md-12 col-sm-12 text-center">
                                    <a href="<?= site_url('pengajuan/lembur'); ?>">
                                        <button type="button" class="btn btn-outline-biru round btn-min-width">
                                            <?= $this->lang->line('lihat_semua') ?>
                                        </button>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php
    if (in_array($this->level_user, ["1","4"])) {
?>
    <div id="keterlambatan" class="row">
        <div class="col-md-12">
            <div class="card card-rounded">
                <div class="card-absenku card-header card-info-absenku">
                    <h4 class="card-title"><?= $this->lang->line('rasio_terlambat') ?></h4>
                </div>
                <div class="row p-2">
                    <div class="col-md-4">
                        <select id="cabang" class="form-control" onchange="updateGrafikKeterlambatan()"></select>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="input-group input-daterange">
                                <input type="text" id="tanggal_mulai" class="form-control masktanggal" value="<?= "01-".date('m-Y'); ?>" onchange="updateGrafikKeterlambatan()">
                                <div class="align-self-center">&nbsp;<?= $this->lang->line('s/d') ?>&nbsp;</div>
                                <input type="text" id="tanggal_selesai" class="form-control masktanggal" value="<?= date('d-m-Y') ?>" onchange="updateGrafikKeterlambatan()">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 chart-container">
                        <canvas id="grafik_keterlambatan" class="p-1" style="height: 400px"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<!-- START TAMPIL MODAL -->
<div id="modal_chart" class="modal fade in">
    <div class="modal-dialog modal-xl">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->


<?php
    if (in_array($this->level_user, ["1","4"])) {
?>
    <!-- BEGIN GRAFIK BAR KETERLAMBATAN -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"></script>
        <script>
        var barOptions_keterlambatan = {
            responsive: true,
            maintainAspectRatio: false,
            tooltips: {
                enabled: false,
            },
            hover: {
                animationDuration: 0
            },
            scales: {
                xAxes: [
                    {
                        ticks: {
                            beginAtZero: true,
                            fontFamily: "Poppins SemiBold",
                            fontSize: 11,
                            userCallback: function(label, index, labels) {
                                // when the floored value is the same as the value we have a whole number
                                if (Math.floor(label) === label) {
                                    return label;
                                }
                            },
                        },
                        scaleLabel: {
                            display: false
                        },
                        gridLines: {},
                        stacked: true,
                        scaleLabel: {
                            display: true,
                            labelString: 'Total <?= $this->lang->line('kehadiran') ?>'
                        }
                    }
                ],
                yAxes: [
                    {
                        gridLines: {
                            display: false,
                            color: "#fff",
                            zeroLineColor: "#fff",
                            zeroLineWidth: 0
                        },
                        ticks: {
                            fontFamily: "Poppins SemiBold",
                            fontSize: 11
                        },
                        stacked: true,
                        scaleLabel: {
                            display: true,
                            labelString: '<?= $this->lang->line('label_yAxis') ?>'
                        }
                    }
                ]
            },
            legend: {
                display: true,
                onClick: (e) => e.stopPropagation()
            },
            animation: {
                onComplete: function() {
                    var chartInstance = this.chart;
                    var ctx = chartInstance.ctx;
                    ctx.textAlign = "center";
                    ctx.font      = "10px Poppins SemiBold";

                    ttl_kehadiran_object              = {};
                    persentase_keterlambatan_object = {};

                    this.data.datasets[0].data.forEach(function(data, index) {
                        var total = parseInt(data) + parseInt(this.data.datasets[1].data[index]);
                        var meta  = chartInstance.controller.getDatasetMeta(1);
                        var posX  = meta.data[index]._model.x;
                        var posY  = meta.data[index]._model.y;

                        ttl_terlambat = parseInt(this.data.datasets[0].data[index]);
                        ttl_disiplin  = parseInt(this.data.datasets[1].data[index]);

                        ttl_kehadiran            = ttl_terlambat + ttl_disiplin;
                        persentase_keterlambatan = Math.round((ttl_terlambat/ttl_kehadiran)*100);

                        ttl_kehadiran_object[index]            = ttl_terlambat + ttl_disiplin;
                        persentase_keterlambatan_object[index] = persentase_keterlambatan;





                    }, this);

                    Chart.helpers.each(
                        this.data.datasets.forEach(function(dataset, i) {
                            var meta = chartInstance.controller.getDatasetMeta(i);
                            Chart.helpers.each(
                                meta.data.forEach(function(bar, index) {
                                    data = dataset.data[index];

                                    if(i == 0) {
                                        if(data == "0"){
                                            persentase_keterlambatan = 0;
                                        }else{
                                            persentase_keterlambatan = persentase_keterlambatan_object[index];
                                        }

                                        if(persentase_keterlambatan == 100){
                                            ctx.fillStyle = "red";
                                            ctx.fillText(persentase_keterlambatan+" % dari "+ttl_kehadiran_object[index]+" Total Karyawan", bar._model.x + 75, bar._model.y - 4);
                                        }else if(persentase_keterlambatan != 0){
                                            ctx.fillStyle = "#000000";
                                            ctx.fillText(persentase_keterlambatan+" %", bar._model.x + 20, bar._model.y - 4);
                                        }
                                    }else{
                                        persentase_keterlambatan = persentase_keterlambatan_object[index];
                                        if(persentase_keterlambatan != 0){
                                            ctx.fillStyle = "#1C77D4";
                                            ctx.fillText(ttl_kehadiran_object[index]+ " <?= $this->lang->line('label_dlm_grafik') ?> " +dataset.jmlKaryawan[index]+" <?= $this->lang->line('karyawan') ?>", bar._model.x + 90, bar._model.y - 4);
                                        }
                                    }
                                }),
                                this
                            );
                        }),
                        this
                    );
                }
            },
            pointLabelFontFamily: "Quadon Extra Bold",
            scaleFontFamily: "Quadon Extra Bold"
        };

        var id_grafik_keterlambatan = document.getElementById("grafik_keterlambatan");
        var chart_keterlambatan = new Chart(id_grafik_keterlambatan, {
                                    type: "horizontalBar",
                                    data: {
                                            labels: [],
                                                datasets: [
                                                        {
                                                            label : "<?= $this->lang->line('label_persentase') ?>",
                                                            data: [],
                                                            backgroundColor: "rgb(122, 146, 163)"
                                                        },
                                                        {
                                                            label : "Total <?= $this->lang->line('kehadiran') ?>",
                                                            data: [],
                                                            backgroundColor: "rgb(11, 98, 164)",
                                                            jmlKaryawan:[]
                                                        },
                                                    ]},
                                    options: barOptions_keterlambatan
                                });

        function updateGrafikKeterlambatan(){
            var id_cabang = (!$("#keterlambatan #cabang").val())?"all":$("#keterlambatan #cabang").val();
            var tgl_mulai = $("#keterlambatan #tanggal_mulai").val();
            var tgl_selesai = $("#keterlambatan #tanggal_selesai").val();
            $.ajax({
                    type: 'GET',
                    dataType: 'JSON',
                    url: '<?= route("dashboard.absensi.grafik.keterlambatan.data") ?>'+'/'+id_cabang+'/'+tgl_mulai+'/'+tgl_selesai,
                    success: function (result, textStatus, jqXHR){

                        ttl_karyawan_terbanyak = (Math.max.apply(Math,result.data.ttl_karyawan)).toString();

                        ttl_karyawan_terbanyak = parseInt(ttl_karyawan_terbanyak);

                        ttl_absensi_per_bulan = ((ttl_karyawan_terbanyak) * 26);

                        chart_keterlambatan.data.labels = result.data.label;
                        chart_keterlambatan.data.datasets[0].data = result.data.terlambat;
                        chart_keterlambatan.data.datasets[1].data = result.data.tepat_waktu;
                        chart_keterlambatan.data.datasets[1].jmlKaryawan = result.data.ttl_karyawan;
                        chart_keterlambatan.options.scales.xAxes[0].ticks.max = ttl_absensi_per_bulan ;
                        chart_keterlambatan.update();
                    }
                });

        }
    </script>
    <!-- END GRAFIK BAR KETERLAMBATAN -->

    <?php
    }
    ?>

<!-- <script src="<?= base_url('assets/js/home_realtime_date.js') ?>"></script> -->
<script>
    setInterval(function() {
        var d = new Date();
        var months = <?= $this->lang->line('array_bulan') ?>;
        var days = <?= $this->lang->line('array_hari') ?>;
        var timezone = ["", "", "", "", "", "", "", "WIB", "WITA", "WIT"];
        var gmt = -(d.getTimezoneOffset() / 60);
        var date_time = days[d.getDay()] + ', ' + d.getDate() + ' ' + months[d.getMonth()] + ' ' + d.getFullYear() + ' ' + (d.getHours() < 10 ? '0' : '') + d.getHours() + ':' + (d.getMinutes() < 10 ? '0' : '') + d.getMinutes() + ' ' + timezone[gmt];
        $('.tgls').html(date_time);
    });

    $(document).ready(function() {
        loadlst('izin');
    });

    function loadlst(tp = '') {
        $('#lst' + tp).html('');
        $('#lst' + tp).load('<?php echo route('dashboard.list.data') ?>/' + tp);
    }
</script>
