<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Master_qrcode_m extends CI_Model {
    var $table = 'patroli_m';

    public function __construct(){
		parent::__construct();
	}

    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->db->select("id")->from($this->table);
        $this->db->where("id_company",$this->id_company);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("pm.id, 
                            pm.id_cabang,
                            pm.nm_lokasi, 
                            pm.path,
                            mc.nama as nama_cabang,
                            mc.kode as kode_cabang");
        $this->db->from($this->table .' as pm');
        $this->db->join('master_cabang AS mc', 'mc.id_cabang= pm.id_cabang');
        $this->db->where('pm.id_company', $this->id_company);

        $column_search = array('mc.nama','pm.nm_lokasi');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('','mc.nama','pm.nm_lokasi');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            $order_by = array("pm.tgl_input"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $select = $this->db->query("SELECT pm.id, 
                                        pm.id_cabang,
                                        pm.nm_lokasi, 
                                        pm.path,
                                        mc.nama as nama_cabang,
                                        mc.kode as kode_cabang
                                    FROM $this->table as pm
                                    JOIN master_cabang as mc ON mc.id_cabang = pm.id_cabang
                                    WHERE MD5(pm.id) = '$id'
                                    AND pm.id_company = '".$this->id_company."'")->row();
        return $select;
    }

    public function save($data,$id = null){
        if($id != null){
            $data['user_update'] = $this->id_karyawan;
            $data['tgl_update'] = date('Y-m-d H:i:s');

            $this->db->where(array('md5(id)'=>$id, 'id_company'=>$this->id_company));
            $update = $this->db->update($this->table,$data);
            return  __response_update($update);

        }else{

            $data['user_input'] = $this->id_karyawan;

            $nextId = $this->fungsi->getNextId($this->table,'id',$this->id_company,3);
            $id_mc = array('id' => $nextId);
            $save = $this->db->insert($this->table, array_merge($data,$id_mc));
            return __response_save($save);
        }

    }

    public function delete($id=null){
        $predir_file = $this->db->select("path")
                                        ->from($this->table)
                                        ->where("md5(id)",$id)
                                        ->where("id_company",$this->id_company)
                                        ->get()
                                        ->row("path");

        $this->db->where(array('md5(id)'=>$id,'id_company'=>$this->id_company));
        $delete =$this->db->delete($this->table);
        if($delete){
            $this->fungsi->delete_fileupload($predir_file);
            return  __response_delete(true);
        }else{
            return  __response_delete(false);
        }
    }

}