<?php

class Notif_m extends CI_Model {

    public function insertNotifPublishTarget($nama_lengkap) {
        $data = array(
            'id_notif'        => generate_id('id_notif_kpi', $this->id_company),
            'id_karyawan'     => htmlentities($this->input->post('karyawan')),
            'id_karyawan_kpi' => htmlentities($this->input->post('karyawan')),
            'jenis'           => 'kpi',
            'bulan'           => htmlentities($this->input->post('bulan')),
            'tahun'           => htmlentities($this->input->post('tahun')),
            'nama_lengkap'    => $nama_lengkap,
            'rute'            => 'detail_pengajuan_kpi_saya',
            'ket_notif'       => $this->nm_karyawan.' publish pengajuan KPI aspek kinerja',
            'status'          => '6',
            'id_company'      => $this->id_company,
            'flag_baca'       => '0',
        );

        $this->db->insert('notif_kpi', $data);
    }

    public function updateNotifPublishTarget($data) {
        $cek = $this->cekNotifPublishTargetBelumDibaca($data);
        if($cek->num_rows() > 0) {
            $this->db->set('flag_baca', '1');
            $this->db->where('id_notif', $cek->row()->id_notif);
            $this->db->update('notif_kpi');
        }
    }

    private function cekNotifPublishTargetBelumDibaca($data) {
        $this->db->select('id_notif');
        $this->db->where('id_karyawan_kpi', $data['data_karyawan']->id_karyawan);
        $this->db->where('tahun', $data['tahun']);
        $this->db->where('bulan', $data['bulan']);
        $this->db->where('status', '6');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('flag_baca', '0');
        return $this->db->get('notif_kpi');
    }

    public function getDataNotif($id_karyawan) {
        $this->db->select('users.token_fcm, data_karyawan.nama_lengkap');
        $this->db->from('users');
        $this->db->join('data_karyawan', 'data_karyawan.id_karyawan = users.id_karyawan');
        $this->db->where('users.id_karyawan', $id_karyawan);
        return $this->db->get();
    }

    public function insertNotifAjukanActual($id_atasan) {
        $data = array(
            'id_notif'        => generate_id('id_notif_kpi', $this->id_company),
            'id_karyawan'     => $id_atasan,
            'id_karyawan_kpi' => htmlentities($this->input->post('karyawan')),
            'jenis'           => 'kpi',
            'bulan'           => htmlentities($this->input->post('bulan')),
            'tahun'           => htmlentities($this->input->post('tahun')),
            'nama_lengkap'    => $this->nm_karyawan,
            'rute'            => 'pengajuan_kpi_approval_team',
            'ket_notif'       => $this->nm_karyawan.' mengajukan actual approval KPI',
            'status'          => '1',
            'id_company'      => $this->id_company,
            'flag_baca'       => '0',
        );

        $this->db->insert('notif_kpi', $data);
    }

    public function updateNotifAjukanActual($data) {
        $cek = $this->cekNotifAjukanActualBelumDibaca($data);
        if($cek->num_rows() > 0) {
            $this->db->set('flag_baca', '1');
            $this->db->where('id_notif', $cek->row()->id_notif);
            $this->db->update('notif_kpi');
        }
    }

    private function cekNotifAjukanActualBelumDibaca($data) {
        $this->db->select('id_notif');
        $this->db->where('id_karyawan_kpi', $data['data_karyawan']->id_karyawan);
        $this->db->where('tahun', $data['tahun']);
        $this->db->where('bulan', $data['bulan']);
        $this->db->where('status', '1');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('flag_baca', '0');
        return $this->db->get('notif_kpi');
    }

    public function insertNotifApproval($nama_lengkap) {
        $data = array(
            'id_notif'        => generate_id('id_notif_kpi', $this->id_company),
            'id_karyawan'     => htmlentities($this->input->post('karyawan')),
            'id_karyawan_kpi' => htmlentities($this->input->post('karyawan')),
            'jenis'           => 'kpi',
            'bulan'           => htmlentities($this->input->post('bulan')),
            'tahun'           => htmlentities($this->input->post('tahun')),
            'nama_lengkap'    => $nama_lengkap,
            'rute'            => 'detail_approval_kpi_saya',
            'ket_notif'       => 'Pengajuan KPI telah di setujui oleh '.$this->nm_karyawan.' silahkan terima KPI anda',
            'status'          => '4',
            'id_company'      => $this->id_company,
            'flag_baca'       => '0',
        );

        $this->db->insert('notif_kpi', $data);
    }

    public function updateNotifApproval($data) {
        $cek = $this->cekNotifApprovalBelumDibaca($data);
        if($cek->num_rows() > 0) {
            $this->db->set('flag_baca', '1');
            $this->db->where('id_notif', $cek->row()->id_notif);
            $this->db->update('notif_kpi');
        }
    }

    private function cekNotifApprovalBelumDibaca($data) {
        $this->db->select('id_notif');
        $this->db->where('id_karyawan_kpi', $data['data_karyawan']->id_karyawan);
        $this->db->where('tahun', $data['tahun']);
        $this->db->where('bulan', $data['bulan']);
        $this->db->where('status', '4');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('flag_baca', '0');
        return $this->db->get('notif_kpi');
    }

    public function insertNotifTerima($id_atasan) {
        $data = array(
            'id_notif'        => generate_id('id_notif_kpi', $this->id_company),
            'id_karyawan'     => $id_atasan,
            'id_karyawan_kpi' => htmlentities($this->input->post('karyawan')),
            'jenis'           => 'kpi',
            'bulan'           => htmlentities($this->input->post('bulan')),
            'tahun'           => htmlentities($this->input->post('tahun')),
            'nama_lengkap'    => $this->nm_karyawan,
            'rute'            => 'detail_kpi_approval_diterima_team',
            'ket_notif'       => 'Pengajuan KPI telah diterima oleh '.$this->nm_karyawan,
            'status'          => '9',
            'id_company'      => $this->id_company,
            'flag_baca'       => '0',
        );

        $this->db->insert('notif_kpi', $data);
    }

    public function updateNotifTerima($data) {
        $cek = $this->cekNotifTerimaBelumDibaca($data);
        if($cek->num_rows() > 0) {
            $this->db->set('flag_baca', '1');
            $this->db->where('id_notif', $cek->row()->id_notif);
            $this->db->update('notif_kpi');
        }
    }

    private function cekNotifTerimaBelumDibaca($data) {
        $this->db->select('id_notif');
        $this->db->where('id_karyawan_kpi', $data['data_karyawan']->id_karyawan);
        $this->db->where('tahun', $data['tahun']);
        $this->db->where('bulan', $data['bulan']);
        $this->db->where('status', '9');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('flag_baca', '0');
        return $this->db->get('notif_kpi');
    }

}